/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.energon.power;

import com.google.common.collect.Lists;
import fiskfille.tf.helper.TFFormatHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class EnergyStorage {
    protected final float maxEnergy;
    protected float energy;
    protected float energyUsage;
    protected float lastEnergy;

    public EnergyStorage(float max) {
        this.maxEnergy = max;
    }

    public EnergyStorage copy() {
        EnergyStorage storage = new EnergyStorage(this.getMaxEnergy());
        storage.energy = this.energy;
        storage.energyUsage = this.energyUsage;
        storage.lastEnergy = this.lastEnergy;
        return storage;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeFloat(this.energy);
        buf.writeFloat(this.energyUsage);
    }

    public void fromBytes(ByteBuf buf) {
        this.energy = buf.readFloat();
        this.energyUsage = buf.readFloat();
        this.lastEnergy = this.energy - this.energyUsage;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound storage = nbt.func_74775_l("EmB");
        this.energy = storage.func_74760_g("Energy");
        this.energyUsage = storage.func_74760_g("Usage");
        this.lastEnergy = this.energy - this.energyUsage;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound storage = nbt.func_74775_l("EmB");
        storage.func_74776_a("Energy", this.energy);
        storage.func_74776_a("Usage", this.energyUsage);
        nbt.func_74782_a("EmB", (NBTBase)storage);
    }

    public float remove(float amount, boolean simulate) {
        float actual = Math.min(amount, this.getEnergy());
        if (!simulate) {
            this.energy -= actual;
        }
        return actual;
    }

    public float add(float amount, boolean simulate) {
        float actual = Math.max(Math.min(amount, this.getMaxEnergy() - this.getEnergy()), 0.0f);
        if (!simulate) {
            this.energy += actual;
        }
        return actual;
    }

    public float getEnergy() {
        if ((double)this.energy <= 1.0E-16) {
            this.energy = 0.0f;
        }
        return this.energy;
    }

    public float getMaxEnergy() {
        return this.maxEnergy;
    }

    public float set(float amount) {
        this.energy = Math.min(this.getMaxEnergy(), Math.max(0.0f, amount));
        return this.energy;
    }

    public void setUsage(float usage) {
        this.energyUsage = usage;
        this.lastEnergy = this.energy;
    }

    public float getUsage() {
        return this.energyUsage;
    }

    public float calculateUsage() {
        this.energyUsage = this.energy - this.lastEnergy;
        this.lastEnergy = this.energy;
        return this.energyUsage;
    }

    public List<IChatComponent> format() {
        ArrayList list = Lists.newArrayList();
        float usage = this.getUsage();
        IChatComponent gain = new ChatComponentText("+").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GREEN));
        IChatComponent loss = new ChatComponentText("-").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED));
        ChatComponentText rate = new ChatComponentText(TFFormatHelper.formatNumberPrecise(Math.abs(usage)) + "");
        IChatComponent prefix = new ChatComponentText("").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY));
        prefix = usage > 0.0f ? gain : (usage < 0.0f ? loss : prefix);
        list.add(new ChatComponentTranslation("gui.emb.storage", new Object[]{TFFormatHelper.formatNumber(this.getEnergy()), TFFormatHelper.formatNumber(this.getMaxEnergy())}));
        list.add(new ChatComponentTranslation("gui.emb.rate", new Object[]{prefix.func_150257_a((IChatComponent)rate)}).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY)));
        return list;
    }
}

