/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.data.tile;

import fiskfille.tf.common.data.tile.TileData;
import fiskfille.tf.common.data.tile.TileDataEnergyContainer;
import fiskfille.tf.common.energon.power.TransmissionHandler;
import fiskfille.tf.helper.TFTileHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TileDataTransmitterBase
extends TileDataEnergyContainer {
    public TransmissionHandler transmissionHandler = new TransmissionHandler();

    public TileDataTransmitterBase() {
    }

    public TileDataTransmitterBase(float max) {
        super(max);
    }

    public TileDataTransmitterBase(TileDataTransmitterBase data) {
        super(data);
        this.transmissionHandler = data.transmissionHandler;
        this.transmissionHandler.setNeedsUpdate(false);
    }

    @Override
    public <T extends TileEntity> T initialize(T tile) {
        if (!this.isInitialized()) {
            this.transmissionHandler.setOwner(tile);
        }
        return super.initialize(tile);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        this.transmissionHandler.toBytes(buf);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.transmissionHandler.fromBytes(buf);
    }

    public void serverTickPre() {
        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(this.getCoords().dimension);
        if (world != null) {
            this.transmissionHandler.onUpdate((World)world);
        }
    }

    @Override
    public void kill() {
        if (TFTileHelper.getTileData(this.getCoords()) != null) {
            this.transmissionHandler.kill();
        }
        super.kill();
    }

    @Override
    public boolean matches(TileData tileData) {
        if (tileData instanceof TileDataTransmitterBase) {
            return super.matches(tileData) && !this.transmissionHandler.needsUpdate();
        }
        return false;
    }
}

