/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.data.tile;

import fiskfille.tf.common.data.tile.TileData;
import fiskfille.tf.common.data.tile.TileDataTransmitterBase;
import fiskfille.tf.common.fluid.FluidTankTF;
import fiskfille.tf.helper.TFHelper;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fluids.FluidStack;

public class TileDataTransmitter
extends TileDataTransmitterBase {
    public FluidTankTF tank;

    public TileDataTransmitter() {
    }

    public TileDataTransmitter(float maxEnergy, int fluidCapacity) {
        super(maxEnergy);
        this.tank = new FluidTankTF(fluidCapacity);
    }

    public TileDataTransmitter(TileDataTransmitter data) {
        super(data);
        this.tank = data.tank.copy();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.getCapacity());
        this.tank.toBytes(buf);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.tank = new FluidTankTF(buf.readInt());
        this.tank.fromBytes(buf);
    }

    @Override
    public void serverTick() {
        this.tank.calculateUsage();
        super.serverTick();
    }

    @Override
    public void clientTick() {
        TFHelper.applyFluidUsage(this.tank);
        super.clientTick();
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public int getUsage() {
        return this.tank.getUsage();
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    @Override
    public boolean matches(TileData tileData) {
        if (tileData instanceof TileDataTransmitter) {
            TileDataTransmitter data = (TileDataTransmitter)tileData;
            return super.matches(tileData) && this.getUsage() == data.getUsage() && FluidStack.areFluidStackTagsEqual((FluidStack)this.getFluid(), (FluidStack)data.getFluid());
        }
        return false;
    }
}

