/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.data.tile;

import com.google.common.collect.Lists;
import fiskfille.tf.common.data.tile.TileData;
import fiskfille.tf.common.energon.power.TransmissionHandler;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.helper.TFTileHelper;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TileDataRelay
extends TileData {
    public TransmissionHandler transmissionHandler = new TransmissionHandler();
    public List<ItemCSD.DimensionalCoords> invertCurrent = Lists.newArrayList();
    public boolean isPowered;

    public TileDataRelay() {
    }

    public TileDataRelay(TileDataRelay data) {
        super(data);
        this.transmissionHandler = data.transmissionHandler;
        this.transmissionHandler.setNeedsUpdate(false);
        this.isPowered = data.isPowered;
        this.invertCurrent = Lists.newArrayList(data.invertCurrent);
    }

    @Override
    public <T extends TileEntity> T initialize(T tile) {
        if (!this.isInitialized()) {
            this.transmissionHandler.setOwner(tile);
        }
        return super.initialize(tile);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        this.transmissionHandler.toBytes(buf);
        buf.writeBoolean(this.isPowered);
        buf.writeInt(this.invertCurrent.size());
        for (ItemCSD.DimensionalCoords coords : this.invertCurrent) {
            coords.toBytes(buf);
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.transmissionHandler.fromBytes(buf);
        this.isPowered = buf.readBoolean();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.invertCurrent.add(new ItemCSD.DimensionalCoords().fromBytes(buf));
        }
    }

    public void serverTickPre() {
        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(this.getCoords().dimension);
        if (world != null) {
            this.transmissionHandler.onUpdate((World)world);
        }
    }

    @Override
    public void kill() {
        if (TFTileHelper.getTileData(this.getCoords()) != null) {
            this.transmissionHandler.kill();
        }
        super.kill();
    }

    @Override
    public boolean matches(TileData tileData) {
        if (tileData instanceof TileDataRelay) {
            TileDataRelay data = (TileDataRelay)tileData;
            return this.isPowered == data.isPowered && !this.transmissionHandler.needsUpdate() && this.invertCurrent.size() == data.invertCurrent.size() && this.invertCurrent.containsAll(data.invertCurrent);
        }
        return false;
    }
}

