/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.data.tile;

import fiskfille.tf.common.data.tile.TileData;
import fiskfille.tf.common.energon.power.EnergyStorage;
import fiskfille.tf.helper.TFEnergyHelper;
import io.netty.buffer.ByteBuf;

public class TileDataEnergyContainer
extends TileData {
    public EnergyStorage storage;

    public TileDataEnergyContainer() {
    }

    public TileDataEnergyContainer(EnergyStorage energyStorage) {
        this.storage = energyStorage;
    }

    public TileDataEnergyContainer(float max) {
        this(new EnergyStorage(max));
    }

    public TileDataEnergyContainer(TileDataEnergyContainer data) {
        super(data);
        this.storage = data.storage.copy();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeFloat(this.getMaxEnergy());
        this.storage.toBytes(buf);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.storage = new EnergyStorage(buf.readFloat());
        this.storage.fromBytes(buf);
    }

    @Override
    public void serverTick() {
        this.storage.calculateUsage();
        super.serverTick();
    }

    @Override
    public void clientTick() {
        TFEnergyHelper.applyEnergyUsage(this.storage);
    }

    public float getEnergy() {
        return this.storage.getEnergy();
    }

    public float getEnergyUsage() {
        return this.storage.getUsage();
    }

    public float getMaxEnergy() {
        return this.storage.getMaxEnergy();
    }

    @Override
    public boolean matches(TileData tileData) {
        if (tileData instanceof TileDataEnergyContainer) {
            TileDataEnergyContainer data = (TileDataEnergyContainer)tileData;
            return Math.abs(this.getEnergyUsage() - data.getEnergyUsage()) <= 0.001f;
        }
        return false;
    }
}

