/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.data.tile;

import fiskfille.tf.common.data.tile.TileData;
import fiskfille.tf.common.fluid.FluidTankTF;
import fiskfille.tf.helper.TFHelper;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fluids.FluidStack;

public class TileDataEnergonTank
extends TileData {
    public FluidTankTF tank;

    public TileDataEnergonTank() {
    }

    public TileDataEnergonTank(FluidTankTF fluidTank) {
        this.tank = fluidTank;
    }

    public TileDataEnergonTank(int max) {
        this(new FluidTankTF(max));
    }

    public TileDataEnergonTank(TileDataEnergonTank data) {
        super(data);
        this.tank = data.tank.copy();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.getCapacity());
        this.tank.toBytes(buf);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.tank = new FluidTankTF(buf.readInt());
        this.tank.fromBytes(buf);
    }

    @Override
    public void serverTick() {
        this.tank.calculateUsage();
        super.serverTick();
    }

    @Override
    public void clientTick() {
        TFHelper.applyFluidUsage(this.tank);
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public int getUsage() {
        return this.tank.getUsage();
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    @Override
    public boolean matches(TileData tileData) {
        if (tileData instanceof TileDataEnergonTank) {
            TileDataEnergonTank data = (TileDataEnergonTank)tileData;
            return this.getUsage() == data.getUsage() && FluidStack.areFluidStackTagsEqual((FluidStack)this.getFluid(), (FluidStack)data.getFluid());
        }
        return false;
    }
}

