/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.data.tile;

import com.google.common.collect.Lists;
import fiskfille.tf.common.data.tile.TileData;
import fiskfille.tf.common.data.tile.TileDataEnergyContainer;
import fiskfille.tf.common.groundbridge.DataCore;
import fiskfille.tf.common.groundbridge.GroundBridgeError;
import fiskfille.tf.common.item.ItemCSD;
import io.netty.buffer.ByteBuf;
import java.util.List;

public class TileDataControlPanel
extends TileDataEnergyContainer {
    public ItemCSD.DimensionalCoords framePos;
    public ItemCSD.DimensionalCoords destination = new ItemCSD.DimensionalCoords();
    public int modifiedDestY;
    public int direction;
    public int frameDirection;
    public boolean activationLeverState = false;
    public List<DataCore> upgrades = Lists.newArrayList();
    public List<GroundBridgeError.ErrorContainer> errors = Lists.newArrayList();

    public TileDataControlPanel() {
        super(64000.0f);
    }

    public TileDataControlPanel(TileDataControlPanel data) {
        super(data);
        this.framePos = ItemCSD.DimensionalCoords.copy(data.framePos);
        this.destination = ItemCSD.DimensionalCoords.copy(data.destination);
        this.modifiedDestY = data.modifiedDestY;
        this.direction = data.direction;
        this.frameDirection = data.frameDirection;
        this.activationLeverState = data.activationLeverState;
        this.upgrades = Lists.newArrayList(data.upgrades);
        this.errors = Lists.newArrayList(data.errors);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.modifiedDestY);
        buf.writeByte(this.direction & 0xFF);
        buf.writeByte(this.frameDirection & 0xFF);
        buf.writeBoolean(this.activationLeverState);
        buf.writeByte(this.upgrades.size() & 0xFF);
        for (DataCore core : this.upgrades) {
            buf.writeByte(core.index & 0xFF);
        }
        buf.writeByte(this.errors.size() & 0xFF);
        for (GroundBridgeError.ErrorContainer container : this.errors) {
            container.toBytes(buf);
        }
        if (this.framePos != null) {
            buf.writeBoolean(true);
            this.framePos.toBytes(buf);
        } else {
            buf.writeBoolean(false);
        }
        this.destination.toBytes(buf);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.modifiedDestY = buf.readInt();
        this.direction = buf.readByte() & 0xFF;
        this.frameDirection = buf.readByte() & 0xFF;
        this.activationLeverState = buf.readBoolean();
        this.upgrades = Lists.newArrayList();
        int upgradeCount = buf.readByte() & 0xFF;
        for (int i = 0; i < upgradeCount; ++i) {
            int index = buf.readByte() & 0xFF;
            DataCore core = DataCore.get(index);
            if (core == null) continue;
            this.upgrades.add(core);
        }
        this.errors = Lists.newArrayList();
        int errorCount = buf.readByte() & 0xFF;
        for (int i = 0; i < errorCount; ++i) {
            GroundBridgeError.ErrorContainer container = GroundBridgeError.ErrorContainer.fromBytes(buf);
            if (container == null) continue;
            this.errors.add(container);
        }
        if (buf.readBoolean()) {
            this.framePos = new ItemCSD.DimensionalCoords().fromBytes(buf);
        }
        this.destination.fromBytes(buf);
    }

    public boolean hasUpgrade(DataCore core) {
        return this.upgrades.contains(core);
    }

    @Override
    public boolean matches(TileData tileData) {
        if (tileData instanceof TileDataControlPanel) {
            boolean coresEqual;
            boolean errorsEqual;
            TileDataControlPanel data = (TileDataControlPanel)tileData;
            boolean frameEquals = data.framePos == null && this.framePos == null || data.framePos != null && data.framePos.equals((Object)this.framePos);
            boolean destinationEquals = data.destination.equals((Object)this.destination) && data.modifiedDestY == this.modifiedDestY;
            boolean bl = errorsEqual = data.errors.size() == this.errors.size();
            if (errorsEqual) {
                for (int i = 0; i < data.errors.size(); ++i) {
                    if (data.errors.get(i).equals(this.errors.get(i))) continue;
                    errorsEqual = false;
                    break;
                }
            }
            boolean bl2 = coresEqual = data.upgrades.size() == this.upgrades.size();
            if (coresEqual) {
                for (int i = 0; i < data.upgrades.size(); ++i) {
                    if (data.upgrades.get((int)i).index == this.upgrades.get((int)i).index) continue;
                    coresEqual = false;
                    break;
                }
            }
            return super.matches(data) && frameEquals && coresEqual && errorsEqual && destinationEquals && data.activationLeverState == this.activationLeverState && data.direction == this.direction && data.frameDirection == this.frameDirection;
        }
        return false;
    }
}

