/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.data.tile;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.common.network.MessageSetTileData;
import fiskfille.tf.common.network.base.TFNetworkManager;
import fiskfille.tf.helper.TFTileHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;

public abstract class TileData {
    private ItemCSD.DimensionalCoords coords;
    private boolean init = false;

    public TileData() {
    }

    public TileData(TileData data) {
        this.coords = ItemCSD.DimensionalCoords.copy(data.coords);
        this.init = data.init;
    }

    public boolean isInitialized() {
        return this.init;
    }

    public <T extends TileEntity> T initialize(T tile) {
        if (!this.isInitialized()) {
            this.init = true;
            this.coords = new ItemCSD.DimensionalCoords(tile);
        }
        return tile;
    }

    public void toBytes(ByteBuf buf) {
        this.coords.toBytes(buf);
        buf.writeBoolean(this.init);
    }

    public void fromBytes(ByteBuf buf) {
        this.coords = new ItemCSD.DimensionalCoords().fromBytes(buf);
        this.init = buf.readBoolean();
    }

    public ItemCSD.DimensionalCoords getCoords() {
        return this.coords;
    }

    public void serverTick() {
        if (!this.equals(TFTileHelper.getTileData(this.coords))) {
            TFNetworkManager.networkWrapper.sendToAll((IMessage)new MessageSetTileData(this));
            if ("0.6.3".equals("${version}")) {
                System.out.println("Syncing " + this.getClass().getSimpleName() + " at " + (Object)((Object)this.coords));
            }
        }
        TFTileHelper.putServerData(this);
    }

    public void clientTick() {
    }

    public void kill() {
        if (TFTileHelper.getTileData(this.coords) != null) {
            TFNetworkManager.networkWrapper.sendToAll((IMessage)new MessageSetTileData(this.coords, null));
            TFTileHelper.putServerData(this.coords, null);
        }
    }

    public final boolean equals(Object obj) {
        if (obj instanceof TileData) {
            TileData data = (TileData)obj;
            return this.getCoords().equals((Object)data.getCoords()) && this.matches(data);
        }
        return false;
    }

    public abstract boolean matches(TileData var1);
}

