/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.data;

import com.google.common.collect.Maps;
import fiskfille.tf.common.item.ItemMetaBasic;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;

public class TFWorldData
extends WorldSavedData {
    public static final String KEY = "TFWorld";
    public static TFWorldData instance;
    public Map<String, Integer> subItems = Maps.newHashMap();

    public TFWorldData(String s) {
        super(s);
    }

    public static TFWorldData load(World world) {
        if (!world.field_72995_K) {
            MapStorage storage = world.perWorldStorage;
            TFWorldData data = (TFWorldData)storage.func_75742_a(TFWorldData.class, KEY);
            if (data == null) {
                data = new TFWorldData(KEY);
                data.func_76185_a();
                storage.func_75745_a(KEY, (WorldSavedData)data);
            }
            instance = data;
            return instance;
        }
        instance = new TFWorldData(KEY);
        return instance;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("SubItems", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = list.func_150305_b(i);
            String name = nbttagcompound.func_74779_i("name");
            if (!Arrays.asList(ItemMetaBasic.iconNames).contains(name)) continue;
            this.subItems.put(name, nbttagcompound.func_74762_e("id"));
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<String, Integer> e : this.subItems.entrySet()) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("id", e.getValue().intValue());
            nbttagcompound.func_74778_a("name", e.getKey());
            list.func_74742_a((NBTBase)nbttagcompound);
        }
        nbt.func_74782_a("SubItems", (NBTBase)list);
    }

    public static TFWorldData get(World world) {
        if (instance == null && world.field_72995_K) {
            instance = TFWorldData.load(world);
        }
        return instance;
    }

    public int getNextAvailableId() {
        int id = 0;
        while (this.subItems.containsValue(id)) {
            ++id;
        }
        return id;
    }
}

