/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.data;

import com.google.common.base.Predicate;
import fiskfille.tf.common.data.TFData;
import fiskfille.tf.common.transformer.base.Transformer;
import fiskfille.tf.helper.TFHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

public class TFPredicates {
    public static Predicate<EntityPlayer> and(final Predicate ... predicates) {
        return new Predicate<EntityPlayer>(){

            public boolean apply(EntityPlayer input) {
                for (Predicate p : predicates) {
                    if (p.apply((Object)input)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Predicate<EntityPlayer> or(final Predicate ... predicates) {
        return new Predicate<EntityPlayer>(){

            public boolean apply(EntityPlayer input) {
                for (Predicate p : predicates) {
                    if (!p.apply((Object)input)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<EntityPlayer> not(final Predicate p) {
        return new Predicate<EntityPlayer>(){

            public boolean apply(EntityPlayer input) {
                return !p.apply((Object)input);
            }
        };
    }

    public static Predicate<EntityPlayer> isTransformer() {
        return new Predicate<EntityPlayer>(){

            public boolean apply(EntityPlayer input) {
                return TFHelper.isTransformer((EntityLivingBase)input);
            }
        };
    }

    public static Predicate<EntityPlayer> isTransformer(final Transformer transformer) {
        return new Predicate<EntityPlayer>(){

            public boolean apply(EntityPlayer input) {
                return TFHelper.getTransformer((EntityLivingBase)input) == transformer;
            }
        };
    }

    public static Predicate<EntityPlayer> isInVehicleMode() {
        return new Predicate<EntityPlayer>(){

            public boolean apply(EntityPlayer input) {
                return TFHelper.isFullyTransformed(input);
            }
        };
    }

    public static Predicate<EntityPlayer> hasStealthForce() {
        return new Predicate<EntityPlayer>(){

            public boolean apply(EntityPlayer input) {
                Transformer transformer = TFHelper.getTransformer((EntityLivingBase)input);
                return transformer != null && transformer.hasStealthForce(input, TFData.ALT_MODE.get(input));
            }
        };
    }

    public static Predicate<EntityPlayer> isSneaking() {
        return new Predicate<EntityPlayer>(){

            public boolean apply(EntityPlayer input) {
                return input.func_70093_af();
            }
        };
    }

    public static Predicate<EntityPlayer> isBacking() {
        return new Predicate<EntityPlayer>(){

            public boolean apply(EntityPlayer input) {
                return input.field_70701_bs < 0.0f;
            }
        };
    }

    public static Predicate<EntityPlayer> isFlying() {
        return new Predicate<EntityPlayer>(){

            public boolean apply(EntityPlayer input) {
                return input.field_71075_bZ.field_75100_b;
            }
        };
    }
}

