/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.data;

import com.google.common.collect.Maps;
import fiskfille.tf.common.data.TFData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class TFPlayerData
implements IExtendedEntityProperties {
    public static final String IDENTIFIER = "TFPlayer";
    public Map<TFData, Object> data = this.createDataMap();

    public static TFPlayerData getData(EntityPlayer player) {
        return (TFPlayerData)player.getExtendedProperties(IDENTIFIER);
    }

    private Map<TFData, Object> createDataMap() {
        HashMap map = Maps.newHashMap();
        for (TFData<?> data : TFData.VALUES) {
            map.put(data, data.defaultValue);
        }
        return map;
    }

    public void onUpdate() {
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74757_a("Saved", true);
        TFData.writeToNBT(nbttagcompound, this.data);
        compound.func_74782_a(IDENTIFIER, (NBTBase)nbttagcompound);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound nbttagcompound = compound.func_74775_l(IDENTIFIER);
        if (nbttagcompound.func_74767_n("Saved")) {
            this.data = TFData.readFromNBT(nbttagcompound, this.data);
        }
    }

    public void init(Entity entity, World world) {
        if (entity instanceof EntityPlayer) {
            // empty if block
        }
    }

    public void copy(TFPlayerData props) {
        this.data = props.data;
    }

    public <T> void putData(TFData<T> type, T value) {
        this.data.put(type, value);
    }

    public <T> T getData(TFData<T> type) {
        return (T)this.data.get(type);
    }
}

