/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.data;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import fiskfille.tf.TransformersAPI;
import fiskfille.tf.common.achievement.TFAchievements;
import fiskfille.tf.common.data.TFDataPrev;
import fiskfille.tf.common.data.TFPlayerData;
import fiskfille.tf.common.data.TFPredicates;
import fiskfille.tf.common.event.PlayerTransformEvent;
import fiskfille.tf.common.network.MessagePlayerData;
import fiskfille.tf.common.network.base.TFNetworkManager;
import fiskfille.tf.common.transformer.base.Transformer;
import fiskfille.tf.helper.TFFormatHelper;
import fiskfille.tf.helper.TFHelper;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.stats.StatBase;
import net.minecraftforge.common.MinecraftForge;

public class TFData<T> {
    public static final TFData<Integer> ALT_MODE = new TFData<Integer>(-1, TFPredicates.isTransformer());
    public static final TFData<Boolean> STEALTH_FORCE = new TFData<Boolean>(false, TFPredicates.and(TFPredicates.isInVehicleMode(), TFPredicates.hasStealthForce()));
    public static final TFData<Float> TRANSFORM_PROGRESS = new TFData<Float>(Float.valueOf(0.0f), TFPredicates.isTransformer());
    public static final TFData<Float> STEALTH_FORCE_PROGRESS = new TFData<Float>(Float.valueOf(0.0f), TFPredicates.isInVehicleMode());
    public static final TFData<Double> FORWARD_VELOCITY = new TFData<Double>(0.0, (Predicate<EntityPlayer>)Predicates.alwaysTrue());
    public static final TFData<Double> HORIZONTAL_VELOCITY = new TFData<Double>(0.0, (Predicate<EntityPlayer>)Predicates.alwaysTrue());
    public static final TFData<Boolean> BOOSTING = new TFData<Boolean>(false, (Predicate<EntityPlayer>)Predicates.alwaysTrue());
    public static final TFData<Float> NITRO = new TFData<Float>(Float.valueOf(1.0f), (Predicate<EntityPlayer>)Predicates.alwaysTrue());
    public static final TFData<Integer> PREV_ALT_MODE = new TFDataPrev(ALT_MODE);
    public static final TFData<Float> PREV_TRANSFORM_PROGRESS = new TFData<Float>(Float.valueOf(0.0f), TFPredicates.isTransformer());
    public static final TFData<Float> PREV_STEALTH_FORCE_PROGRESS = new TFData<Float>(Float.valueOf(0.0f), TFPredicates.isInVehicleMode());
    public static final TFData<Transformer> PREV_TRANSFORMER = new TFData<Object>(null, (Predicate<EntityPlayer>)Predicates.alwaysTrue());
    public static final TFData<Float> PREV_NITRO = new TFData<Float>(Float.valueOf(1.0f), (Predicate<EntityPlayer>)Predicates.alwaysTrue());
    public static final List<TFData<?>> VALUES = Lists.newArrayList();
    public String id;
    public final boolean save;
    public final T defaultValue;

    protected TFData(T defaultValue, Predicate<EntityPlayer> canSet) {
        this(true, defaultValue, canSet);
    }

    protected TFData(boolean save, T defaultValue, Predicate<EntityPlayer> canSet) {
        this.save = save;
        this.defaultValue = defaultValue;
    }

    public Predicate<EntityPlayer> predicate(final TFData data, final T value) {
        return new Predicate<EntityPlayer>(){

            public boolean apply(EntityPlayer input) {
                return value == null ? data.get(input) == value : data.get(input) == value || data.get(input).equals(value);
            }
        };
    }

    public boolean set(EntityPlayer player, T value) {
        if ((this.get(player) == null || !this.get(player).equals(value)) && this.setWithoutNotify(player, value)) {
            if (player.field_70170_p.field_72995_K) {
                TFNetworkManager.networkWrapper.sendToServer((IMessage)new MessagePlayerData(player, this, value));
            } else {
                TFNetworkManager.networkWrapper.sendToDimension((IMessage)new MessagePlayerData(player, this, value), player.field_71093_bK);
            }
            return true;
        }
        return false;
    }

    public boolean setWithoutNotify(EntityPlayer player, T value) {
        if (this.get(player) == null || !this.get(player).equals(value)) {
            if (this == ALT_MODE) {
                if (!MinecraftForge.EVENT_BUS.post((Event)new PlayerTransformEvent(player, TFHelper.getTransformer((EntityLivingBase)player), (Integer)value, STEALTH_FORCE.get(player)))) {
                    player.func_71029_a((StatBase)TFAchievements.transform);
                    if ((Integer)value == -1) {
                        STEALTH_FORCE.setWithoutNotify(player, false);
                    }
                } else {
                    return false;
                }
            }
            for (TFData<?> type : VALUES) {
                if (!(type instanceof TFDataPrev) || ((TFDataPrev)type).tracking != this) continue;
                TFPlayerData.getData(player).putData(type, this.get(player));
            }
            TFPlayerData.getData(player).putData(this, value);
            return true;
        }
        return false;
    }

    public void incr(EntityPlayer player, T value) {
        if (value instanceof Integer) {
            Integer i = (Integer)this.get(player) + (Integer)value;
            this.set(player, i);
        } else if (value instanceof Float) {
            Float f = Float.valueOf(((Float)this.get(player)).floatValue() + ((Float)value).floatValue());
            this.set(player, f);
        } else if (value instanceof Double) {
            Double d = (Double)this.get(player) + (Double)value;
            this.set(player, d);
        } else if (value instanceof String) {
            String s = (String)this.get(player) + (String)value;
            this.set(player, s);
        } else {
            throw new RuntimeException("Cannot increment a non-numerical data type unless a String!");
        }
    }

    public void incrWithoutNotify(EntityPlayer player, T value) {
        if (value instanceof Integer) {
            Integer i = (Integer)this.get(player) + (Integer)value;
            this.setWithoutNotify(player, i);
        } else if (value instanceof Float) {
            Float f = Float.valueOf(((Float)this.get(player)).floatValue() + ((Float)value).floatValue());
            this.setWithoutNotify(player, f);
        } else if (value instanceof Double) {
            Double d = (Double)this.get(player) + (Double)value;
            this.setWithoutNotify(player, d);
        } else if (value instanceof String) {
            String s = (String)this.get(player) + (String)value;
            this.setWithoutNotify(player, s);
        } else {
            throw new RuntimeException("Cannot increment a non-numerical data type unless a String!");
        }
    }

    public void clamp(EntityPlayer player, T min, T max) {
        if (min instanceof Integer) {
            if ((Integer)this.get(player) < (Integer)min) {
                this.set(player, min);
            } else if ((Integer)this.get(player) > (Integer)max) {
                this.set(player, max);
            }
        } else if (min instanceof Float) {
            if (((Float)this.get(player)).floatValue() < ((Float)min).floatValue()) {
                this.set(player, min);
            } else if (((Float)this.get(player)).floatValue() > ((Float)max).floatValue()) {
                this.set(player, max);
            }
        } else if (min instanceof Double) {
            if ((Double)this.get(player) < (Double)min) {
                this.set(player, min);
            } else if ((Double)this.get(player) > (Double)max) {
                this.set(player, max);
            }
        } else {
            throw new RuntimeException("Cannot clamp a non-numerical data type!");
        }
    }

    public void clampWithoutNotify(EntityPlayer player, T min, T max) {
        if (min instanceof Integer) {
            if ((Integer)this.get(player) < (Integer)min) {
                this.setWithoutNotify(player, min);
            } else if ((Integer)this.get(player) > (Integer)max) {
                this.setWithoutNotify(player, max);
            }
        } else if (min instanceof Float) {
            if (((Float)this.get(player)).floatValue() < ((Float)min).floatValue()) {
                this.setWithoutNotify(player, min);
            } else if (((Float)this.get(player)).floatValue() > ((Float)max).floatValue()) {
                this.setWithoutNotify(player, max);
            }
        } else if (min instanceof Double) {
            if ((Double)this.get(player) < (Double)min) {
                this.setWithoutNotify(player, min);
            } else if ((Double)this.get(player) > (Double)max) {
                this.setWithoutNotify(player, max);
            }
        } else {
            throw new RuntimeException("Cannot clamp a non-numerical data type!");
        }
    }

    public T get(EntityPlayer player) {
        Object value = TFPlayerData.getData(player).getData(this);
        if (this == ALT_MODE && !TFHelper.isTransformer((EntityLivingBase)player) && (Integer)value != -1) {
            TFPlayerData.getData(player).putData(this, -1);
            value = -1;
        }
        return value;
    }

    public static NBTTagCompound writeToNBT(NBTTagCompound nbt, Map<TFData, Object> data) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        for (Map.Entry<TFData, Object> e : data.entrySet()) {
            if (!e.getKey().save) continue;
            Object obj = e.getValue();
            if (obj instanceof Transformer) {
                obj = ((Transformer)obj).getName();
            }
            e.getKey().writeDataToNBT(nbttagcompound, obj);
        }
        nbt.func_74782_a("DataArray", (NBTBase)nbttagcompound);
        return nbt;
    }

    public static Map<TFData, Object> readFromNBT(NBTTagCompound nbt, Map<TFData, Object> data) {
        NBTTagCompound nbttagcompound = nbt.func_74775_l("DataArray");
        for (TFData<?> type : VALUES) {
            Object obj;
            if (!type.save || (obj = type.readDataFromNBT(nbttagcompound)) == null) continue;
            if (type.defaultValue instanceof Transformer && obj instanceof String) {
                obj = TransformersAPI.getTransformerByName((String)obj);
            }
            data.put(type, obj);
        }
        return data;
    }

    public NBTTagCompound writeDataToNBT(NBTTagCompound nbt, Object obj) {
        String s;
        if (obj instanceof Integer) {
            nbt.func_74768_a(this.id, ((Integer)obj).intValue());
        } else if (obj instanceof Float) {
            nbt.func_74776_a(this.id, ((Float)obj).floatValue());
        } else if (obj instanceof Double) {
            nbt.func_74780_a(this.id, ((Double)obj).doubleValue());
        } else if (obj instanceof Boolean) {
            nbt.func_74757_a(this.id, ((Boolean)obj).booleanValue());
        } else if (obj instanceof String && (s = (String)obj) != null && !s.isEmpty()) {
            nbt.func_74778_a(this.id, s);
        }
        return nbt;
    }

    public Object readDataFromNBT(NBTTagCompound nbt) {
        NBTBase tag = nbt.func_74781_a(this.id);
        if (tag instanceof NBTTagInt) {
            return ((NBTTagInt)tag).func_150287_d();
        }
        if (tag instanceof NBTTagFloat) {
            return Float.valueOf(((NBTTagFloat)tag).func_150288_h());
        }
        if (tag instanceof NBTTagDouble) {
            return ((NBTTagDouble)tag).func_150286_g();
        }
        if (tag instanceof NBTTagByte) {
            return ((NBTTagByte)tag).func_150290_f() == 1;
        }
        if (tag instanceof NBTTagString) {
            return ((NBTTagString)tag).func_150285_a_();
        }
        return null;
    }

    static {
        for (Field field : TFData.class.getFields()) {
            String s = field.getType().getName();
            if (!s.equals(TFData.class.getName())) continue;
            try {
                TFData data = (TFData)field.get(null);
                data.id = TFFormatHelper.getUnconventionalName(field.getName());
                VALUES.add(data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

