/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fiskfille.tf.TFLog;
import fiskfille.tf.TransformersMod;
import fiskfille.tf.common.chunk.ForcedChunk;
import fiskfille.tf.common.chunk.SubTicket;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class TFChunkManager {
    private static Map<World, LinkedList<ForgeChunkManager.Ticket>> ticketsForWorld = Maps.newHashMap();
    private static Map<ForcedChunk, Integer> chunkForcers = Maps.newHashMap();

    public static void forceChunk(ForgeChunkManager.Ticket ticket, ForcedChunk chunk) {
        int i;
        int n = i = chunkForcers.get((Object)chunk) == null ? 0 : chunkForcers.get((Object)chunk);
        if (i == 0) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunk);
        }
        chunkForcers.put(chunk, ++i);
    }

    public static void releaseChunk(SubTicket subTicket, ForcedChunk chunk) {
        int i = chunkForcers.get((Object)chunk) == null ? 0 : chunkForcers.get((Object)chunk);
        subTicket.remove();
        if (i == 1) {
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)subTicket.owner, (ChunkCoordIntPair)chunk);
        }
        chunkForcers.put(chunk, Math.max(--i, 0));
        for (Map.Entry<World, LinkedList<ForgeChunkManager.Ticket>> e : ticketsForWorld.entrySet()) {
            for (int j = 0; j < ticketsForWorld.get(e.getKey()).size(); ++j) {
                ForgeChunkManager.Ticket ticket = ticketsForWorld.get(e.getKey()).get(j);
                if (ticket.getChunkList().size() != 0) continue;
                try {
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ticketsForWorld.get(e.getKey()).remove(j);
            }
        }
    }

    public static void clearCache() {
        ticketsForWorld.clear();
        chunkForcers.clear();
    }

    public static void debug() {
        int entries = 0;
        int chunks = 0;
        int tickets = 0;
        for (Map.Entry<World, LinkedList<ForgeChunkManager.Ticket>> e : ticketsForWorld.entrySet()) {
            if (e.getValue() == null) continue;
            for (int i = 0; i < e.getValue().size(); ++i) {
                ForgeChunkManager.Ticket ticket = e.getValue().get(i);
                chunks += ticket.getChunkList().size();
                for (int j = 0; j < ticket.getChunkList().size(); ++j) {
                    ChunkCoordIntPair coords = (ChunkCoordIntPair)ticket.getChunkList().asList().get(j);
                    Integer k = chunkForcers.get((Object)new ForcedChunk(ticket.world, coords.field_77276_a, coords.field_77275_b));
                    entries += k != null ? k : 0;
                }
            }
            tickets += e.getValue().size();
        }
        TFLog.info("%s entries / %s chunks / %s tickets", entries, chunks, tickets);
    }

    public static ForgeChunkManager.Ticket getTicketForChunk(ForcedChunk chunk) {
        World world = chunk.worldObj;
        if (ticketsForWorld.get(world) == null) {
            ticketsForWorld.put(world, new LinkedList());
        }
        for (int i = 0; i < ticketsForWorld.get(world).size(); ++i) {
            ForgeChunkManager.Ticket ticket = ticketsForWorld.get(world).get(i);
            List<SubTicket> list = SubTicket.getChildren(ticket);
            for (SubTicket subTicket : list) {
                if (subTicket.xCoord << 4 != chunk.field_77276_a || subTicket.zCoord << 4 != chunk.field_77275_b) continue;
                return ticket;
            }
        }
        return TFChunkManager.requestTicket(world);
    }

    public static ForgeChunkManager.Ticket requestTicket(World world) {
        if (ticketsForWorld.get(world) == null) {
            ticketsForWorld.put(world, new LinkedList());
        }
        return TFChunkManager.getNextAvailableTicket(world);
    }

    private static void newTicket(World world) {
        LinkedList<ForgeChunkManager.Ticket> list = ticketsForWorld.get(world);
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)TransformersMod.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (ticket != null) {
            list.add(ticket);
            ticketsForWorld.put(world, list);
        }
    }

    private static LinkedList<ForgeChunkManager.Ticket> getAvailableTickets(World world) {
        LinkedList list = Lists.newLinkedList();
        for (int i = 0; i < ticketsForWorld.get(world).size(); ++i) {
            ForgeChunkManager.Ticket ticket = ticketsForWorld.get(world).get(i);
            if (ticket.getChunkList().size() >= ticket.getMaxChunkListDepth()) continue;
            list.add(ticket);
        }
        if (list.isEmpty()) {
            TFChunkManager.newTicket(world);
        }
        return list;
    }

    private static ForgeChunkManager.Ticket getNextAvailableTicket(World world) {
        return TFChunkManager.getAvailableTickets(world).isEmpty() ? null : TFChunkManager.getAvailableTickets(world).getLast();
    }
}

