/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.chunk;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeChunkManager;

public class SubTicket {
    public ForgeChunkManager.Ticket owner;
    private NBTTagCompound nbtTag;
    public int xCoord;
    public int yCoord;
    public int zCoord;

    public SubTicket(int x, int y, int z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
    }

    public boolean matches(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SubTicket)) {
            return false;
        }
        SubTicket subTicket = (SubTicket)obj;
        return this.xCoord == subTicket.xCoord && this.yCoord == subTicket.yCoord && this.zCoord == subTicket.zCoord;
    }

    public NBTTagCompound getTag() {
        if (this.nbtTag == null) {
            this.nbtTag = new NBTTagCompound();
        }
        return this.nbtTag;
    }

    public SubTicket assign(ForgeChunkManager.Ticket ticket) {
        NBTTagList nbttaglist = ticket.getModData().func_150295_c("SubTickets", 10);
        nbttaglist.func_74742_a((NBTBase)this.writeToNBT());
        ticket.getModData().func_74782_a("SubTickets", (NBTBase)nbttaglist);
        this.owner = ticket;
        return this;
    }

    public ForgeChunkManager.Ticket remove() {
        List<SubTicket> list = SubTicket.getChildren(this.owner);
        ArrayList list1 = Lists.newArrayList();
        for (SubTicket subTicket : list) {
            if (this.matches(subTicket)) continue;
            list1.add(subTicket);
        }
        this.owner.getModData().func_74782_a("SubTickets", (NBTBase)new NBTTagList());
        for (SubTicket subTicket : list1) {
            this.assign(this.owner);
        }
        return this.owner;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74768_a("xCoord", this.xCoord);
        nbttagcompound.func_74768_a("yCoord", this.yCoord);
        nbttagcompound.func_74768_a("zCoord", this.zCoord);
        nbttagcompound.func_74782_a("Tag", (NBTBase)this.getTag());
        return nbttagcompound;
    }

    public static SubTicket readFromNBT(NBTTagCompound nbttagcompound) {
        SubTicket subTicket = new SubTicket(nbttagcompound.func_74762_e("xCoord"), nbttagcompound.func_74762_e("yCoord"), nbttagcompound.func_74762_e("zCoord"));
        subTicket.nbtTag = nbttagcompound.func_74775_l("Tag");
        return subTicket;
    }

    public static List<SubTicket> getChildren(ForgeChunkManager.Ticket ticket) {
        ArrayList list = Lists.newArrayList();
        NBTTagList nbttaglist = ticket.getModData().func_150295_c("SubTickets", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            SubTicket subTicket = SubTicket.readFromNBT(nbttaglist.func_150305_b(i));
            subTicket.owner = ticket;
            list.add(subTicket);
        }
        return list;
    }

    public static SubTicket get(ForgeChunkManager.Ticket ticket, TileEntity tile) {
        List<SubTicket> list = SubTicket.getChildren(ticket);
        for (SubTicket subTicket : list) {
            if (subTicket.xCoord != tile.field_145851_c || subTicket.yCoord != tile.field_145848_d || subTicket.zCoord != tile.field_145849_e) continue;
            return subTicket;
        }
        return null;
    }

    public static SubTicket fromTile(TileEntity tile) {
        return SubTicket.fromTile(null, tile);
    }

    public static SubTicket fromTile(ForgeChunkManager.Ticket ticket, TileEntity tile) {
        SubTicket subTicket = new SubTicket(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        subTicket.owner = ticket;
        return subTicket;
    }
}

