/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.block;

import cpw.mods.fml.common.registry.GameRegistry;
import fiskfille.tf.TFLog;
import fiskfille.tf.TransformersMod;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class BlockTF
extends Block {
    protected final Class<? extends TileEntity> tileClass;
    protected final Class<? extends ItemBlock> itemClass;
    protected final String name;

    protected BlockTF(String name, Class<? extends TileEntity> tileClass) {
        this(name, tileClass, ItemBlock.class);
    }

    protected BlockTF(String name, Class<? extends TileEntity> tileClass, Class<? extends ItemBlock> itemClass) {
        this(new Material(MapColor.field_151668_h), name, tileClass, itemClass);
    }

    protected BlockTF(Material material, String name, Class<? extends TileEntity> tileClass) {
        this(material, name, tileClass, ItemBlock.class);
    }

    protected BlockTF(Material material, String name, Class<? extends TileEntity> tileClass, Class<? extends ItemBlock> itemClass) {
        super(material);
        this.name = name;
        this.tileClass = tileClass;
        this.itemClass = itemClass;
        this.init();
    }

    protected void init() {
        String unlocalizedName = this.name.toLowerCase().replaceAll(" ", "_").replaceAll("'", "");
        if (this.tileClass != null) {
            GameRegistry.registerTileEntity(this.tileClass, (String)this.name);
        }
        this.func_149663_c(unlocalizedName);
        this.func_149658_d("transformers:" + unlocalizedName);
        GameRegistry.registerBlock((Block)this, this.itemClass, (String)unlocalizedName);
        this.func_149711_c(0.5f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149647_a(TransformersMod.tabTransformers);
    }

    public BlockTF setHarvestLvl(String tool, int level) {
        this.setHarvestLevel(tool, level);
        return this;
    }

    public boolean hasTileEntity(int metadata) {
        return this.tileClass != null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (this.tileClass != null) {
            try {
                return this.tileClass.newInstance();
            }
            catch (Exception e) {
                TFLog.error("Could not create tile entity for block '%s' from class %s", this.name, this.tileClass);
            }
        }
        return null;
    }
}

