/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fiskfille.tf.TFLog;
import fiskfille.tf.common.fluid.FluidEnergon;
import fiskfille.tf.common.fluid.IFluidHandlerTF;
import fiskfille.tf.common.fluid.TFFluids;
import fiskfille.tf.common.item.ItemFuelCanister;
import fiskfille.tf.helper.TFTileHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockMachineBase
extends Block
implements ITileEntityProvider {
    protected final Random rand = new Random();
    public Class<? extends TileEntity> tileClass;

    protected BlockMachineBase(Material material) {
        super(material);
    }

    public int getBlockHeight() {
        return 1;
    }

    public int getPlacedRotation(EntityLivingBase entity) {
        return MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tile = TFTileHelper.getTileBase(world.func_147438_o(x, y, z));
        ItemStack heldItem = player.func_70694_bm();
        if (tile instanceof IFluidHandlerTF && heldItem != null && heldItem.func_77973_b() instanceof IFluidContainerItem) {
            FluidStack drained;
            int amount;
            FluidStack stack;
            IFluidHandlerTF fluidHandler = (IFluidHandlerTF)tile;
            IFluidContainerItem item = (IFluidContainerItem)heldItem.func_77973_b();
            boolean empty = ItemFuelCanister.isEmpty(heldItem);
            if (!empty && (stack = item.getFluid(heldItem)) != null && fluidHandler.canFill(ForgeDirection.UNKNOWN, stack.getFluid()) && (amount = fluidHandler.fill(ForgeDirection.UNKNOWN, item.drain(heldItem, stack.amount, false), true)) > 0) {
                ItemStack newItem = new ItemStack(heldItem.func_77973_b(), 1, heldItem.func_77960_j());
                item.fill(newItem, stack, true);
                item.drain(newItem, amount, true);
                player.func_70062_b(0, this.addItem(player, heldItem, newItem));
                return true;
            }
            stack = fluidHandler.getTank().getFluid();
            if (stack != null && fluidHandler.canDrain(ForgeDirection.UNKNOWN, item.getFluid(heldItem) == null ? stack.getFluid() : item.getFluid(heldItem).getFluid()) && (drained = fluidHandler.drain(ForgeDirection.UNKNOWN, item.getCapacity(heldItem) - ItemFuelCanister.getFluidAmount(heldItem), false)) != null && drained.amount > 0) {
                ItemStack newItem = new ItemStack(heldItem.func_77973_b(), 1, heldItem.func_77960_j());
                item.fill(newItem, item.getFluid(heldItem), true);
                int amount2 = drained.amount;
                FluidStack stack1 = item.getFluid(newItem);
                if (stack1 == null) {
                    stack1 = new FluidStack(TFFluids.energon, 0);
                }
                FluidStack stack2 = new FluidStack(TFFluids.energon, amount2);
                FluidEnergon.setRatios(stack2, FluidEnergon.getRatios(stack));
                NBTTagCompound prevNBT = stack2.tag;
                stack2.tag = stack1.tag;
                int i = item.fill(newItem, stack2, true);
                fluidHandler.drain(ForgeDirection.UNKNOWN, amount2, true);
                stack1.amount += i;
                stack2.tag = prevNBT;
                FluidEnergon.merge(stack1, stack2, amount2);
                if (!newItem.func_77942_o()) {
                    newItem.func_77982_d(new NBTTagCompound());
                }
                newItem.func_77978_p().func_74782_a("Fluid", (NBTBase)stack1.writeToNBT(new NBTTagCompound()));
                player.func_70062_b(0, this.addItem(player, heldItem, newItem));
                return true;
            }
        }
        return false;
    }

    public ItemStack addItem(EntityPlayer player, ItemStack itemstack, ItemStack newItem) {
        if (player.field_71075_bZ.field_75098_d) {
            return itemstack;
        }
        if (itemstack.field_77994_a - 1 <= 0) {
            return newItem;
        }
        --itemstack.field_77994_a;
        if (!player.field_71071_by.func_70441_a(newItem)) {
            player.func_71019_a(newItem, false);
        }
        return itemstack;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        boolean flag = super.func_149742_c(world, x, y, z);
        int height = this.getBlockHeight();
        for (int i = 1; i < height; ++i) {
            flag &= super.func_149742_c(world, x, y + i, z);
        }
        return y + height - 1 < world.func_72800_K() && flag;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149633_g(world, x, y, z);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public void addBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, int x, int y, int z, AxisAlignedBB aabb, List list) {
        AxisAlignedBB aabb1 = AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).func_72317_d((double)x, (double)y, (double)z);
        if (aabb1.func_72326_a(aabb)) {
            list.add(aabb1);
        }
    }

    public boolean func_149740_M() {
        return this.tileClass != null && (IFluidHandler.class.isAssignableFrom(this.tileClass) || IInventory.class.isAssignableFrom(this.tileClass));
    }

    public int func_149736_g(World world, int x, int y, int z, int metadata) {
        TileEntity tile = TFTileHelper.getTileBase(world.func_147438_o(x, y, z));
        if (tile instanceof IFluidHandler) {
            IFluidHandler fluidHandler = (IFluidHandler)tile;
            float amount = 0.0f;
            float capacity = 0.0f;
            for (ForgeDirection dir : ForgeDirection.values()) {
                FluidTankInfo[] info = fluidHandler.getTankInfo(dir);
                for (int i = 0; i < info.length; ++i) {
                    capacity += (float)info[i].capacity;
                    if (info[i].fluid == null) continue;
                    amount += (float)info[i].fluid.amount;
                }
            }
            return Math.round(amount / capacity * 15.0f);
        }
        if (tile instanceof IInventory) {
            return Container.func_94526_b((IInventory)((IInventory)tile));
        }
        return 0;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        TileEntity tileBase;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IInventory) {
            IInventory inventory = (IInventory)tile;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemstack = inventory.func_70301_a(i);
                if (itemstack == null) continue;
                float f = this.rand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
                float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j = this.rand.nextInt(21) + 10;
                    if (j > itemstack.field_77994_a) {
                        j = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j;
                    EntityItem entity = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entity.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    entity.field_70159_w = (float)this.rand.nextGaussian() * f3;
                    entity.field_70181_x = (float)this.rand.nextGaussian() * f3 + 0.2f;
                    entity.field_70179_y = (float)this.rand.nextGaussian() * f3;
                    world.func_72838_d((Entity)entity);
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        if ((tileBase = TFTileHelper.getTileBase(tile)) != null && tile != tileBase && this.getBlockHeight() > 0) {
            world.func_147468_f(tileBase.field_145851_c, tileBase.field_145848_d, tileBase.field_145849_e);
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (!(world.field_72995_K || player != null && player.field_71075_bZ.field_75098_d)) {
            ItemStack itemstack = new ItemStack((Block)this, 1, this.func_149692_a(world.func_72805_g(x, y, z)));
            TileEntity tile = TFTileHelper.getTileBase(world.func_147438_o(x, y, z));
            if (tile != null) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                tile.func_145841_b(nbttagcompound);
                if (nbttagcompound.func_150297_b("ConfigDataTF", 10)) {
                    NBTTagCompound config = nbttagcompound.func_74775_l("ConfigDataTF");
                    if (!itemstack.func_77942_o()) {
                        itemstack.func_77982_d(new NBTTagCompound());
                    }
                    itemstack.func_77978_p().func_74782_a("ConfigDataTF", (NBTBase)config);
                }
            }
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, itemstack);
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemstack) {
        super.func_149689_a(world, x, y, z, entity, itemstack);
        TileEntity tile = TFTileHelper.getTileBase(world.func_147438_o(x, y, z));
        if (tile != null) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            tile.func_145841_b(nbttagcompound);
            if (itemstack != null && itemstack.func_77942_o() && itemstack.func_77978_p().func_150297_b("ConfigDataTF", 10)) {
                NBTTagCompound config = itemstack.func_77978_p().func_74775_l("ConfigDataTF");
                nbttagcompound.func_74782_a("ConfigDataTF", (NBTBase)config);
                tile.func_145839_a(nbttagcompound);
            }
        }
        for (int i = 0; i < this.getBlockHeight(); ++i) {
            int metadata = this.getPlacedRotation(entity) + i * 4;
            if (metadata <= 0) continue;
            if (i == 0) {
                world.func_72921_c(x, y, z, metadata, 2);
                continue;
            }
            world.func_147465_d(x, y + i, z, (Block)this, metadata, 2);
        }
        if (!world.field_72995_K) {
            world.func_147471_g(x, y, z);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        world.func_147471_g(x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int[] offsets;
        TileEntity tile = world.func_147438_o(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (tile != null && this.getBlockHeight() > 0 && world.func_147439_a(x + (offsets = TFTileHelper.getTileBaseOffsets(tile, metadata))[0], y + offsets[1], z + offsets[2]) != this) {
            world.func_147468_f(x, y, z);
        }
    }

    public boolean hasTileEntity(int metadata) {
        return this.tileClass != null;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        if (this.tileClass != null) {
            try {
                return this.tileClass.newInstance();
            }
            catch (Exception e) {
                TFLog.error("Could not create tile entity for block '%s' from class %s", this.delegate.name(), this.tileClass);
            }
        }
        return null;
    }
}

