/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fiskfille.tf.common.block.TFBlocks;
import fiskfille.tf.common.data.TFEntityData;
import fiskfille.tf.common.data.tile.TileDataControlPanel;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.common.tileentity.TileEntityControlPanel;
import fiskfille.tf.common.tileentity.TileEntityGroundBridgeTeleporter;
import fiskfille.tf.common.world.TeleporterGroundBridge;
import fiskfille.tf.helper.TFTileHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockGroundBridgeTeleporter
extends BlockBreakable
implements ITileEntityProvider {
    public BlockGroundBridgeTeleporter() {
        super("transformers:ground_bridge_teleporter", Material.field_151567_E, false);
        this.func_149675_a(true);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean canPaneConnectTo(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return world.func_147439_a(x, y, z) == TFBlocks.groundBridgeTeleporter;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        boolean flag1;
        float thickness = 0.125f;
        float f = 0.5f - thickness;
        float f1 = 0.5f + thickness;
        float f2 = 0.5f - thickness;
        float f3 = 0.5f + thickness;
        boolean flag = this.canPaneConnectTo(world, x, y, z - 1, ForgeDirection.NORTH) || this.canPaneConnectTo(world, x, y, z + 1, ForgeDirection.SOUTH);
        boolean bl = flag1 = this.canPaneConnectTo(world, x - 1, y, z, ForgeDirection.WEST) || this.canPaneConnectTo(world, x + 1, y, z, ForgeDirection.EAST);
        if (!flag && flag1) {
            f = 0.0f;
            f1 = 1.0f;
        }
        if (flag && !flag1) {
            f2 = 0.0f;
            f3 = 1.0f;
        }
        this.func_149676_a(f, 0.0f, f2, f1, 1.0f, f3);
    }

    public boolean func_149686_d() {
        return false;
    }

    public static boolean spawnTeleporter(World world, int x, int y, int z, TileEntityControlPanel tile) {
        if (!tile.data.errors.isEmpty()) {
            return false;
        }
        if (BlockGroundBridgeTeleporter.isNorthSouthFacingFramePresent((IBlockAccess)world, x, y, z)) {
            BlockGroundBridgeTeleporter.fillNorthFacingFrame(world, x, y, z, TFBlocks.groundBridgeTeleporter, tile, false);
            return true;
        }
        if (BlockGroundBridgeTeleporter.isEastWestFacingFramePresent((IBlockAccess)world, x, y, z)) {
            BlockGroundBridgeTeleporter.fillEastFacingFrame(world, x, y, z, TFBlocks.groundBridgeTeleporter, tile, false);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        int i1 = 0;
        if (world.func_147439_a(x, y, z) == this) {
            i1 = BlockGroundBridgeTeleporter.func_149999_b(world.func_72805_g(x, y, z));
            if (i1 == 0) {
                return false;
            }
            if (i1 == 2 && side != 5 && side != 4) {
                return false;
            }
            if (i1 == 1 && side != 3 && side != 2) {
                return false;
            }
        }
        boolean flag = world.func_147439_a(x - 1, y, z) == this && world.func_147439_a(x - 2, y, z) != this;
        boolean flag1 = world.func_147439_a(x + 1, y, z) == this && world.func_147439_a(x + 2, y, z) != this;
        boolean flag2 = world.func_147439_a(x, y, z - 1) == this && world.func_147439_a(x, y, z - 2) != this;
        boolean flag3 = world.func_147439_a(x, y, z + 1) == this && world.func_147439_a(x, y, z + 2) != this;
        boolean flag4 = flag || flag1 || i1 == 1;
        boolean flag5 = flag2 || flag3 || i1 == 2;
        return flag4 && side == 4 || flag4 && side == 5 || flag5 && side == 2 || flag5 && side == 3;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public int func_149645_b() {
        return -1;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (!world.field_72995_K && entity.field_70154_o == null && entity.field_70153_n == null) {
            TileEntityGroundBridgeTeleporter teleporter;
            if (TFEntityData.getData((Entity)entity).groundBridgeCooldown == 0 && (teleporter = (TileEntityGroundBridgeTeleporter)world.func_147438_o(x, y, z)) != null && teleporter.controlPanel != null) {
                BlockGroundBridgeTeleporter.doTeleport(entity, teleporter);
            }
            TFEntityData.getData((Entity)entity).groundBridgeCooldown = 10;
        }
    }

    public static void doTeleport(Entity entity, TileEntityGroundBridgeTeleporter teleporter) {
        if (!entity.field_70170_p.field_72995_K) {
            BlockGroundBridgeTeleporter.doTeleportClient(entity, teleporter);
        }
    }

    public static void doTeleportClient(Entity entity, TileEntityGroundBridgeTeleporter teleporter) {
        TileDataControlPanel data;
        if (teleporter.controlPanel != null && (data = (TileDataControlPanel)TFTileHelper.getTileData(teleporter.controlPanel)) != null && data.framePos != null) {
            double posX = (double)data.destination.field_71574_a + 0.5;
            double posY = data.modifiedDestY;
            double posZ = (double)data.destination.field_71573_c + 0.5;
            int dimension = data.destination.dimension;
            int srcYaw = data.frameDirection;
            int dstYaw = data.direction;
            if (teleporter.returnPortal()) {
                posX = (double)data.framePos.field_71574_a + 0.5;
                posY = (double)data.framePos.field_71572_b + 1.0;
                posZ = (double)data.framePos.field_71573_c + 0.5;
                dimension = data.framePos.dimension;
                srcYaw = data.direction;
                dstYaw = data.frameDirection;
            }
            float yawDiff = entity.field_70177_z - (float)(srcYaw * 90 + 180);
            float yaw = (float)(dstYaw * 90 + 16200) + yawDiff;
            if (entity instanceof EntityPlayerMP) {
                EntityPlayerMP playerMP = (EntityPlayerMP)entity;
                double motionX = entity.field_70159_w;
                double motionZ = entity.field_70179_y;
                if (dimension != entity.field_71093_bK) {
                    playerMP.field_71133_b.func_71203_ab().transferPlayerToDimension(playerMP, dimension, (Teleporter)new TeleporterGroundBridge(playerMP.field_71133_b.func_71218_a(dimension)));
                }
                playerMP.field_71135_a.func_147364_a(posX, posY, posZ, yaw, entity.field_70125_A);
                entity.field_70159_w = motionX;
                entity.field_70179_y = motionZ;
            } else if (!(entity instanceof EntityPlayer) && dimension == entity.field_71093_bK) {
                double motionX = entity.field_70159_w;
                double motionZ = entity.field_70179_y;
                entity.func_70012_b(posX, posY, posZ, yaw, entity.field_70125_A);
                entity.field_70159_w = motionX;
                entity.field_70179_y = motionZ;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150899_d((int)0);
    }

    public static int func_149999_b(int meta) {
        return meta & 3;
    }

    public static boolean isReturnPortal(int metadata) {
        return metadata > 1;
    }

    public static boolean isNorthSouthFacingFramePresent(IBlockAccess world, int x, int y, int z) {
        Block b = TFBlocks.groundBridgeFrame;
        if (world.func_147439_a(x, y, z) == b && world.func_147439_a(x - 1, y, z) == b && world.func_147439_a(x + 1, y, z) == b && world.func_147439_a(x - 2, y + 1, z) == b && world.func_147439_a(x + 2, y + 1, z) == b) {
            int j = 0;
            for (int i = 0; i < 3; ++i) {
                if (world.func_147439_a(x - 3, y + 2 + i, z) != b || world.func_147439_a(x + 3, y + 2 + i, z) != b) continue;
                ++j;
            }
            if (j == 3 && world.func_147439_a(x - 2, y + 5, z) == b && world.func_147439_a(x + 2, y + 5, z) == b && world.func_147439_a(x, y + 6, z) == b && world.func_147439_a(x - 1, y + 6, z) == b && world.func_147439_a(x + 1, y + 6, z) == b) {
                return true;
            }
        }
        return false;
    }

    public static boolean isEastWestFacingFramePresent(IBlockAccess world, int x, int y, int z) {
        Block b = TFBlocks.groundBridgeFrame;
        if (world.func_147439_a(x, y, z) == b && world.func_147439_a(x, y, z - 1) == b && world.func_147439_a(x, y, z + 1) == b && world.func_147439_a(x, y + 1, z - 2) == b && world.func_147439_a(x, y + 1, z + 2) == b) {
            int j = 0;
            for (int i = 0; i < 3; ++i) {
                if (world.func_147439_a(x, y + 2 + i, z - 3) != b || world.func_147439_a(x, y + 2 + i, z + 3) != b) continue;
                ++j;
            }
            if (j == 3 && world.func_147439_a(x, y + 5, z - 2) == b && world.func_147439_a(x, y + 5, z + 2) == b && world.func_147439_a(x, y + 6, z) == b && world.func_147439_a(x, y + 6, z - 1) == b && world.func_147439_a(x, y + 6, z + 1) == b) {
                return true;
            }
        }
        return false;
    }

    public static void fillNorthFacingFrame(World world, int x, int y, int z, Block block, TileEntityControlPanel tile, boolean returnPortal) {
        ItemCSD.DimensionalCoords coords = new ItemCSD.DimensionalCoords(tile);
        int metadata = returnPortal ? 2 : 0;
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 3; ++j) {
                TileEntityGroundBridgeTeleporter tileentity;
                int k = 0;
                int l = 0;
                if (world.func_147438_o(x - 1 + j, y + 1 + i, z) instanceof TileEntityGroundBridgeTeleporter) {
                    tileentity = (TileEntityGroundBridgeTeleporter)world.func_147438_o(x - 1 + j, y + 1 + i, z);
                    k = tileentity.ticks;
                }
                if (world.func_147438_o(x - 2 + i, y + 2 + j, z) instanceof TileEntityGroundBridgeTeleporter) {
                    tileentity = (TileEntityGroundBridgeTeleporter)world.func_147438_o(x - 2 + i, y + 2 + j, z);
                    l = tileentity.ticks;
                }
                world.func_147465_d(x - 1 + j, y + 1 + i, z, block, metadata, 2);
                world.func_147465_d(x - 2 + i, y + 2 + j, z, block, metadata, 2);
                if (world.func_147438_o(x - 1 + j, y + 1 + i, z) instanceof TileEntityGroundBridgeTeleporter) {
                    tileentity = (TileEntityGroundBridgeTeleporter)world.func_147438_o(x - 1 + j, y + 1 + i, z);
                    tileentity.controlPanel = coords;
                    tileentity.lastUpdate = 0;
                    tileentity.ticks = ++k;
                }
                if (!(world.func_147438_o(x - 2 + i, y + 2 + j, z) instanceof TileEntityGroundBridgeTeleporter)) continue;
                tileentity = (TileEntityGroundBridgeTeleporter)world.func_147438_o(x - 2 + i, y + 2 + j, z);
                tileentity.controlPanel = coords;
                tileentity.lastUpdate = 0;
                tileentity.ticks = l;
            }
        }
        world.func_72921_c(x, y + 3, z, metadata + 1, 2);
    }

    public static void fillEastFacingFrame(World world, int x, int y, int z, Block block, TileEntityControlPanel tile, boolean returnPortal) {
        ItemCSD.DimensionalCoords coords = new ItemCSD.DimensionalCoords(tile);
        int metadata = returnPortal ? 2 : 0;
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 3; ++j) {
                TileEntityGroundBridgeTeleporter tileentity;
                int k = 0;
                int l = 0;
                if (world.func_147438_o(x, y + 1 + i, z - 1 + j) instanceof TileEntityGroundBridgeTeleporter) {
                    tileentity = (TileEntityGroundBridgeTeleporter)world.func_147438_o(x, y + 1 + i, z - 1 + j);
                    k = tileentity.ticks;
                }
                if (world.func_147438_o(x, y + 2 + j, z - 2 + i) instanceof TileEntityGroundBridgeTeleporter) {
                    tileentity = (TileEntityGroundBridgeTeleporter)world.func_147438_o(x, y + 2 + j, z - 2 + i);
                    l = tileentity.ticks;
                }
                world.func_147465_d(x, y + 1 + i, z - 1 + j, block, metadata, 2);
                world.func_147465_d(x, y + 2 + j, z - 2 + i, block, metadata, 2);
                if (world.func_147438_o(x, y + 1 + i, z - 1 + j) instanceof TileEntityGroundBridgeTeleporter) {
                    tileentity = (TileEntityGroundBridgeTeleporter)world.func_147438_o(x, y + 1 + i, z - 1 + j);
                    tileentity.controlPanel = coords;
                    tileentity.lastUpdate = 0;
                    tileentity.ticks = ++k;
                }
                if (!(world.func_147438_o(x, y + 2 + j, z - 2 + i) instanceof TileEntityGroundBridgeTeleporter)) continue;
                tileentity = (TileEntityGroundBridgeTeleporter)world.func_147438_o(x, y + 2 + j, z - 2 + i);
                tileentity.controlPanel = coords;
                tileentity.lastUpdate = 0;
                tileentity.ticks = l;
            }
        }
        world.func_72921_c(x, y + 3, z, metadata + 1, 2);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityGroundBridgeTeleporter();
    }
}

