/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.block;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import fiskfille.tf.client.gui.GuiHandlerTF;
import fiskfille.tf.common.block.BlockMachineBase;
import fiskfille.tf.common.block.TFMaterial;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.common.item.ItemDisplayVehicle;
import fiskfille.tf.common.item.TFItems;
import fiskfille.tf.common.network.MessageTileTrigger;
import fiskfille.tf.common.network.MessageUpdateArmor;
import fiskfille.tf.common.network.base.TFNetworkManager;
import fiskfille.tf.common.tileentity.TileEntityDisplayStation;
import fiskfille.tf.helper.TFTileHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDisplayStation
extends BlockMachineBase {
    public BlockDisplayStation() {
        super(TFMaterial.display);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    @Override
    public int getBlockHeight() {
        return 2;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata >= 4) {
            this.func_149676_a(0.0f, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f);
        }
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (super.func_149727_a(world, x, y, z, player, side, hitX, hitY, hitZ)) {
            return true;
        }
        TileEntity tileentity = TFTileHelper.getTileBase(world.func_147438_o(x, y, z));
        if (tileentity instanceof TileEntityDisplayStation) {
            TileEntityDisplayStation tile = (TileEntityDisplayStation)tileentity;
            if (!player.func_70093_af()) {
                ItemStack heldItem = player.func_70694_bm();
                if (heldItem != null && heldItem.func_77973_b() == TFItems.displayVehicle) {
                    boolean flag = true;
                    for (int i = 0; i < 4; ++i) {
                        if (tile.func_70301_a(i) == null) continue;
                        flag = false;
                        break;
                    }
                    if (flag) {
                        ItemStack[] armor = ItemDisplayVehicle.getArmorFromNBT(heldItem);
                        for (int i = 0; i < armor.length; ++i) {
                            tile.func_70299_a(i, armor[i]);
                        }
                        tile.func_70296_d();
                        player.func_70062_b(0, null);
                        return true;
                    }
                }
                GuiHandlerTF.TFGui.DISPLAY_STATION.open(player, tile);
            } else if (!world.field_72995_K) {
                for (int armorType = 0; armorType < 4; ++armorType) {
                    this.handleArmorTransition(player, tile, armorType);
                }
            }
        }
        return true;
    }

    private void handleArmorTransition(EntityPlayer player, TileEntityDisplayStation tile, int armorType) {
        ItemStack playerArmor = player.field_71071_by.field_70460_b[armorType];
        int tileArmorSlot = 3 - armorType;
        if (tileArmorSlot != -1 && armorType >= 0 && armorType < 4) {
            ItemStack tileArmor = tile.func_70301_a(tileArmorSlot);
            ItemStack itemstack1 = null;
            ItemStack itemstack2 = null;
            if (playerArmor != null) {
                itemstack1 = playerArmor.func_77946_l();
            }
            if (tileArmor != null) {
                itemstack2 = tileArmor.func_77946_l();
            }
            if (itemstack2 != null) {
                player.field_71071_by.field_70460_b[armorType] = itemstack2;
                this.sendPlayerArmorPacket(player, itemstack2, armorType);
            }
            if (itemstack1 != null) {
                tile.func_70299_a(tileArmorSlot, itemstack1);
            }
            if (itemstack2 == null) {
                player.field_71071_by.field_70460_b[armorType] = null;
                this.sendPlayerArmorPacket(player, itemstack2, armorType);
            }
            if (itemstack1 == null) {
                tile.func_70299_a(tileArmorSlot, null);
            }
            tile.func_70296_d();
        }
    }

    private void sendPlayerArmorPacket(EntityPlayer player, ItemStack armor, int armorSlot) {
        try {
            TFNetworkManager.networkWrapper.sendTo((IMessage)new MessageUpdateArmor(player, armor, armorSlot), (EntityPlayerMP)player);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        if (world.func_147438_o(x, y, z) instanceof TileEntityDisplayStation) {
            TileEntityDisplayStation tile = TFTileHelper.getTileBase((TileEntityDisplayStation)world.func_147438_o(x, y, z));
            if (!world.field_72995_K) {
                boolean flag = world.func_72864_z(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
                if (flag && !tile.isRedstonePowered && tile.canTransform()) {
                    TFNetworkManager.networkWrapper.sendToAll((IMessage)new MessageTileTrigger(new ItemCSD.DimensionalCoords(tile), null, 0));
                    tile.receive(null, 0);
                }
                tile.isRedstonePowered = flag;
            }
        }
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("stone");
    }
}

