/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.block;

import com.google.common.collect.Lists;
import fiskfille.tf.client.render.block.RenderBlockDisplayPedestal;
import fiskfille.tf.common.block.BlockMachineBase;
import fiskfille.tf.common.block.TFMaterial;
import fiskfille.tf.common.tileentity.TileEntityDisplayPedestal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockDisplayPedestal
extends BlockMachineBase {
    public BlockDisplayPedestal() {
        super(TFMaterial.display);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < BlockDisplayPedestal.getTextures().size(); ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public String getHarvestTool(int metadata) {
        BlockIcon icon = BlockDisplayPedestal.getTexture(metadata)[0];
        return icon.block.getHarvestTool(icon.metadata);
    }

    public boolean isToolEffective(String type, int metadata) {
        BlockIcon icon = BlockDisplayPedestal.getTexture(metadata)[0];
        return icon.block.isToolEffective(type, icon.metadata);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        BlockIcon[] icons = BlockDisplayPedestal.getTexture(world.func_72805_g(x, y, z));
        int fire = 0;
        for (int i = 0; i < icons.length; ++i) {
            fire += Blocks.field_150480_ab.getFlammability(icons[i].block);
        }
        return fire / icons.length;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        BlockIcon[] icons = BlockDisplayPedestal.getTexture(world.func_72805_g(x, y, z));
        int fire = 0;
        for (int i = 0; i < icons.length; ++i) {
            fire += Blocks.field_150480_ab.getEncouragement(icons[i].block);
        }
        return fire / icons.length;
    }

    @Override
    public int getPlacedRotation(EntityLivingBase entity) {
        return 0;
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        for (AxisAlignedBB aabb1 : BlockDisplayPedestal.getBounds()) {
            this.addBox(aabb1.field_72340_a, aabb1.field_72338_b, aabb1.field_72339_c, aabb1.field_72336_d, aabb1.field_72337_e, aabb1.field_72334_f, x, y, z, aabb, list);
        }
    }

    public static List<BlockIcon[]> getTextures() {
        ArrayList list = Lists.newArrayList();
        list.add(new BlockIcon[]{new BlockIcon(Blocks.field_150347_e, 0, 0), new BlockIcon(Blocks.field_150417_aV, 0, 0), new BlockIcon(Blocks.field_150348_b, 0, 0)});
        list.add(new BlockIcon[]{new BlockIcon(Blocks.field_150417_aV, 0, 3), new BlockIcon(Blocks.field_150417_aV, 0, 1), new BlockIcon(Blocks.field_150417_aV, 0, 2)});
        list.add(new BlockIcon[]{new BlockIcon(Blocks.field_150322_A, 2, 0), new BlockIcon(Blocks.field_150322_A, 2, 1), new BlockIcon(Blocks.field_150322_A, 1, 0)});
        list.add(new BlockIcon[]{new BlockIcon(Blocks.field_150371_ca, 1, 1), new BlockIcon(Blocks.field_150371_ca, 2, 2), new BlockIcon(Blocks.field_150371_ca, 1, 2)});
        list.add(new BlockIcon[]{new BlockIcon(Blocks.field_150385_bj, 0, 0), new BlockIcon(Blocks.field_150424_aL, 0, 0), new BlockIcon(Blocks.field_150385_bj, 0, 0)});
        for (int i = 0; i < 6; ++i) {
            Block log = i < 4 ? Blocks.field_150364_r : Blocks.field_150363_s;
            list.add(new BlockIcon[]{new BlockIcon(Blocks.field_150344_f, 0, i), new BlockIcon(log, 2, i % 4), new BlockIcon(Blocks.field_150344_f, 0, i)});
        }
        return list;
    }

    public static BlockIcon[] getTexture(int metadata) {
        return BlockDisplayPedestal.getTextures().get(MathHelper.func_76125_a((int)metadata, (int)0, (int)(BlockDisplayPedestal.getTextures().size() - 1)));
    }

    public static AxisAlignedBB[] getBounds() {
        float f = 0.0625f;
        return new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)(f * 2.0f), (double)0.0, (double)(f * 2.0f), (double)(f * 14.0f), (double)(f * 2.0f), (double)(f * 14.0f)), AxisAlignedBB.func_72330_a((double)(f * 5.0f), (double)(f * 2.0f), (double)(f * 5.0f), (double)(1.0f - f * 5.0f), (double)(f * 7.0f), (double)(1.0f - f * 5.0f)), AxisAlignedBB.func_72330_a((double)(f * 4.0f), (double)(f * 7.0f), (double)(f * 4.0f), (double)(1.0f - f * 4.0f), (double)(f * 9.0f), (double)(1.0f - f * 4.0f))};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (super.func_149727_a(world, x, y, z, player, side, hitX, hitY, hitZ)) {
            return true;
        }
        TileEntityDisplayPedestal tile = (TileEntityDisplayPedestal)world.func_147438_o(x, y, z);
        if (tile == null) return false;
        ItemStack heldItem = player.func_70694_bm();
        ItemStack displayItem = tile.getDisplayItem();
        if (heldItem != null) {
            if (!tile.func_94041_b(0, heldItem)) return false;
            if (displayItem != null) {
                if (displayItem.func_77985_e() && heldItem.func_77973_b() == displayItem.func_77973_b() && heldItem.func_77960_j() == displayItem.func_77960_j() && ItemStack.func_77970_a((ItemStack)heldItem, (ItemStack)displayItem)) {
                    if (displayItem.field_77994_a >= displayItem.func_77976_d()) return false;
                    int amount = Math.min(heldItem.field_77994_a, displayItem.func_77976_d() - displayItem.field_77994_a);
                    displayItem.field_77994_a += amount;
                    if ((heldItem.field_77994_a -= amount) > 0) return true;
                    player.func_70062_b(0, null);
                    return true;
                }
                tile.setDisplayItem(heldItem, true);
                player.func_70062_b(0, displayItem);
                return true;
            }
            tile.setDisplayItem(heldItem, true);
            player.func_70062_b(0, null);
            return true;
        }
        if (displayItem == null) return false;
        player.func_70062_b(0, displayItem);
        tile.setDisplayItem(null, true);
        return true;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        AxisAlignedBB aabb = null;
        for (AxisAlignedBB aabb1 : BlockDisplayPedestal.getBounds()) {
            aabb = aabb == null ? aabb1 : aabb.func_111270_a(aabb1);
        }
        this.func_149676_a((float)aabb.field_72340_a, (float)aabb.field_72338_b, (float)aabb.field_72339_c, (float)aabb.field_72336_d, (float)aabb.field_72337_e, (float)aabb.field_72334_f);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return RenderBlockDisplayPedestal.renderId;
    }

    public IIcon func_149691_a(int side, int metadata) {
        BlockIcon icon = BlockDisplayPedestal.getTexture(metadata)[side % BlockDisplayPedestal.getTexture(metadata).length];
        return icon.block.func_149691_a(icon.side, icon.metadata);
    }

    public void func_149651_a(IIconRegister iconRegister) {
    }

    public static class BlockIcon {
        public final Block block;
        public final int side;
        public final int metadata;

        public BlockIcon(Block block, int side, int metadata) {
            this.block = block;
            this.side = side;
            this.metadata = metadata;
        }
    }
}

