/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.block;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import fiskfille.tf.common.block.BlockMachineBase;
import fiskfille.tf.common.groundbridge.DataCore;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.common.network.MessageTileTrigger;
import fiskfille.tf.common.network.base.TFNetworkManager;
import fiskfille.tf.common.tileentity.TileEntityControlPanel;
import fiskfille.tf.helper.TFTileHelper;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockControlPanel
extends BlockMachineBase {
    public BlockControlPanel() {
        super(Material.field_151573_f);
        this.func_149711_c(4.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(field_149777_j);
    }

    @Override
    public int getPlacedRotation(EntityLivingBase entity) {
        return 0;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = TFTileHelper.getTileBase(world.func_147438_o(x, y, z));
        int metadata = world.func_72805_g(x, y, z);
        int direction = BlockControlPanel.getDirection(metadata);
        float f = 0.0625f;
        float f1 = 0.9575f;
        if (BlockControlPanel.isBlockTopOfPanel(metadata)) {
            if (tile instanceof TileEntityControlPanel && ((TileEntityControlPanel)tile).hasUpgrade(DataCore.spaceBridge)) {
                float width = f * 6.0f;
                float depth = f * 4.0f;
                float height = f * 8.0f;
                if (direction == 0) {
                    this.func_149676_a(0.0f, f1 - 1.0f, 1.0f - depth, width, f1 - 1.0f + height, 1.0f);
                } else if (direction == 1) {
                    this.func_149676_a(0.0f, f1 - 1.0f, 0.0f, depth, f1 - 1.0f + height, width);
                } else if (direction == 2) {
                    this.func_149676_a(1.0f - width, f1 - 1.0f, 0.0f, 1.0f, f1 - 1.0f + height, depth);
                } else if (direction == 3) {
                    this.func_149676_a(1.0f - depth, f1 - 1.0f, 1.0f - width, 1.0f, f1 - 1.0f + height, 1.0f);
                }
            } else {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            }
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, f1, 1.0f);
        }
    }

    public static boolean isBlockLeftSideOfPanel(int metadata) {
        return metadata < 4;
    }

    public static boolean isBlockTopOfPanel(int metadata) {
        return metadata >= 8;
    }

    public static int getDirection(int metadata) {
        return metadata % 4;
    }

    public int func_149656_h() {
        return 1;
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (super.func_149727_a(world, x, y, z, player, side, hitX, hitY, hitZ)) {
            return true;
        }
        int metadata = world.func_72805_g(x, y, z);
        int direction = BlockControlPanel.getDirection(metadata);
        int face = -1;
        if (side == 0) {
            face = 5;
        } else if (side == 1) {
            face = 4;
        }
        if (direction == 0) {
            if (side == 2) {
                face = 0;
            } else if (side == 3) {
                face = 1;
            } else if (side == 4) {
                face = 2;
            } else if (side == 5) {
                face = 3;
            }
        } else if (direction == 1) {
            if (side == 5) {
                face = 0;
            } else if (side == 4) {
                face = 1;
            } else if (side == 2) {
                face = 2;
            } else if (side == 3) {
                face = 3;
            }
        } else if (direction == 2) {
            if (side == 3) {
                face = 0;
            } else if (side == 2) {
                face = 1;
            } else if (side == 5) {
                face = 2;
            } else if (side == 4) {
                face = 3;
            }
        } else if (direction == 3) {
            if (side == 4) {
                face = 0;
            } else if (side == 5) {
                face = 1;
            } else if (side == 3) {
                face = 2;
            } else if (side == 2) {
                face = 3;
            }
        }
        if (face != -1) {
            TileEntity tile;
            if (side == 1 || side == 0) {
                if (direction == 0) {
                    hitX = 1.0f - hitX;
                    hitY = (side == 1 ? 1.0f : hitZ * 2.0f) - hitZ;
                } else if (direction == 1) {
                    hitY = (side == 0 ? 1.0f : hitX * 2.0f) - hitX;
                    hitX = 1.0f - hitZ;
                } else if (direction == 2) {
                    hitY = (side == 0 ? 1.0f : hitZ * 2.0f) - hitZ;
                } else if (direction == 3) {
                    hitY = (side == 1 ? 1.0f : hitX * 2.0f) - hitX;
                    hitX = hitZ;
                }
            } else if (side == 3) {
                hitY = 1.0f - hitY;
            } else if (side == 2) {
                hitX = 1.0f - hitX;
                hitY = 1.0f - hitY;
            } else if (side == 5) {
                hitX = 1.0f - hitZ;
                hitY = 1.0f - hitY;
            } else if (side == 4) {
                hitX = hitZ;
                hitY = 1.0f - hitY;
            }
            if (face == 1) {
                hitX = 1.0f - hitX;
            }
            boolean isSide = !BlockControlPanel.isBlockLeftSideOfPanel(metadata);
            boolean isTop = BlockControlPanel.isBlockTopOfPanel(metadata);
            if (isSide && face != 2 && face != 3) {
                hitX += 1.0f;
            }
            if (isTop && face != 4 && face != 5) {
                hitY -= 1.0f;
            }
            if ((tile = TFTileHelper.getTileBase(world.func_147438_o(x, y, z))) instanceof TileEntityControlPanel) {
                return this.onRightClick(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, (TileEntityControlPanel)tile, player, face, hitX, hitY);
            }
        }
        return false;
    }

    public boolean onRightClick(World world, int x, int y, int z, TileEntityControlPanel tile, EntityPlayer player, int face, float hitX, float hitY) {
        float f = 0.0625f;
        if (world.field_72995_K) {
            if (face == 0) {
                if (hitY > f * 4.0f && hitY <= f * 7.5f) {
                    for (int i = 0; i < 3; ++i) {
                        if ((player.func_70694_bm() == null || !tile.func_94041_b(i, player.func_70694_bm())) && (tile.func_70301_a(i) == null || player.func_70694_bm() != null) || !(hitX > f * (19.0f + (float)i * 3.5f)) || !(hitX <= f * (22.0f + (float)i * 3.5f))) continue;
                        this.sendActionPacket(tile, player, 15 + i);
                        return true;
                    }
                }
                if (hitY >= f * -3.7f && hitY < f * -1.7f) {
                    if (hitX >= f * 26.5f && hitX < f * 28.5f) {
                        this.sendActionPacket(tile, player, 18);
                        return true;
                    }
                    if (hitX >= f * 28.7f && hitX < f * 30.7f) {
                        this.sendActionPacket(tile, player, 19);
                        return true;
                    }
                }
            } else if (face == 4) {
                if (hitY > f * 2.0f && hitY <= f * 4.5f) {
                    if (hitX > f * 1.15f && hitX <= f * 3.21f) {
                        this.sendActionPacket(tile, player, 1);
                        return true;
                    }
                    if (hitX > f * 3.25f && hitX <= f * 5.39f) {
                        this.sendActionPacket(tile, player, 2);
                        return true;
                    }
                    if (hitX > f * 5.55f && hitX <= f * 7.6f) {
                        this.sendActionPacket(tile, player, 3);
                        return true;
                    }
                    if (hitX > f * 7.6f && hitX <= f * 10.0f) {
                        this.sendActionPacket(tile, player, 4);
                        return true;
                    }
                }
                if (hitY > f * 6.2f && hitY <= f * 8.8f) {
                    if (hitX > f * 1.15f && hitX <= f * 3.21f) {
                        this.sendActionPacket(tile, player, 5);
                        return true;
                    }
                    if (hitX > f * 3.25f && hitX <= f * 5.39f) {
                        this.sendActionPacket(tile, player, 6);
                        return true;
                    }
                    if (hitX > f * 5.55f && hitX <= f * 7.6f) {
                        this.sendActionPacket(tile, player, 7);
                        return true;
                    }
                    if (hitX > f * 7.6f && hitX <= f * 10.0f) {
                        this.sendActionPacket(tile, player, 8);
                        return true;
                    }
                }
                if (hitY > f * 10.0f && hitY <= f * 13.0f) {
                    if (hitX > f * 1.15f && hitX <= f * 3.21f) {
                        this.sendActionPacket(tile, player, 9);
                        return true;
                    }
                    if (hitX > f * 3.25f && hitX <= f * 5.39f) {
                        this.sendActionPacket(tile, player, 10);
                        return true;
                    }
                    if (hitX > f * 5.55f && hitX <= f * 7.6f) {
                        this.sendActionPacket(tile, player, 11);
                        return true;
                    }
                    if (hitX > f * 7.6f && hitX <= f * 10.0f) {
                        this.sendActionPacket(tile, player, 12);
                        return true;
                    }
                }
                if (hitX > f * 13.5f && hitX <= f * 18.5f && hitY > f * 5.65f && hitY <= f * 10.85f) {
                    if (!tile.data.activationLeverState) {
                        this.sendActionPacket(tile, player, 13);
                    }
                    return true;
                }
                if (hitX > f * 23.0f && hitX <= f * 31.0f && hitY > f * 4.0f && hitY <= f * 12.75f) {
                    if (tile.activationLeverCoverState && (tile.activationLeverTimer == 0.0f || tile.activationLeverTimer == 1.0f)) {
                        this.sendActionPacket(tile, player, 14);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void sendActionPacket(TileEntityControlPanel tile, EntityPlayer player, int action) {
        if (player.field_70170_p.field_72995_K) {
            TFNetworkManager.networkWrapper.sendToServer((IMessage)new MessageTileTrigger(new ItemCSD.DimensionalCoords(tile), player, action));
        }
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("iron_block");
    }
}

