/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.achievement;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fiskfille.tf.asm.TFTranslator;
import fiskfille.tf.common.achievement.TFAchievement;
import fiskfille.tf.common.block.TFBlocks;
import fiskfille.tf.common.item.TFItems;
import fiskfille.tf.common.item.TFSubItems;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraftforge.common.AchievementPage;

public class TFAchievements {
    public static final Achievement transformersMod = new TFAchievement("transformers_mod", 0, 0, null).func_75966_h().func_75971_g();
    public static final Achievement transformium = new TFAchievement("transformium", 2, -2, transformersMod).func_75971_g();
    public static final Achievement transform = new TFAchievement("transform", 4, -2, transformium).func_75971_g();
    public static final Achievement firstMissile = new TFAchievement("shoot_missile", 4, 0, transform).func_75971_g();
    public static final Achievement donate = new TFAchievement("donate", -3, -1, transformersMod).func_75987_b().func_75971_g();
    public static final Achievement detonateSeed = new TFAchievement("detonateSeed", -1, -4, transformium).func_75987_b().func_75971_g();
    public static final Achievement tracks = new TFAchievement("tracks", -5, -3, null).func_75971_g();
    public static final Achievement skystrike = new TFAchievement("skystrike", -7, -5, null).func_75987_b().func_75971_g();
    public static final Achievement purge = new TFAchievement("purge", -7, -4, tracks).func_75987_b().func_75971_g();
    public static final Achievement vurp = new TFAchievement("vurp", -7, -3, null).func_75987_b().func_75971_g();
    public static final Achievement subwoofer = new TFAchievement("subwoofer", -7, -2, null).func_75987_b().func_75971_g();
    public static final Achievement sharpshooter = new TFAchievement("sharpshooter", 6, 1, firstMissile).func_75987_b().func_75971_g();
    public static final List<Achievement> achievements = Lists.newArrayList();
    private static final Map<Achievement, ItemStack> displayItems = Maps.newHashMap();
    private static boolean init = false;

    public static void register() {
        if (!init) {
            init = true;
            for (Field field : TFAchievements.class.getFields()) {
                if (!field.getType().getName().equals(Achievement.class.getName())) continue;
                try {
                    achievements.add((Achievement)field.get(null));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        TFAchievements.setItem(transformersMod, TFBlocks.energonCrystal);
        TFAchievements.setItem(transformium, TFItems.transformiumFragment);
        TFAchievements.setItem(transform, TFSubItems.wheel);
        TFAchievements.setItem(firstMissile, TFItems.missile);
        TFAchievements.setItem(donate, Items.field_151166_bC);
        TFAchievements.setItem(detonateSeed, TFBlocks.transformiumSeed);
        TFAchievements.setItem(tracks, TFSubItems.tank_track);
        TFAchievements.setItem(skystrike, TFSubItems.skystrike_torso_base);
        TFAchievements.setItem(purge, TFSubItems.purge_torso_base);
        TFAchievements.setItem(vurp, TFSubItems.vurp_torso_base);
        TFAchievements.setItem(subwoofer, TFSubItems.subwoofer_torso_base);
        TFAchievements.setItem(sharpshooter, TFItems.vurpsSniper);
        try {
            Field itemField = Achievement.class.getField(TFTranslator.getMappedName("field_75990_d", "theItemStack"));
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(itemField, itemField.getModifiers() & 0xFFFFFFEF);
            for (Achievement achievement : achievements) {
                itemField.set(achievement, displayItems.get(achievement));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (AchievementPage.getAchievementPage((String)"Transformers") == null) {
            AchievementPage.registerAchievementPage((AchievementPage)new AchievementPage("Transformers", achievements.toArray(new Achievement[achievements.size()])));
        }
    }

    private static void setItem(Achievement achievement, ItemStack itemstack) {
        displayItems.put(achievement, itemstack);
    }

    private static void setItem(Achievement achievement, ItemStack[] aitemstack) {
        TFAchievements.setItem(achievement, aitemstack[1]);
    }

    private static void setItem(Achievement achievement, Item item) {
        TFAchievements.setItem(achievement, new ItemStack(item));
    }

    private static void setItem(Achievement achievement, Block block) {
        TFAchievements.setItem(achievement, new ItemStack(block));
    }
}

