/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.client.tutorial;

import com.google.common.collect.Maps;
import fiskfille.tf.client.tutorial.EnumTutorialType;
import fiskfille.tf.common.data.TFData;
import fiskfille.tf.common.transformer.base.Transformer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;

public class TutorialHandler {
    public static Map<EnumTutorialType, Boolean> tutorialsCompleted = Maps.newHashMap();
    private static final File directory = new File("tf-tutorials.txt");
    public static EnumTutorialType currentTutorial = null;
    public static EnumTutorialType completedTutorial = null;
    public static int animationTimer;

    public static void init() {
        TutorialHandler.load();
        if (tutorialsCompleted.isEmpty()) {
            for (EnumTutorialType type : EnumTutorialType.values()) {
                tutorialsCompleted.put(type, false);
            }
        }
    }

    public static void completeTutorial(EnumTutorialType type) {
        currentTutorial = null;
        tutorialsCompleted.put(type, true);
        TutorialHandler.save();
        completedTutorial = type;
        animationTimer = 100;
    }

    public static void openTutorial(EntityPlayer player, Transformer transformer) {
        EnumTutorialType type = transformer.getTutorialType(TFData.ALT_MODE.get(player));
        if (type != null && !TutorialHandler.isCompleted(type)) {
            currentTutorial = type;
        }
    }

    private static boolean isCompleted(EnumTutorialType type) {
        return tutorialsCompleted.get((Object)type);
    }

    public static void tick(EntityPlayer player) {
        if (currentTutorial != null) {
            TutorialHandler.currentTutorial.ticker.tick(player);
        }
        if (animationTimer > 0) {
            --animationTimer;
        }
        if (animationTimer == 0) {
            completedTutorial = null;
        }
    }

    public static void shoot(EntityPlayer player) {
        if (currentTutorial != null) {
            TutorialHandler.currentTutorial.ticker.shoot(player);
        }
    }

    public static void save() {
        try {
            PrintWriter out = new PrintWriter(directory);
            if (!directory.exists()) {
                directory.createNewFile();
            }
            String s = "";
            for (Map.Entry<EnumTutorialType, Boolean> e : tutorialsCompleted.entrySet()) {
                s = s + e.getKey().name() + ":" + e.getValue() + "\n";
            }
            out.println(s.substring(0, s.length() - 1));
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void load() {
        try {
            if (!directory.exists()) {
                directory.createNewFile();
            }
            BufferedReader in = new BufferedReader(new FileReader(directory));
            String s = "";
            while ((s = in.readLine()) != null) {
                String[] astring = s.split(":");
                String key = astring[0];
                String value = astring[1];
                for (EnumTutorialType type : EnumTutorialType.values()) {
                    if (!key.equals(type.name())) continue;
                    tutorialsCompleted.put(type, Boolean.valueOf(value));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

