/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.client.render.tileentity;

import fiskfille.tf.client.model.tileentity.ModelRelayTorch;
import fiskfille.tf.client.model.tileentity.ModelRelayTower;
import fiskfille.tf.common.tileentity.TileEntityRelayTorch;
import fiskfille.tf.common.tileentity.TileEntityRelayTower;
import fiskfille.tf.helper.TFRenderHelper;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderRelayTower
extends TileEntitySpecialRenderer {
    private ModelRelayTower modelTower = new ModelRelayTower();
    private ModelRelayTower modelTorch = new ModelRelayTorch();

    public void render(TileEntityRelayTower tower, double x, double y, double z, float partialTicks) {
        World world = tower.func_145831_w();
        int metadata = 0;
        if (world != null) {
            metadata = tower.func_145832_p();
        }
        if (tower.isValid(metadata)) {
            int progress;
            ModelRelayTower model = this.getModel(tower);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
            if (tower instanceof TileEntityRelayTorch && world != null) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)metadata);
                if (dir == ForgeDirection.UP) {
                    GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                } else if (dir == ForgeDirection.DOWN) {
                    GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
                } else {
                    int[] rotations = new int[]{0, 2, 3, 1};
                    GL11.glRotatef((float)(90 * rotations[(metadata - 2) % 4]), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
                }
            } else {
                GL11.glRotatef((float)(metadata * 90), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
            }
            this.func_147499_a(new ResourceLocation("transformers", String.format("textures/models/tiles/relay_%s.png", tower instanceof TileEntityRelayTorch ? "torch" : "tower")));
            model.setBreaking(false);
            model.render(tower, partialTicks);
            this.func_147499_a(new ResourceLocation("transformers", String.format("textures/models/tiles/relay_%s_lights.png", tower instanceof TileEntityRelayTorch ? "torch" : "tower")));
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            TFRenderHelper.setLighting(61680);
            model.render(tower, partialTicks);
            TFRenderHelper.resetLighting();
            GL11.glEnable((int)2896);
            if (world != null && (progress = TFRenderHelper.getBlockDestroyProgress(world, tower.field_145851_c, tower.field_145848_d, tower.field_145849_e)) >= 0) {
                OpenGlHelper.func_148821_a((int)774, (int)768, (int)1, (int)0);
                this.func_147499_a(new ResourceLocation(String.format("textures/blocks/destroy_stage_%s.png", progress)));
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                GL11.glPushMatrix();
                GL11.glEnable((int)32823);
                GL11.glAlphaFunc((int)516, (float)0.1f);
                GL11.glEnable((int)3008);
                model.setBreaking(true);
                model.render(tower, partialTicks);
                GL11.glDisable((int)3008);
                GL11.glDisable((int)32823);
                GL11.glEnable((int)3008);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glPopMatrix();
            }
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
            if (world != null) {
                TFRenderHelper.renderEnergyTransmissions(tower, x, y, z, partialTicks);
            }
        }
    }

    public ModelRelayTower getModel(TileEntityRelayTower tower) {
        if (tower instanceof TileEntityRelayTorch) {
            return this.modelTorch;
        }
        return this.modelTower;
    }

    public void func_147500_a(TileEntity tileentity, double d, double d1, double d2, float f) {
        this.render((TileEntityRelayTower)tileentity, d, d1, d2, f);
    }
}

