/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.client.render.tileentity;

import fiskfille.tf.client.render.shader.PortalShader;
import fiskfille.tf.common.block.TFBlocks;
import fiskfille.tf.common.data.tile.TileDataControlPanel;
import fiskfille.tf.common.tileentity.TileEntityGroundBridgeTeleporter;
import fiskfille.tf.config.TFConfig;
import fiskfille.tf.helper.TFRenderHelper;
import fiskfille.tf.helper.TFTileHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class RenderGroundBridgeTeleporter
extends TileEntitySpecialRenderer {
    private static final ResourceLocation PORTAL_EFFECT = new ResourceLocation("transformers", "textures/misc/portal_effect.png");
    private PortalShader shader;

    public RenderGroundBridgeTeleporter() {
        try {
            this.shader = new PortalShader();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void render(TileEntityGroundBridgeTeleporter tileentity, double x, double y, double z, float partialTicks) {
        int metadata = 0;
        if (tileentity.func_145831_w() != null) {
            metadata = tileentity.func_145832_p();
        }
        if ((metadata & 1) == 1) {
            TileDataControlPanel data;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
            if (tileentity.controlPanel != null && (data = (TileDataControlPanel)TFTileHelper.getTileData(tileentity.controlPanel)) != null) {
                if (tileentity.isReturnPortal(metadata)) {
                    GL11.glRotatef((float)(90 * data.direction), (float)0.0f, (float)1.0f, (float)0.0f);
                } else {
                    GL11.glRotatef((float)(90 * data.frameDirection), (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            float f1 = 1.0f - (tileentity.lastUpdate > 0 ? (float)tileentity.lastUpdate + partialTicks - 1.0f : 0.0f) / 6.0f;
            if (tileentity.lastUpdate == 0) {
                f1 = MathHelper.func_76131_a((float)((float)tileentity.ticks + partialTicks), (float)0.0f, (float)6.0f) / 6.0f;
            }
            f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)f1, (float)f1, (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TFRenderHelper.setLighting(61680);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glAlphaFunc((int)516, (float)0.003921569f);
            if (this.shader == null || TFConfig.oldPortalRender) {
                float scale = 1.9425f;
                float radius = 1.5f;
                this.func_147499_a(TextureMap.field_110575_b);
                this.drawPortalOld(0.0f, 0.0f, 0.0f, scale, radius, false);
                this.drawPortalOld(0.0f, 0.0f, 0.0f, scale, radius, true);
            } else {
                float zOffset = 0.6f;
                float scale = 1.9f;
                this.func_147499_a(PORTAL_EFFECT);
                GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                this.shader.start();
                this.shader.setTime((float)tileentity.ticks + partialTicks);
                GL11.glRotatef((float)(((float)tileentity.ticks + partialTicks) * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                this.drawPortal(0.0f, 0.0f, zOffset, scale, false);
                this.drawPortal(0.0f, 0.0f, zOffset, scale, true);
                this.shader.stop();
                GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            }
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glEnable((int)2896);
            TFRenderHelper.resetLighting();
            GL11.glPopMatrix();
        }
    }

    public void drawPortal(float offsetX, float offsetY, float offsetZ, float scale, boolean invert) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)offsetX, (float)offsetY, (float)offsetZ);
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(4);
        float corners = 45.0f;
        float angle = 360.0f / corners;
        float offset = 0.0f;
        for (int i = 0; i < 3; ++i) {
            float radius = 0.0f;
            float innerRadius = 0.0f;
            float dent = 0.0f;
            if (i == 0) {
                radius = 2.0f;
                innerRadius = 1.0f;
                dent = -1.0f;
            } else if (i == 1) {
                radius = 1.0f;
                innerRadius = 0.25f;
                dent = -0.5f;
            } else {
                radius = 0.25f;
            }
            for (float f = 0.0f; f < corners; f += 1.0f) {
                float f1 = f - 1.0f;
                if (f == corners - 1.0f) {
                    f += 0.001f;
                }
                Vec3 pos1 = Vec3.func_72443_a((double)0.0, (double)radius, (double)0.0);
                Vec3 pos2 = Vec3.func_72443_a((double)0.0, (double)radius, (double)0.0);
                pos1.func_72446_c(angle * f * (float)Math.PI / 180.0f);
                pos2.func_72446_c(angle * f1 * (float)Math.PI / 180.0f);
                Vec3 pos3 = Vec3.func_72443_a((double)((pos1.field_72450_a + pos2.field_72450_a) / 2.0), (double)((pos1.field_72448_b + pos2.field_72448_b) / 2.0), (double)((pos1.field_72449_c + pos2.field_72449_c) / 2.0));
                Vec3 pos4 = Vec3.func_72443_a((double)0.0, (double)innerRadius, (double)0.0);
                Vec3 pos5 = Vec3.func_72443_a((double)0.0, (double)innerRadius, (double)0.0);
                pos4.func_72446_c(angle * f * (float)Math.PI / 180.0f);
                pos5.func_72446_c(angle * f1 * (float)Math.PI / 180.0f);
                if (!invert) {
                    tessellator.func_78377_a(pos3.field_72450_a, pos3.field_72448_b, (double)offset);
                    tessellator.func_78377_a(pos2.field_72450_a, pos2.field_72448_b, (double)offset);
                    tessellator.func_78377_a(pos5.field_72450_a, pos5.field_72448_b, (double)(dent + offset));
                    tessellator.func_78377_a(pos1.field_72450_a, pos1.field_72448_b, (double)offset);
                    tessellator.func_78377_a(pos3.field_72450_a, pos3.field_72448_b, (double)offset);
                    tessellator.func_78377_a(pos4.field_72450_a, pos4.field_72448_b, (double)(dent + offset));
                    tessellator.func_78377_a(pos3.field_72450_a, pos3.field_72448_b, (double)offset);
                    tessellator.func_78377_a(pos5.field_72450_a, pos5.field_72448_b, (double)(dent + offset));
                    tessellator.func_78377_a(pos4.field_72450_a, pos4.field_72448_b, (double)(dent + offset));
                    continue;
                }
                tessellator.func_78377_a(pos5.field_72450_a, pos5.field_72448_b, (double)(dent + offset));
                tessellator.func_78377_a(pos2.field_72450_a, pos2.field_72448_b, (double)offset);
                tessellator.func_78377_a(pos3.field_72450_a, pos3.field_72448_b, (double)offset);
                tessellator.func_78377_a(pos1.field_72450_a, pos1.field_72448_b, (double)offset);
                tessellator.func_78377_a(pos4.field_72450_a, pos4.field_72448_b, (double)(dent + offset));
                tessellator.func_78377_a(pos3.field_72450_a, pos3.field_72448_b, (double)offset);
                tessellator.func_78377_a(pos3.field_72450_a, pos3.field_72448_b, (double)offset);
                tessellator.func_78377_a(pos4.field_72450_a, pos4.field_72448_b, (double)(dent + offset));
                tessellator.func_78377_a(pos5.field_72450_a, pos5.field_72448_b, (double)(dent + offset));
            }
            offset += dent;
        }
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    public void drawPortalOld(float offsetX, float offsetY, float offsetZ, float scale, float radius, boolean invert) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (offsetX != 0.0f || offsetY != 0.0f || offsetZ != 0.0f) {
            GL11.glTranslatef((float)offsetX, (float)offsetY, (float)offsetZ);
        }
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(4);
        IIcon icon = TFBlocks.groundBridgeTeleporter.func_149691_a(0, 0);
        float indent = 1.0f;
        float corners = 60.0f;
        float angle = 360.0f / corners;
        float zoom = 46.0f * (16.0f / (float)icon.func_94211_a());
        int j = 0;
        while ((float)j <= corners) {
            Vec3 pos1 = Vec3.func_72443_a((double)0.0, (double)radius, (double)0.0);
            Vec3 pos2 = Vec3.func_72443_a((double)0.0, (double)radius, (double)0.0);
            pos1.func_72446_c(angle * (float)j * (float)Math.PI / 180.0f);
            pos2.func_72446_c(angle * (float)(j - 1) * (float)Math.PI / 180.0f);
            float minX = -icon.func_94214_a(8.0);
            float minY = icon.func_94207_b(8.0);
            Vec3 tex1 = Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.0);
            Vec3 tex2 = Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.0);
            tex1.func_72446_c((angle * (float)j + 135.0f) * (float)Math.PI / 180.0f);
            tex2.func_72446_c((angle * (float)(j - 1) + 135.0f) * (float)Math.PI / 180.0f);
            tex1.field_72450_a /= (double)zoom;
            tex1.field_72448_b /= (double)zoom;
            tex1.field_72449_c /= (double)zoom;
            tex2.field_72450_a /= (double)zoom;
            tex2.field_72448_b /= (double)zoom;
            tex2.field_72449_c /= (double)zoom;
            tex1 = tex1.func_72441_c((double)minX, (double)minY, 0.0);
            tex2 = tex2.func_72441_c((double)minX, (double)minY, 0.0);
            if (!invert) {
                tessellator.func_78374_a(pos1.field_72450_a, pos1.field_72448_b, 0.0, -tex1.field_72450_a, tex1.field_72448_b);
                tessellator.func_78374_a(pos2.field_72450_a, pos2.field_72448_b, 0.0, -tex2.field_72450_a, tex2.field_72448_b);
                tessellator.func_78374_a(0.0, 0.0, (double)(-indent), (double)(-minX), (double)minY);
            } else {
                tessellator.func_78374_a(pos2.field_72450_a, pos2.field_72448_b, 0.0, -tex2.field_72450_a, tex2.field_72448_b);
                tessellator.func_78374_a(pos1.field_72450_a, pos1.field_72448_b, 0.0, -tex1.field_72450_a, tex1.field_72448_b);
                tessellator.func_78374_a(0.0, 0.0, (double)(-indent), (double)(-minX), (double)minY);
            }
            ++j;
        }
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    public void func_147500_a(TileEntity tileentity, double d, double d1, double d2, float f) {
        this.render((TileEntityGroundBridgeTeleporter)tileentity, d, d1, d2, f);
    }
}

