/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.client.render.tileentity;

import fiskfille.tf.common.tileentity.TileEntityEnergonTank;
import fiskfille.tf.helper.TFFluidRenderHelper;
import fiskfille.tf.helper.TFRenderHelper;
import fiskfille.tf.helper.TFTileHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RenderEnergonTank
extends TileEntitySpecialRenderer {
    private RenderBlocks renderBlocks = RenderBlocks.getInstance();

    public void render(TileEntityEnergonTank tile, double x, double y, double z, float partialTicks) {
        float scale;
        World world = tile.func_145831_w();
        FluidStack stack = tile.data.getFluid();
        if (stack == null || stack.getFluid() == null || stack.amount <= 0) {
            return;
        }
        int color = stack.getFluid().getColor(stack);
        int[] displayList = TFFluidRenderHelper.getFluidDisplayLists(this.renderBlocks, stack, tile.func_145831_w(), false);
        if (displayList == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.func_147499_a(TextureMap.field_110575_b);
        float[] afloat = TFRenderHelper.hexToRGB(color);
        GL11.glColor4f((float)afloat[0], (float)afloat[1], (float)afloat[2], (float)1.0f);
        float scaleY = scale = 0.99f;
        float scaleOffset = 0.0f;
        if (world != null) {
            TileEntityEnergonTank tileBase = TFTileHelper.getTileBase(tile);
            boolean connectAbove = false;
            boolean connectBelow = false;
            if (tileBase == TFTileHelper.getTileBase(world.func_147438_o(tile.field_145851_c, tile.field_145848_d + 1, tile.field_145849_e))) {
                connectAbove = true;
            }
            if (tileBase == TFTileHelper.getTileBase(world.func_147438_o(tile.field_145851_c, tile.field_145848_d - 1, tile.field_145849_e))) {
                connectBelow = true;
            }
            if (connectAbove && connectBelow) {
                scaleY = 1.0f;
            } else if (connectAbove) {
                float diff = (1.0f - scaleY) / 2.0f;
                scaleY += diff;
                scaleOffset = 0.5f;
            } else if (connectBelow) {
                float diff = (1.0f - scaleY) / 2.0f;
                scaleY += diff;
                scaleOffset = -0.5f;
            }
        }
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glTranslatef((float)0.5f, (float)(0.5f + scaleOffset), (float)0.5f);
        GL11.glScalef((float)scale, (float)scaleY, (float)scale);
        GL11.glTranslatef((float)-0.5f, (float)(-0.5f - scaleOffset), (float)-0.5f);
        int dl = (int)((float)stack.amount / (float)tile.data.getCapacity() * 99.0f);
        GL11.glCallList((int)displayList[MathHelper.func_76125_a((int)dl, (int)0, (int)99)]);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public void func_147496_a(World world) {
        this.renderBlocks = new RenderBlocks((IBlockAccess)world);
    }

    public void func_147500_a(TileEntity tileentity, double d, double d1, double d2, float f) {
        this.render((TileEntityEnergonTank)tileentity, d, d1, d2, f);
    }
}

