/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.client.render.shader;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public abstract class ShaderProgram {
    private static final FloatBuffer MATRIX_BUFFER = BufferUtils.createFloatBuffer((int)16);
    private static final List<ShaderProgram> PROGRAMS = new ArrayList<ShaderProgram>();
    private Map<String, Integer> uniforms = new HashMap<String, Integer>();
    private int programID;
    private int vertexShaderID;
    private int geometryShaderID;
    private int fragmentShaderID;
    private boolean hasGeometryShader;

    public ShaderProgram(String vertex, String fragment, String geometry) throws Exception {
        this.hasGeometryShader = geometry != null;
        this.vertexShaderID = ShaderProgram.loadShader(vertex, 35633);
        this.fragmentShaderID = ShaderProgram.loadShader(fragment, 35632);
        if (this.hasGeometryShader) {
            this.geometryShaderID = ShaderProgram.loadShader(geometry, 36313);
        }
        this.programID = OpenGlHelper.func_153183_d();
        OpenGlHelper.func_153178_b((int)this.programID, (int)this.vertexShaderID);
        OpenGlHelper.func_153178_b((int)this.programID, (int)this.fragmentShaderID);
        if (this.hasGeometryShader) {
            OpenGlHelper.func_153178_b((int)this.programID, (int)this.geometryShaderID);
        }
        this.bindAttributes();
        OpenGlHelper.func_153179_f((int)this.programID);
        if (OpenGlHelper.func_153175_a((int)this.programID, (int)35714) == 0) {
            throw new RuntimeException("Error creating shader: " + ShaderProgram.getLogInfoProgram(this.programID));
        }
        GL20.glValidateProgram((int)this.programID);
        if (OpenGlHelper.func_153175_a((int)this.programID, (int)35715) == 0) {
            throw new RuntimeException("Error creating shader: " + ShaderProgram.getLogInfoProgram(this.programID));
        }
        PROGRAMS.add(this);
        for (String uniform : this.getUniforms()) {
            int location = this.getUniformLocation(uniform);
            if (location == -1) {
                System.err.println("Could not find uniform location for " + uniform + " in " + this.getClass().getSimpleName() + "!");
            } else if (this.uniforms.containsValue(location)) {
                System.err.println("Duplicate uniform location for " + uniform + " in " + this.getClass().getSimpleName() + "!");
            }
            this.uniforms.put(uniform, location);
        }
        this.stop();
    }

    public ShaderProgram(String vertex, String fragment) throws Exception {
        this(vertex, fragment, null);
    }

    protected abstract void bindAttributes();

    protected abstract String[] getUniforms();

    protected void bindAttribute(int index, String name) {
        GL20.glBindAttribLocation((int)this.programID, (int)index, (CharSequence)name);
    }

    protected int getUniformLocation(String name) {
        return OpenGlHelper.func_153194_a((int)this.programID, (CharSequence)name);
    }

    public void setUniform(String name, float value) {
        GL20.glUniform1f((int)this.uniforms.get(name), (float)value);
    }

    public void setUniform(String name, int value) {
        GL20.glUniform1i((int)this.uniforms.get(name), (int)value);
    }

    public void setUniform(String name, Vector3f value) {
        GL20.glUniform3f((int)this.uniforms.get(name), (float)value.x, (float)value.y, (float)value.z);
    }

    public void setUniform(String name, boolean value) {
        GL20.glUniform1f((int)this.uniforms.get(name), (float)(value ? 1.0f : 0.0f));
    }

    public void setUniform(String name, Matrix4f value) {
        value.store(MATRIX_BUFFER);
        MATRIX_BUFFER.flip();
        GL20.glUniformMatrix4((int)this.uniforms.get(name), (boolean)false, (FloatBuffer)MATRIX_BUFFER);
    }

    public void setUniform(String name, Vector4f value) {
        GL20.glUniform4f((int)this.uniforms.get(name), (float)value.x, (float)value.y, (float)value.z, (float)value.w);
    }

    public void start() {
        OpenGlHelper.func_153161_d((int)this.programID);
    }

    public void stop() {
        OpenGlHelper.func_153161_d((int)0);
    }

    public void delete() {
        this.stop();
        GL20.glDetachShader((int)this.programID, (int)this.vertexShaderID);
        GL20.glDetachShader((int)this.programID, (int)this.fragmentShaderID);
        if (this.hasGeometryShader) {
            GL20.glDetachShader((int)this.programID, (int)this.geometryShaderID);
        }
        OpenGlHelper.func_153180_a((int)this.vertexShaderID);
        OpenGlHelper.func_153180_a((int)this.fragmentShaderID);
        if (this.hasGeometryShader) {
            OpenGlHelper.func_153180_a((int)this.geometryShaderID);
        }
        OpenGlHelper.func_153187_e((int)this.programID);
        PROGRAMS.remove(this);
    }

    public static int loadShader(String resource, int type) throws Exception {
        String line;
        String source = "";
        BufferedReader in = new BufferedReader(new InputStreamReader(ShaderProgram.class.getResourceAsStream("/assets/transformers/shaders/" + resource)));
        while ((line = in.readLine()) != null) {
            source = source + line + "\n";
        }
        int shaderID = OpenGlHelper.func_153195_b((int)type);
        byte[] bytes = source.getBytes();
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)bytes.length).put(bytes);
        buffer.flip();
        OpenGlHelper.func_153169_a((int)shaderID, (ByteBuffer)buffer);
        OpenGlHelper.func_153170_c((int)shaderID);
        if (OpenGlHelper.func_153157_c((int)shaderID, (int)35713) == 0) {
            System.err.println("Failed to compile shader: " + resource);
            System.err.println(ShaderProgram.getLogInfoShader(shaderID));
        }
        return shaderID;
    }

    public static void deletePrograms() {
        int size = PROGRAMS.size();
        for (int i = 0; i < size; ++i) {
            PROGRAMS.get(0).delete();
        }
        PROGRAMS.clear();
    }

    private static String getLogInfoShader(int shader) {
        return OpenGlHelper.func_153158_d((int)shader, (int)OpenGlHelper.func_153157_c((int)shader, (int)35716));
    }

    private static String getLogInfoProgram(int program) {
        return OpenGlHelper.func_153166_e((int)program, (int)OpenGlHelper.func_153175_a((int)program, (int)35716));
    }
}

