/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.client.render.item;

import fiskfille.tf.client.model.transformer.ModelTransformerBase;
import fiskfille.tf.client.model.transformer.definition.TFModelRegistry;
import fiskfille.tf.client.model.transformer.definition.TransformerModel;
import fiskfille.tf.common.transformer.base.Transformer;
import fiskfille.tf.helper.TFArmorDyeHelper;
import fiskfille.tf.helper.TFRenderHelper;
import fiskfille.tf.helper.TFTextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderItemArmor
implements IItemRenderer {
    private Minecraft mc = Minecraft.func_71410_x();
    private Transformer transformer;
    private int armorPiece;

    public RenderItemArmor(Transformer transformer, int armorPiece) {
        this.armorPiece = armorPiece;
        this.transformer = transformer;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.ENTITY || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        TransformerModel tfModel = TFModelRegistry.getModel(this.transformer);
        ModelTransformerBase model = tfModel.getItemInventoryModel();
        switch (this.armorPiece) {
            case 0: {
                GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
                break;
            }
            case 1: {
                GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
                break;
            }
            case 2: {
                GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
                break;
            }
            case 3: {
                GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            RenderHelper.func_74520_c();
        }
        if (TFArmorDyeHelper.isDyed(item)) {
            float[] primaryColor = TFRenderHelper.hexToRGB(TFArmorDyeHelper.getPrimaryColor(item));
            float[] secondaryColor = TFRenderHelper.hexToRGB(TFArmorDyeHelper.getSecondaryColor(item));
            GL11.glColor4f((float)primaryColor[0], (float)primaryColor[1], (float)primaryColor[2], (float)1.0f);
            this.mc.func_110434_K().func_110577_a(tfModel.getTexture(null, "_primary"));
            this.renderArmor(type, model);
            GL11.glColor4f((float)secondaryColor[0], (float)secondaryColor[1], (float)secondaryColor[2], (float)1.0f);
            this.mc.func_110434_K().func_110577_a(tfModel.getTexture(null, "_secondary"));
            this.renderArmor(type, model);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(tfModel.getTexture(null, "_base"));
            this.renderArmor(type, model);
        } else {
            this.mc.func_110434_K().func_110577_a(tfModel.getTexture(null, ""));
        }
        this.renderArmor(type, model);
        if (tfModel.hasLightsLayer()) {
            TFRenderHelper.setLighting(61680);
            this.mc.func_110434_K().func_110577_a(tfModel.getTexture(null, "_lights"));
            this.renderArmor(type, model);
            TFRenderHelper.resetLighting();
        }
        if (item.hasEffect(0)) {
            this.mc.func_110434_K().func_110577_a(TFTextureHelper.RES_ITEM_GLINT);
            GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            GL11.glDepthFunc((int)514);
            GL11.glDepthMask((boolean)false);
            for (int i = 0; i < 2; ++i) {
                float f1 = (float)Minecraft.func_71386_F() % (3000.0f + (float)(i * 1873)) / (float)(3000 + i * 1873) * 256.0f / 64.0f;
                float f2 = 0.33333334f;
                GL11.glDisable((int)2896);
                GL11.glColor4f((float)0.5f, (float)0.25f, (float)0.8f, (float)1.0f);
                GL11.glBlendFunc((int)768, (int)1);
                GL11.glMatrixMode((int)5890);
                GL11.glLoadIdentity();
                GL11.glScalef((float)f2, (float)f2, (float)f2);
                GL11.glRotatef((float)(30 - i * 60), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)f1, (float)0.0f);
                GL11.glMatrixMode((int)5888);
                this.renderArmor(type, model);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glMatrixMode((int)5890);
            GL11.glDepthMask((boolean)true);
            GL11.glLoadIdentity();
            GL11.glMatrixMode((int)5888);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
            GL11.glEnable((int)3008);
        }
        GL11.glDisable((int)3042);
    }

    private void renderGlint(int p_77018_1_, int x, int y, int width, int height) {
        float zLevel = 0.0f;
        for (int j1 = 0; j1 < 2; ++j1) {
            OpenGlHelper.func_148821_a((int)772, (int)1, (int)0, (int)0);
            float f = 0.00390625f;
            float f1 = 0.00390625f;
            float f2 = Minecraft.func_71386_F() % (long)(3000 + j1 * 1873) / (long)(3000 + j1 * 1873) * 256L;
            float f3 = 0.0f;
            Tessellator tessellator = Tessellator.field_78398_a;
            float f4 = 4.0f;
            if (j1 == 1) {
                f4 = -1.0f;
            }
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)x, (double)(y + height), (double)zLevel, (double)((f2 + (float)height * f4) * f), (double)((f3 + (float)height) * f1));
            tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)zLevel, (double)((f2 + (float)width + (float)height * f4) * f), (double)((f3 + (float)height) * f1));
            tessellator.func_78374_a((double)(x + width), (double)y, (double)zLevel, (double)((f2 + (float)width) * f), (double)(f3 * f1));
            tessellator.func_78374_a((double)x, (double)y, (double)zLevel, (double)(f2 * f), (double)(f3 * f1));
            tessellator.func_78381_a();
        }
    }

    private void renderArmor(IItemRenderer.ItemRenderType type, ModelTransformerBase model) {
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)210.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.9f, (float)-1.0f, (float)0.2f);
            if (this.armorPiece == 0) {
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.1f);
            } else if (this.armorPiece == 1) {
                GL11.glTranslatef((float)-0.2f, (float)-0.4f, (float)0.0f);
            } else if (this.armorPiece == 2) {
                GL11.glTranslatef((float)0.0f, (float)-0.2f, (float)0.0f);
            }
            float scale = 1.0f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            model.renderArmorPiece(this.armorPiece);
            GL11.glPopMatrix();
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.5f, (float)-0.5f, (float)0.0f);
            if (this.armorPiece == 0) {
                GL11.glTranslatef((float)-0.25f, (float)0.6f, (float)-0.2f);
            } else if (this.armorPiece == 1) {
                GL11.glTranslatef((float)-0.1f, (float)0.1f, (float)-0.4f);
            } else if (this.armorPiece == 2) {
                GL11.glTranslatef((float)0.1f, (float)0.3f, (float)-0.35f);
                GL11.glRotatef((float)35.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            } else if (this.armorPiece == 3) {
                GL11.glTranslatef((float)-0.05f, (float)0.3f, (float)-0.3f);
                GL11.glRotatef((float)35.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            float scale = 0.7f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            model.renderArmorPiece(this.armorPiece);
            GL11.glPopMatrix();
        } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glPushMatrix();
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)150.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            if (this.armorPiece == 0) {
                float scale = 2.0f;
                GL11.glTranslatef((float)0.03125f, (float)0.0f, (float)0.0f);
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                GL11.glTranslatef((float)0.0f, (float)0.125f, (float)0.0f);
            } else if (this.armorPiece == 1) {
                float scale = 2.0f;
                GL11.glTranslatef((float)0.5f, (float)-0.1f, (float)0.0f);
                GL11.glScalef((float)scale, (float)scale, (float)scale);
            } else if (this.armorPiece == 2) {
                float scale = 2.0f;
                GL11.glTranslatef((float)0.325f, (float)-0.6f, (float)0.0f);
                GL11.glScalef((float)scale, (float)scale, (float)scale);
            } else if (this.armorPiece == 3) {
                float scale = 2.0f;
                GL11.glTranslatef((float)0.3125f, (float)0.0f, (float)0.0f);
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                GL11.glTranslatef((float)0.0f, (float)-0.125f, (float)0.0f);
            }
            model.renderArmorPiece(this.armorPiece);
            GL11.glPopMatrix();
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.1f);
            if (this.armorPiece == 0) {
                GL11.glTranslatef((float)0.0f, (float)1.125f, (float)0.0f);
            } else if (this.armorPiece == 1) {
                GL11.glTranslatef((float)0.0f, (float)0.6f, (float)-0.2f);
            } else if (this.armorPiece == 2) {
                GL11.glTranslatef((float)0.0f, (float)0.55f, (float)-0.1f);
            } else if (this.armorPiece == 3) {
                GL11.glTranslatef((float)0.0f, (float)0.7f, (float)-0.1f);
            }
            float scale = 1.0f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            model.renderArmorPiece(this.armorPiece);
            GL11.glPopMatrix();
        }
    }
}

