/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.client.model.transformer;

import com.google.common.collect.Lists;
import fiskfille.tf.client.model.AnimationModifier;
import fiskfille.tf.client.model.tools.ModelRendererTF;
import fiskfille.tf.client.model.tools.MowzieModelBase;
import fiskfille.tf.client.model.transformer.definition.TFModelRegistry;
import fiskfille.tf.client.model.transformer.definition.TransformerModel;
import fiskfille.tf.client.model.transformer.vehicle.ModelVehicleBase;
import fiskfille.tf.common.transformer.base.Transformer;
import fiskfille.tf.helper.TFArmorDyeHelper;
import fiskfille.tf.helper.TFHelper;
import fiskfille.tf.helper.TFRenderHelper;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;

public abstract class ModelTransformerBase
extends MowzieModelBase {
    private final float baseSpeed;
    private final float baseDegree;
    private AnimationModifier[] animModifiers;
    public int layerToRender;
    public float globalSpeed;
    public float globalDegree;
    public int backwardInverter = 1;

    public ModelTransformerBase(float speed, float degree, AnimationModifier ... modifiers) {
        this.baseSpeed = speed;
        this.baseDegree = degree;
        this.animModifiers = modifiers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        if (!(entity instanceof EntityPlayer)) return;
        EntityPlayer player = (EntityPlayer)entity;
        ItemStack head = player.func_82169_q(3);
        ItemStack chest = player.func_82169_q(2);
        ItemStack legs = player.func_82169_q(1);
        ItemStack feet = player.func_82169_q(0);
        boolean wearingHead = TFHelper.getTransformerFromArmor((EntityLivingBase)player, 3) == this.getTransformer();
        boolean wearingChest = TFHelper.getTransformerFromArmor((EntityLivingBase)player, 2) == this.getTransformer();
        boolean wearingLegs = TFHelper.getTransformerFromArmor((EntityLivingBase)player, 1) == this.getTransformer();
        boolean wearingFeet = TFHelper.getTransformerFromArmor((EntityLivingBase)player, 0) == this.getTransformer();
        TransformerModel tfModel = this.getTransformerModel();
        ModelVehicleBase vehicleModel = tfModel.getEffectiveVehicleModel(player);
        vehicleModel.func_78087_a(f, f1, f2, f3, f4, f5, (Entity)player);
        this.func_78087_a(f, f1, f2, f3, f4, f5, entity);
        if (TFHelper.isFullyTransformed(player)) {
            if (this.layerToRender != 2) return;
            vehicleModel.render(player, chest);
            return;
        } else {
            if (!wearingChest) {
                if (this.layerToRender == 1 && wearingHead) {
                    TFRenderHelper.setupRenderLayers(entity, head, tfModel.getHead());
                }
                if (this.layerToRender == 3 && wearingLegs) {
                    ArrayList hidden = Lists.newArrayList();
                    hidden.add(tfModel.getHead());
                    hidden.addAll(Arrays.asList(tfModel.getFeet()));
                    this.getWaist().hideUntil(tfModel.getLegs());
                    for (ModelRenderer model : hidden) {
                        model.field_78807_k = true;
                    }
                    TFRenderHelper.setupRenderLayers(entity, legs, this.getWaist());
                    for (ModelRenderer model : hidden) {
                        model.field_78807_k = false;
                    }
                }
                if (this.layerToRender == 4 && wearingFeet) {
                    this.getWaist().hideUntil(tfModel.getFeet());
                    tfModel.getHead().field_78807_k = true;
                    TFRenderHelper.setupRenderLayers(entity, feet, this.getWaist());
                    tfModel.getHead().field_78807_k = false;
                }
            } else if (!this.areIdentical(head, chest, legs, feet)) {
                ArrayList hidden = Lists.newArrayList();
                ItemStack itemstack = chest;
                if (this.layerToRender == 1) {
                    if (this.areIdentical(chest, head)) return;
                    this.getWaist().hideUntil(tfModel.getHead());
                    hidden.addAll(Arrays.asList(tfModel.getLegs()));
                    itemstack = head;
                } else if (this.layerToRender == 2) {
                    if (!this.areIdentical(chest, head)) {
                        hidden.add(tfModel.getHead());
                    }
                    if (!this.areIdentical(chest, legs)) {
                        hidden.addAll(Arrays.asList(tfModel.getLegs()));
                    } else if (!this.areIdentical(chest, feet)) {
                        hidden.addAll(Arrays.asList(tfModel.getFeet()));
                    }
                } else if (this.layerToRender == 3) {
                    if (this.areIdentical(chest, legs)) return;
                    this.getWaist().hideUntil(tfModel.getLegs());
                    hidden.add(tfModel.getHead());
                    itemstack = legs;
                    if (!this.areIdentical(legs, feet)) {
                        hidden.addAll(Arrays.asList(tfModel.getFeet()));
                    }
                } else {
                    if (this.areIdentical(legs, feet)) return;
                    this.getWaist().hideUntil(tfModel.getFeet());
                    hidden.add(tfModel.getHead());
                    itemstack = feet;
                }
                for (ModelRenderer model : hidden) {
                    model.field_78807_k = true;
                }
                TFRenderHelper.setupRenderLayers(entity, itemstack, this.getWaist());
                for (ModelRenderer model : hidden) {
                    model.field_78807_k = false;
                }
            } else if (this.layerToRender == 2) {
                TFRenderHelper.setupRenderLayers(entity, chest, this.getWaist());
            }
            this.getWaist().hideUntil(new ModelRenderer[0]);
        }
    }

    private boolean areIdentical(ItemStack ... itemstacks) {
        if (!TFArmorDyeHelper.areColorsIdentical(itemstacks)) {
            return false;
        }
        if (itemstacks.length > 1) {
            for (ItemStack itemstack : itemstacks) {
                if (itemstack != null && itemstacks[0] != null && itemstacks[0].hasEffect(0) == itemstack.hasEffect(0)) continue;
                return false;
            }
        }
        return true;
    }

    protected final TransformerModel getTransformerModel() {
        TransformerModel model = TFModelRegistry.getModel(this.getTransformer());
        if (model == null) {
            throw new RuntimeException(String.format("No TransformerModel instance registered for type '%s'!", this.getTransformer().getName()));
        }
        return model;
    }

    public void setupOffsets(EntityPlayer player, float progress, float limbSwing, float limbSwingAmount, float ticks, float rotationYaw, float rotationPitch, boolean wearingHead, boolean wearingChest, boolean wearingLegs, boolean wearingFeet) {
    }

    public void doActiveAnimations(EntityPlayer player, float progress, float limbSwing, float limbSwingAmount, float ticks, float rotationYaw, float rotationPitch, boolean wearingHead, boolean wearingChest, boolean wearingLegs, boolean wearingFeet) {
    }

    public void doWalkingAnimations(EntityPlayer player, float progress, float limbSwing, float limbSwingAmount, float ticks, float rotationYaw, float rotationPitch, boolean wearingHead, boolean wearingChest, boolean wearingLegs, boolean wearingFeet) {
    }

    public void doIdleAnimations(EntityPlayer player, float progress, float limbSwing, float limbSwingAmount, float ticks, float rotationYaw, float rotationPitch, boolean wearingHead, boolean wearingChest, boolean wearingLegs, boolean wearingFeet) {
    }

    public void doFallingAnimations(EntityPlayer player, float progress, float limbSwing, float limbSwingAmount, float ticks, float rotationYaw, float rotationPitch, boolean wearingHead, boolean wearingChest, boolean wearingLegs, boolean wearingFeet) {
    }

    public void doPartialAnimations(EntityPlayer player, float progress, float limbSwing, float limbSwingAmount, float ticks, float rotationYaw, float rotationPitch, boolean wearingHead, boolean wearingChest, boolean wearingLegs, boolean wearingFeet) {
    }

    public void doTransformationAnimations(EntityPlayer player, float progress, float limbSwing, float limbSwingAmount, float ticks, float rotationYaw, float rotationPitch, boolean wearingHead, boolean wearingChest, boolean wearingLegs, boolean wearingFeet) {
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ticks, float rotationYaw, float rotationPitch, float scale, Entity entity) {
        if (entity.field_70181_x == 1.25E-85) {
            ticks = 0.0f;
        }
        super.func_78087_a(limbSwing, limbSwingAmount, ticks, rotationYaw, rotationPitch, scale, entity);
        this.setToInitPose();
        this.globalSpeed = this.baseSpeed;
        this.globalDegree = this.baseDegree;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            boolean wearingHead = TFHelper.getTransformerFromArmor((EntityLivingBase)player, 3) == this.getTransformer();
            boolean wearingChest = TFHelper.getTransformerFromArmor((EntityLivingBase)player, 2) == this.getTransformer();
            boolean wearingLegs = TFHelper.getTransformerFromArmor((EntityLivingBase)player, 1) == this.getTransformer();
            boolean wearingFeet = TFHelper.getTransformerFromArmor((EntityLivingBase)player, 0) == this.getTransformer();
            float progress = TFHelper.getTransformationTimer(player);
            this.setupOffsets(player, progress, limbSwing, limbSwingAmount, ticks, rotationYaw, rotationPitch, wearingHead, wearingChest, wearingLegs, wearingFeet);
            block4: for (AnimationModifier modifier : this.animModifiers) {
                if (!modifier.predicate.apply((Object)player)) continue;
                switch (modifier.type) {
                    case SPEED: {
                        this.globalSpeed *= modifier.factor;
                        continue block4;
                    }
                    case DEGREE: {
                        this.globalDegree *= modifier.factor;
                    }
                }
            }
            this.backwardInverter = player.field_70701_bs < 0.0f ? -1 : 1;
            this.doActiveAnimations(player, progress, limbSwing, limbSwingAmount, ticks, rotationYaw, rotationPitch, wearingHead, wearingChest, wearingLegs, wearingFeet);
            if (TFHelper.getTransformer((EntityLivingBase)player) == this.getTransformer()) {
                if (this.onGround((Entity)player) || player.field_71075_bZ.field_75100_b) {
                    this.doWalkingAnimations(player, progress, limbSwing, limbSwingAmount, ticks, rotationYaw, rotationPitch, wearingHead, wearingChest, wearingLegs, wearingFeet);
                    this.doIdleAnimations(player, progress, limbSwing, limbSwingAmount, ticks, rotationYaw, rotationPitch, wearingHead, wearingChest, wearingLegs, wearingFeet);
                } else {
                    this.doFallingAnimations(player, progress, limbSwing, limbSwingAmount, ticks, rotationYaw, rotationPitch, wearingHead, wearingChest, wearingLegs, wearingFeet);
                }
            } else {
                this.doPartialAnimations(player, progress, limbSwing, limbSwingAmount, ticks, rotationYaw, rotationPitch, wearingHead, wearingChest, wearingLegs, wearingFeet);
            }
            this.doTransformationAnimations(player, progress, limbSwing, limbSwingAmount, ticks, rotationYaw, rotationPitch, wearingHead, wearingChest, wearingLegs, wearingFeet);
        }
    }

    protected void applyDefaultHittingAnimation(ModelRenderer upperArmR, ModelRenderer upperArmL, ModelRenderer head, ModelRenderer chest, ModelRenderer lowerArmR, ModelRenderer lowerArmL) {
        if (this.field_78095_p > -9990.0f) {
            float hitAnimation = this.field_78095_p;
            float change = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)hitAnimation) * this.PI * 2.0f)) * 0.2f;
            chest.field_78796_g += change;
            head.field_78796_g -= change;
            upperArmR.field_78796_g = (float)((double)upperArmR.field_78796_g + (double)change * 0.5);
            upperArmL.field_78796_g = (float)((double)upperArmL.field_78796_g + (double)change * 0.5);
            upperArmL.field_78795_f = (float)((double)upperArmL.field_78795_f + (double)change * 0.5);
            lowerArmR.field_78796_g = (float)((double)lowerArmR.field_78796_g + (double)change * 0.5);
            lowerArmL.field_78796_g = (float)((double)lowerArmL.field_78796_g + (double)change * 0.5);
            lowerArmL.field_78795_f = (float)((double)lowerArmL.field_78795_f + (double)change * 0.5);
            hitAnimation = 1.0f - this.field_78095_p;
            hitAnimation *= hitAnimation;
            hitAnimation *= hitAnimation;
            hitAnimation = 1.0f - hitAnimation;
            float f7 = MathHelper.func_76126_a((float)(hitAnimation * this.PI));
            float f8 = MathHelper.func_76126_a((float)(this.field_78095_p * this.PI)) * -(head.field_78795_f - 0.7f) * 0.75f;
            float armRXChange = (float)((double)upperArmR.field_78795_f - ((double)f7 * 1.2 + (double)f8)) * 0.5f;
            float armRZChange = MathHelper.func_76126_a((float)(this.field_78095_p * this.PI)) * -0.4f * 0.5f;
            upperArmR.field_78795_f += armRXChange;
            upperArmR.field_78796_g = (float)((double)upperArmR.field_78796_g + (double)(change * 2.0f) * 0.5);
            upperArmR.field_78808_h += armRZChange;
            lowerArmR.field_78795_f += armRXChange;
            lowerArmR.field_78796_g = (float)((double)lowerArmR.field_78796_g + (double)(change * 2.0f) * 0.5);
            lowerArmR.field_78808_h += armRZChange;
        }
    }

    protected void applyDefaultHoldingAnimation(ModelRenderer upperArmR, ModelRenderer upperArmL, ModelRenderer lowerArmR, ModelRenderer lowerArmL) {
        upperArmL.field_78795_f -= (float)this.field_78119_l * 0.125f;
        upperArmR.field_78795_f -= (float)this.field_78120_m * 0.125f;
        lowerArmL.field_78795_f -= (float)this.field_78119_l * 0.0625f;
        lowerArmR.field_78795_f -= (float)this.field_78120_m * 0.0625f;
    }

    public Transformer getTransformer() {
        return null;
    }

    public ModelRendererTF getWaist() {
        return null;
    }

    public void renderArmorPiece(int armorPiece) {
    }
}

