/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.client.model.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fiskfille.tf.client.model.tools.ModelRendererBreakable;
import fiskfille.tf.client.model.tools.MowzieModelRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;

@SideOnly(value=Side.CLIENT)
public class MowzieModelBase
extends ModelBiped {
    public float PI = (float)Math.PI;
    protected List<MowzieModelRenderer> parts;

    public ModelRenderer func_85181_a(Random rand) {
        if (this.parts.size() > 0) {
            return this.parts.get(rand.nextInt(this.parts.size()));
        }
        return super.func_85181_a(rand);
    }

    protected void setInitPose() {
        for (MowzieModelRenderer part : this.parts) {
            part.setInitValuesToCurrentPose();
        }
    }

    public void setToInitPose() {
        for (MowzieModelRenderer part : this.parts) {
            part.setCurrentPoseToInitValues();
        }
    }

    protected void addChildTo(ModelRenderer child, ModelRenderer parent) {
        float distance = (float)Math.sqrt(Math.pow(child.field_78798_e - parent.field_78798_e, 2.0) + Math.pow(child.field_78797_d - parent.field_78797_d, 2.0));
        float oldRotateAngleX = parent.field_78795_f;
        float parentToChildAngle = (float)Math.atan((child.field_78798_e - parent.field_78798_e) / (child.field_78797_d - parent.field_78797_d));
        float childRelativeRotation = parentToChildAngle - parent.field_78795_f;
        float newRotationPointY = (float)((double)distance * Math.cos(childRelativeRotation));
        float newRotationPointZ = (float)((double)distance * Math.sin(childRelativeRotation));
        parent.field_78795_f = 0.0f;
        child.func_78793_a(child.field_78800_c - parent.field_78800_c, newRotationPointY, newRotationPointZ);
        parent.func_78792_a(child);
        parent.field_78795_f = oldRotateAngleX;
        child.field_78795_f -= parent.field_78795_f;
        child.field_78796_g -= parent.field_78796_g;
        child.field_78808_h -= parent.field_78808_h;
    }

    protected void newAddChildTo(ModelRenderer child, ModelRenderer parent) {
        Math.sqrt(Math.pow(child.field_78798_e - parent.field_78798_e, 2.0) + Math.pow(child.field_78797_d - parent.field_78797_d, 2.0));
        Math.atan2(child.field_78797_d - parent.field_78797_d, child.field_78798_e - parent.field_78798_e);
        parent.func_78792_a(child);
        child.field_78795_f -= parent.field_78795_f;
        child.field_78796_g -= parent.field_78796_g;
        child.field_78808_h -= parent.field_78808_h;
    }

    public void faceTarget(MowzieModelRenderer box, float f, float f3, float f4) {
        box.field_78796_g += f3 / (180.0f / this.PI) / f;
        box.field_78795_f += f4 / (180.0f / this.PI) / f;
    }

    public float rotateBox(float speed, float degree, boolean invert, float offset, float weight, float f, float f1) {
        if (invert) {
            return -MathHelper.func_76134_b((float)(f * speed + offset)) * degree * f1 + weight * f1;
        }
        return MathHelper.func_76134_b((float)(f * speed + offset)) * degree * f1 + weight * f1;
    }

    public float moveBox(float speed, float degree, boolean bounce, float f, float f1) {
        if (bounce) {
            return -MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)(f * speed)) * f1 * degree));
        }
        return MathHelper.func_76126_a((float)(f * speed)) * f1 * degree - f1 * degree;
    }

    public void walk(MowzieModelRenderer box, float speed, float degree, boolean invert, float offset, float weight, float f, float f1) {
        int inverted = 1;
        if (invert) {
            inverted = -1;
        }
        box.field_78795_f += MathHelper.func_76134_b((float)(f * speed + offset)) * degree * (float)inverted * f1 + weight * f1;
    }

    public void flap(MowzieModelRenderer box, float speed, float degree, boolean invert, float offset, float weight, float f, float f1) {
        int inverted = 1;
        if (invert) {
            inverted = -1;
        }
        box.field_78808_h += MathHelper.func_76134_b((float)(f * speed + offset)) * degree * (float)inverted * f1 + weight * f1;
    }

    public void swing(MowzieModelRenderer box, float speed, float degree, boolean invert, float offset, float weight, float f, float f1) {
        int inverted = 1;
        if (invert) {
            inverted = -1;
        }
        box.field_78796_g += MathHelper.func_76134_b((float)(f * speed + offset)) * degree * (float)inverted * f1 + weight * f1;
    }

    public void bob(MowzieModelRenderer box, float speed, float degree, boolean bounce, float f, float f1) {
        float bob = (float)(Math.sin(f * speed) * (double)f1 * (double)degree - (double)(f1 * degree));
        if (bounce) {
            bob = (float)(-Math.abs(Math.sin(f * speed) * (double)f1 * (double)degree));
        }
        box.field_78797_d += bob;
    }

    public void chainSwing(MowzieModelRenderer[] boxes, float speed, float degree, double rootOffset, float f, float f1) {
        int numberOfSegments = boxes.length;
        float offset = (float)(rootOffset * Math.PI / (double)(2 * numberOfSegments));
        for (int i = 0; i < numberOfSegments; ++i) {
            boxes[i].field_78796_g += MathHelper.func_76134_b((float)(f * speed + offset * (float)i)) * f1 * degree;
        }
    }

    public void chainWave(MowzieModelRenderer[] boxes, float speed, float degree, double rootOffset, float f, float f1) {
        int numberOfSegments = boxes.length;
        float offset = (float)(rootOffset * Math.PI / (double)(2 * numberOfSegments));
        for (int i = 0; i < numberOfSegments; ++i) {
            boxes[i].field_78795_f += MathHelper.func_76134_b((float)(f * speed + offset * (float)i)) * f1 * degree;
        }
    }

    public void chainFlap(MowzieModelRenderer[] boxes, float speed, float degree, double rootOffset, float f, float f1) {
        int numberOfSegments = boxes.length;
        float offset = (float)(rootOffset * Math.PI / (double)(2 * numberOfSegments));
        for (int i = 0; i < numberOfSegments; ++i) {
            boxes[i].field_78808_h += MathHelper.func_76134_b((float)(f * speed + offset * (float)i)) * f1 * degree;
        }
    }

    public boolean onGround(Entity entity) {
        boolean onGround = entity.field_70122_E;
        if (entity != Minecraft.func_71410_x().field_71439_g) {
            double moveY;
            double actualMoveY = moveY = -0.2;
            entity.field_70139_V *= 0.4f;
            List collidingEntities = entity.field_70170_p.func_72945_a(entity, entity.field_70121_D.func_72321_a(0.0, moveY, 0.0));
            for (Object collidingEntity : collidingEntities) {
                moveY = ((AxisAlignedBB)collidingEntity).func_72323_b(entity.field_70121_D, moveY);
            }
            onGround = actualMoveY != moveY && actualMoveY < 0.0;
        }
        return onGround || this.field_78093_q;
    }

    protected void rotateTo(ModelRenderer rotating, ModelRenderer to, float f) {
        float rotXDif = to.field_78795_f - rotating.field_78795_f;
        float rotYDif = to.field_78796_g - rotating.field_78796_g;
        float rotZDif = to.field_78808_h - rotating.field_78808_h;
        float posXDif = to.field_78800_c - rotating.field_78800_c;
        float posYDif = to.field_78797_d - rotating.field_78797_d;
        float posZDif = to.field_78798_e - rotating.field_78798_e;
        float offsetXDif = to.field_82906_o - rotating.field_82906_o;
        float offsetYDif = to.field_82908_p - rotating.field_82908_p;
        float offsetZDif = to.field_82907_q - rotating.field_82907_q;
        rotating.field_78795_f += rotXDif * f;
        rotating.field_78796_g += rotYDif * f;
        rotating.field_78808_h += rotZDif * f;
        rotating.field_82906_o += offsetXDif * f;
        rotating.field_82908_p += offsetYDif * f;
        rotating.field_82907_q += offsetZDif * f;
        rotating.field_78800_c += posXDif * f;
        rotating.field_78797_d += posYDif * f;
        rotating.field_78798_e += posZDif * f;
    }

    public void addPart(MowzieModelRenderer mowzieModelRenderer) {
        if (this.parts == null) {
            this.parts = new ArrayList<MowzieModelRenderer>();
        }
        this.parts.add(mowzieModelRenderer);
    }

    public void setRotateAngle(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    public MowzieModelBase setBreaking(boolean breaking) {
        for (MowzieModelRenderer part : this.parts) {
            if (!(part instanceof ModelRendererBreakable)) continue;
            ((ModelRendererBreakable)part).breaking = breaking;
        }
        return this;
    }
}

