/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.client.gui;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fiskfille.tf.client.gui.GuiVerticalHeightSlider;
import fiskfille.tf.common.energon.power.IEnergyReceiver;
import fiskfille.tf.common.energon.power.IEnergyTransmitter;
import fiskfille.tf.common.energon.power.ReceiverEntry;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.common.network.MessageConnectReceiver;
import fiskfille.tf.common.network.base.TFNetworkManager;
import fiskfille.tf.helper.TFEnergyHelper;
import fiskfille.tf.helper.TFRenderHelper;
import fiskfille.tf.helper.TFVectorHelper;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiSelectReceivers
extends GuiScreen {
    public TileEntity owner;
    public IEnergyTransmitter transmitter;
    public ItemCSD.DimensionalCoords[] coordArray;
    public List<Integer> layers = Lists.newArrayList();
    public GuiVerticalHeightSlider heightSlider;
    public int spacing = 1;
    public int size = 3;

    public GuiSelectReceivers(TileEntity tile) {
        this.owner = tile;
        this.transmitter = (IEnergyTransmitter)this.owner;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        float range = this.transmitter.getRange();
        float boardWidth = 1.0f + range * 2.0f;
        int boardWidthFl = MathHelper.func_76141_d((float)boardWidth);
        int baseX = MathHelper.func_76128_c((double)((float)(this.field_146294_l / 2) - (float)(this.spacing + this.size) * boardWidth / 2.0f));
        int baseY = MathHelper.func_76128_c((double)((float)(this.field_146295_m / 2) - (float)(this.spacing + this.size) * boardWidth / 2.0f));
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 100, this.field_146295_m - this.field_146295_m / 7, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.heightSlider = new GuiVerticalHeightSlider(1, this, baseX + boardWidthFl * (this.spacing + this.size), baseY - 1, boardWidthFl * (this.spacing + this.size) + 1, new Runnable(){

            @Override
            public void run() {
                GuiSelectReceivers.this.updateBlocks();
            }
        });
        this.field_146292_n.add(this.heightSlider);
        this.coordArray = new ItemCSD.DimensionalCoords[boardWidthFl * boardWidthFl];
        this.layers.clear();
        this.layers.add(this.owner.field_145848_d);
        List tiles = this.field_146297_k.field_71441_e.field_147482_g;
        for (TileEntity loadedTile : tiles) {
            if (!(loadedTile instanceof IEnergyReceiver) || !((IEnergyReceiver)loadedTile).canReceiveEnergy(this.owner) || !TFEnergyHelper.isInRange(this.owner, loadedTile) || this.layers.contains(loadedTile.field_145848_d)) continue;
            this.layers.add(loadedTile.field_145848_d);
        }
        Collections.sort(this.layers);
        this.heightSlider.field_146124_l = this.layers.size() > 1;
        this.updateBlocks();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateBlocks();
    }

    protected void updateBlocks() {
        ItemCSD.DimensionalCoords coords;
        float range = this.transmitter.getRange();
        float boardWidth = 1.0f + range * 2.0f;
        int boardWidthFl = MathHelper.func_76141_d((float)boardWidth);
        int dimension = this.owner.func_145831_w().field_73011_w.field_76574_g;
        this.coordArray = new ItemCSD.DimensionalCoords[boardWidthFl * boardWidthFl];
        for (int i = 0; i < boardWidthFl; ++i) {
            for (int j = 0; j < boardWidthFl; ++j) {
                int x = MathHelper.func_76128_c((double)(this.owner.field_145851_c - boardWidthFl / 2 + i));
                int z = MathHelper.func_76128_c((double)(this.owner.field_145849_e - boardWidthFl / 2 + j));
                coords = new ItemCSD.DimensionalCoords(x, this.getLayer(), z, dimension);
                if (!TFEnergyHelper.isInRange(this.owner, coords)) continue;
                this.coordArray[i + j * boardWidthFl] = coords;
            }
        }
        int direction = MathHelper.func_76128_c((double)((double)(this.field_146297_k.field_71439_g.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
        if (direction > 0) {
            ItemCSD.DimensionalCoords[] coordArray1 = (ItemCSD.DimensionalCoords[])this.coordArray.clone();
            for (int i = 0; i < boardWidthFl; ++i) {
                for (int j = 0; j < boardWidthFl; ++j) {
                    coords = this.coordArray[i + j * boardWidthFl];
                    if (direction == 1) {
                        coords = this.coordArray[boardWidthFl - 1 - j + i * boardWidthFl];
                    } else if (direction == 2) {
                        coords = this.coordArray[boardWidthFl - 1 - i + (boardWidthFl - 1 - j) * boardWidthFl];
                    } else if (direction == 3) {
                        coords = this.coordArray[j + (boardWidthFl - 1 - i) * boardWidthFl];
                    }
                    coordArray1[i + j * boardWidthFl] = coords;
                }
            }
            this.coordArray = coordArray1;
        }
    }

    protected void func_146284_a(GuiButton button) {
        int id = button.field_146127_k;
        if (id == 0) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    protected void func_73869_a(char c, int key) {
        if (key == 1 || key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void func_146281_b() {
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        super.func_73864_a(mouseX, mouseY, button);
        if (button == 0) {
            int boardWidth = 1 + this.getRange() * 2;
            int baseX = MathHelper.func_76128_c((double)(this.field_146294_l / 2 - (this.spacing + this.size) * boardWidth / 2));
            int baseY = MathHelper.func_76128_c((double)(this.field_146295_m / 2 - (this.spacing + this.size) * boardWidth / 2));
            if (this.coordArray != null) {
                for (int i = 0; i < boardWidth; ++i) {
                    for (int j = 0; j < boardWidth; ++j) {
                        TileEntity tile;
                        ItemCSD.DimensionalCoords coords;
                        int x = baseX + (this.spacing + this.size) * i;
                        int y = baseY + (this.spacing + this.size) * j;
                        if (!new Rectangle(x, y, this.size, this.size).contains(mouseX, mouseY) || (coords = this.coordArray[i + j * boardWidth]) == null || coords.equals((Object)new ItemCSD.DimensionalCoords(this.owner)) || !((tile = this.field_146297_k.field_71441_e.func_147438_o(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c)) instanceof IEnergyReceiver) || !((IEnergyReceiver)tile).canReceiveEnergy(this.owner) || tile instanceof IEnergyTransmitter && TFEnergyHelper.getDescendants((IEnergyTransmitter)tile).contains((Object)new ItemCSD.DimensionalCoords(this.owner))) continue;
                        TFNetworkManager.networkWrapper.sendToServer((IMessage)new MessageConnectReceiver(new ItemCSD.DimensionalCoords(this.owner), coords));
                        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                    }
                }
            }
        }
    }

    public int getLayer() {
        float f = 1.0f - this.heightSlider.percentage;
        int amount = this.layers.size() - 1;
        for (int i = 0; i < this.layers.size(); ++i) {
            if (!(f >= ((float)i - 0.5f) / (float)amount) || !(f < ((float)i + 0.5f) / (float)amount)) continue;
            return this.layers.get(i);
        }
        return this.owner.field_145848_d;
    }

    public int getRange() {
        return MathHelper.func_76141_d((float)this.transmitter.getRange());
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.transmitter.select_receivers", (Object[])new Object[0]), this.field_146294_l / 2, 15, 0xFFFFFF);
        if (this.coordArray == null || this.layers.isEmpty()) {
            this.updateBlocks();
        }
        int boardWidth = 1 + this.getRange() * 2;
        int baseX = MathHelper.func_76128_c((double)(this.field_146294_l / 2 - (this.spacing + this.size) * boardWidth / 2));
        int baseY = MathHelper.func_76128_c((double)(this.field_146295_m / 2 - (this.spacing + this.size) * boardWidth / 2));
        if (this.coordArray != null) {
            int j;
            int i;
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.003921569f);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)0.1f, (float)0.1f, (float)0.1f, (float)1.0f);
            this.func_73729_b(baseX - this.spacing, baseY - this.spacing, 0, 0, MathHelper.func_76141_d((float)((this.spacing + this.size) * boardWidth)) + this.spacing, MathHelper.func_76141_d((float)((this.spacing + this.size) * boardWidth)) + this.spacing);
            Vec3 src = Vec3.func_72443_a((double)((float)(this.size * this.getRange()) - 0.5f), (double)((float)(this.size * this.getRange()) - 0.5f), (double)0.0);
            int maxWidth = 0;
            for (i = 0; i < boardWidth; ++i) {
                for (j = 0; j < boardWidth; ++j) {
                    ItemCSD.DimensionalCoords coords = this.coordArray[i + j * boardWidth];
                    if (coords == null) continue;
                    Vec3 src1 = Vec3.func_72443_a((double)((float)this.owner.field_145851_c + 0.5f), (double)0.0, (double)((float)this.owner.field_145849_e + 0.5f));
                    Vec3 dst = Vec3.func_72443_a((double)((float)coords.field_71574_a + 0.5f), (double)0.0, (double)((float)coords.field_71573_c + 0.5f));
                    maxWidth = Math.max(maxWidth, MathHelper.func_76128_c((double)src1.func_72438_d(dst)));
                }
            }
            maxWidth = 1 + maxWidth * 2;
            for (i = 0; i < boardWidth; ++i) {
                for (j = 0; j < boardWidth; ++j) {
                    Vec3 dst = Vec3.func_72443_a((double)(this.size * i), (double)(this.size * j), (double)0.0);
                    float opacity = MathHelper.func_76131_a((float)((1.0f - (float)src.func_72438_d(dst) / (float)maxWidth * 2.0f / (float)this.size) * 2.5f), (float)0.0f, (float)1.0f);
                    int x = baseX + (this.spacing + this.size) * i;
                    int y = baseY + (this.spacing + this.size) * j;
                    GL11.glColor4f((float)0.075f, (float)0.075f, (float)0.075f, (float)1.0f);
                    this.func_73729_b(x, y, 0, 0, this.size, this.size);
                    ItemCSD.DimensionalCoords coords = this.coordArray[i + j * boardWidth];
                    if (coords == null || this.field_146297_k.field_71441_e.func_147437_c(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c)) continue;
                    float[] afloat = TFRenderHelper.hexToRGB(0x707070);
                    GL11.glColor4f((float)afloat[0], (float)afloat[1], (float)afloat[2], (float)opacity);
                    this.func_73729_b(x, y, 0, 0, this.size, this.size);
                }
            }
            HashSet<ItemCSD.DimensionalCoords> receiverCoords = new HashSet<ItemCSD.DimensionalCoords>();
            for (ReceiverEntry entry : this.transmitter.getTransmissionHandler().getReceivers()) {
                receiverCoords.add(entry.getCoords());
            }
            Tessellator tessellator = Tessellator.field_78398_a;
            float prevWidth = GL11.glGetFloat((int)2849);
            GL11.glLineWidth((float)this.size);
            GL11.glColor4f((float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ArrayList coordList = Lists.newArrayList((Object[])this.coordArray);
            float f = 0.5f;
            float angle = 35.0f;
            float length = 4.0f;
            for (int i2 = 0; i2 < boardWidth; ++i2) {
                for (int j2 = 0; j2 < boardWidth; ++j2) {
                    TileEntity tile;
                    ItemCSD.DimensionalCoords coords = this.coordArray[i2 + j2 * boardWidth];
                    int x = baseX + (this.spacing + this.size) * i2;
                    int y = baseY + (this.spacing + this.size) * j2;
                    if (coords == null || !((tile = this.field_146297_k.field_71441_e.func_147438_o(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c)) instanceof IEnergyTransmitter) || tile == this.owner) continue;
                    IEnergyTransmitter transmitter1 = (IEnergyTransmitter)tile;
                    int color = 65535;
                    if (tile instanceof IEnergyReceiver) {
                        color = ((IEnergyReceiver)tile).getMapColor();
                    }
                    for (ReceiverEntry entry : transmitter1.getTransmissionHandler().getReceivers()) {
                        int index = coordList.indexOf((Object)entry.getCoords());
                        if (index < 0 || entry.getCoords().field_71572_b != this.getLayer()) continue;
                        int k = index;
                        int l = 0;
                        l = 0;
                        while (k >= boardWidth) {
                            k -= boardWidth;
                            ++l;
                        }
                        Vec3 vec3 = Vec3.func_72443_a((double)((float)x + (float)this.size / 2.0f), (double)((float)y + (float)this.size / 2.0f), (double)0.0);
                        Vec3 vec31 = Vec3.func_72443_a((double)((float)(baseX + (this.spacing + this.size) * k) + (float)this.size / 2.0f), (double)((float)(baseY + (this.spacing + this.size) * l) + (float)this.size / 2.0f), (double)0.0);
                        Vec3 vec32 = vec31.func_72444_a(vec3);
                        Vec3 vec33 = vec31.func_72444_a(vec3);
                        Vec3 vec34 = vec31.func_72444_a(vec3);
                        vec33.field_72450_a *= (double)f;
                        vec33.field_72448_b *= (double)f;
                        vec33 = TFVectorHelper.add(vec33, vec31);
                        vec32.func_72446_c((float)Math.toRadians(angle));
                        vec34.func_72446_c((float)Math.toRadians(-angle));
                        vec32 = vec32.func_72432_b();
                        vec34 = vec34.func_72432_b();
                        vec32.field_72450_a *= (double)length;
                        vec32.field_72448_b *= (double)length;
                        vec34.field_72450_a *= (double)length;
                        vec34.field_72448_b *= (double)length;
                        vec32 = TFVectorHelper.add(vec32, vec33);
                        vec34 = TFVectorHelper.add(vec34, vec33);
                        tessellator.func_78371_b(3);
                        tessellator.func_78384_a(65535, 50);
                        tessellator.func_78377_a(vec3.field_72450_a, vec3.field_72448_b, 0.0);
                        tessellator.func_78377_a(vec31.field_72450_a, vec31.field_72448_b, 0.0);
                        tessellator.func_78381_a();
                        tessellator.func_78371_b(4);
                        tessellator.func_78384_a(color, 150);
                        tessellator.func_78377_a(vec32.field_72450_a, vec32.field_72448_b, 0.0);
                        tessellator.func_78377_a(vec33.field_72450_a, vec33.field_72448_b, 0.0);
                        tessellator.func_78377_a(vec34.field_72450_a, vec34.field_72448_b, 0.0);
                        tessellator.func_78381_a();
                    }
                }
            }
            for (ItemCSD.DimensionalCoords coords : receiverCoords) {
                int index = coordList.indexOf((Object)coords);
                if (index < 0 || coords.field_71572_b != this.getLayer()) continue;
                int k = index;
                int l = 0;
                l = 0;
                while (k >= boardWidth) {
                    k -= boardWidth;
                    ++l;
                }
                Vec3 vec3 = Vec3.func_72443_a((double)((float)(baseX + (this.spacing + this.size) * boardWidth / 2) - 0.5f), (double)((float)(baseY + (this.spacing + this.size) * boardWidth / 2) - 0.5f), (double)0.0);
                Vec3 vec31 = Vec3.func_72443_a((double)((float)(baseX + (this.spacing + this.size) * k) + (float)this.size / 2.0f), (double)((float)(baseY + (this.spacing + this.size) * l) + (float)this.size / 2.0f), (double)0.0);
                Vec3 vec32 = vec31.func_72444_a(vec3);
                Vec3 vec33 = vec31.func_72444_a(vec3);
                Vec3 vec34 = vec31.func_72444_a(vec3);
                vec33.field_72450_a *= (double)f;
                vec33.field_72448_b *= (double)f;
                vec33 = TFVectorHelper.add(vec33, vec31);
                vec32.func_72446_c((float)Math.toRadians(angle));
                vec34.func_72446_c((float)Math.toRadians(-angle));
                vec32 = vec32.func_72432_b();
                vec34 = vec34.func_72432_b();
                vec32.field_72450_a *= (double)length;
                vec32.field_72448_b *= (double)length;
                vec34.field_72450_a *= (double)length;
                vec34.field_72448_b *= (double)length;
                vec32 = TFVectorHelper.add(vec32, vec33);
                vec34 = TFVectorHelper.add(vec34, vec33);
                tessellator.func_78371_b(3);
                tessellator.func_78384_a(65535, 200);
                tessellator.func_78377_a(vec3.field_72450_a, vec3.field_72448_b, 0.0);
                tessellator.func_78377_a(vec31.field_72450_a, vec31.field_72448_b, 0.0);
                tessellator.func_78381_a();
                tessellator.func_78371_b(4);
                tessellator.func_78384_a(65535, 150);
                tessellator.func_78377_a(vec32.field_72450_a, vec32.field_72448_b, 0.0);
                tessellator.func_78377_a(vec33.field_72450_a, vec33.field_72448_b, 0.0);
                tessellator.func_78377_a(vec34.field_72450_a, vec34.field_72448_b, 0.0);
                tessellator.func_78381_a();
            }
            for (int i3 = 0; i3 < boardWidth; ++i3) {
                for (int j3 = 0; j3 < boardWidth; ++j3) {
                    Vec3 dst = Vec3.func_72443_a((double)(this.size * i3), (double)(this.size * j3), (double)0.0);
                    float opacity = MathHelper.func_76131_a((float)((1.0f - (float)src.func_72438_d(dst) / (float)boardWidth * 2.0f / (float)this.size) * 2.5f), (float)0.0f, (float)1.0f);
                    int x = baseX + (this.spacing + this.size) * i3;
                    int y = baseY + (this.spacing + this.size) * j3;
                    ItemCSD.DimensionalCoords coords = this.coordArray[i3 + j3 * boardWidth];
                    if (coords == null) continue;
                    TileEntity tile = this.field_146297_k.field_71441_e.func_147438_o(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
                    if (receiverCoords.contains((Object)coords) && this.spacing > 0) {
                        GL11.glColor4f((float)0.0f, (float)1.0f, (float)1.0f, (float)opacity);
                        this.func_73729_b(x - this.spacing, y - this.spacing, 0, 0, this.size + this.spacing * 2, this.size + this.spacing * 2);
                    }
                    if (tile == this.owner) {
                        GL11.glColor4f((float)0.0f, (float)0.6f, (float)0.0f, (float)opacity);
                    } else if (tile instanceof IEnergyReceiver && ((IEnergyReceiver)tile).canReceiveEnergy(this.owner)) {
                        float[] afloat = TFRenderHelper.hexToRGB(((IEnergyReceiver)tile).getMapColor());
                        if (tile instanceof IEnergyTransmitter && TFEnergyHelper.isPowering((IEnergyTransmitter)tile, this.owner)) {
                            int k = 0;
                            while (k < afloat.length) {
                                int n = k++;
                                afloat[n] = afloat[n] * 0.3f;
                            }
                        }
                        GL11.glColor4f((float)afloat[0], (float)afloat[1], (float)afloat[2], (float)opacity);
                    } else {
                        if (!(tile instanceof IEnergyTransmitter) || !TFEnergyHelper.getDescendants((IEnergyTransmitter)tile).contains((Object)new ItemCSD.DimensionalCoords(this.owner))) continue;
                        GL11.glColor4f((float)0.2f, (float)0.0f, (float)0.2f, (float)opacity);
                    }
                    this.func_73729_b(x, y, 0, 0, this.size, this.size);
                }
            }
            GL11.glLineWidth((float)prevWidth);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3553);
        }
        if (this.layers.size() > 1) {
            for (int i = 0; i < this.layers.size(); i += this.layers.size() - 1) {
                float f = (float)i / (float)(this.layers.size() - 1);
                this.func_73731_b(this.field_146297_k.field_71466_p, this.layers.get(i) + "", this.heightSlider.field_146128_h + this.heightSlider.field_146120_f + 3, this.heightSlider.field_146129_i + (int)((1.0f - f) * (float)(this.heightSlider.field_146121_g - 8)), 0x4C4C4C);
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int direction = MathHelper.func_76128_c((double)((double)(this.field_146297_k.field_71439_g.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
        String[] dirs = new String[]{"north", "east", "south", "west"};
        String[] astring = new String[dirs.length];
        for (int i = 0; i < dirs.length; ++i) {
            astring[i] = I18n.func_135052_a((String)("direction." + dirs[(i + direction) % dirs.length] + ".short"), (Object[])new Object[0]);
        }
        this.func_73732_a(this.field_146289_q, astring[0], baseX + (this.spacing + this.size) * boardWidth / 2, baseY - this.field_146289_q.field_78288_b / 2, -1);
        this.func_73732_a(this.field_146289_q, astring[1], baseX + (this.spacing + this.size) * boardWidth, baseY + (this.spacing + this.size) * boardWidth / 2 - this.field_146289_q.field_78288_b / 2, -1);
        this.func_73732_a(this.field_146289_q, astring[2], baseX + (this.spacing + this.size) * boardWidth / 2, baseY + (this.spacing + this.size) * boardWidth - this.field_146289_q.field_78288_b / 2, -1);
        this.func_73732_a(this.field_146289_q, astring[3], baseX, baseY + (this.spacing + this.size) * boardWidth / 2 - this.field_146289_q.field_78288_b / 2, -1);
    }
}

