/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.client.gui;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.IGuiHandler;
import fiskfille.tf.TFLog;
import fiskfille.tf.TransformersMod;
import fiskfille.tf.common.block.TFBlocks;
import fiskfille.tf.common.container.ContainerAlloyCrucible;
import fiskfille.tf.common.container.ContainerAssemblyTable;
import fiskfille.tf.common.container.ContainerColumn;
import fiskfille.tf.common.container.ContainerDisplayStation;
import fiskfille.tf.common.container.ContainerDisplayStationArmor;
import fiskfille.tf.common.container.ContainerEmpty;
import fiskfille.tf.common.container.ContainerEnergonProcessor;
import fiskfille.tf.common.container.ContainerEnergonTank;
import fiskfille.tf.common.container.ContainerGroundBridge;
import fiskfille.tf.common.container.ContainerTransmitter;
import fiskfille.tf.common.container.InventoryGroundBridge;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.common.item.TFItems;
import fiskfille.tf.common.tileentity.TileEntityAlloyCrucible;
import fiskfille.tf.common.tileentity.TileEntityAssemblyTable;
import fiskfille.tf.common.tileentity.TileEntityColumn;
import fiskfille.tf.common.tileentity.TileEntityDisplayStation;
import fiskfille.tf.common.tileentity.TileEntityEnergonProcessor;
import fiskfille.tf.common.tileentity.TileEntityEnergonTank;
import fiskfille.tf.common.tileentity.TileEntityIsoCondenser;
import fiskfille.tf.common.tileentity.TileEntityTransmitter;
import java.lang.reflect.Constructor;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GuiHandlerTF
implements IGuiHandler {
    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        int dimension;
        TFGui tfGui;
        if ((tfGui = TFGui.get(id ^= (dimension = id >> 8) << 8)) != null) {
            if (tfGui.containerClass == null) {
                return null;
            }
            ItemCSD.DimensionalCoords coords = new ItemCSD.DimensionalCoords(x, y, z, dimension);
            if (tfGui == TFGui.GROUND_BRIDGE_REMOTE || tfGui.containerBlock == null || world.func_147439_a(x, y, z) == tfGui.containerBlock) {
                int[] aint = coords.toArray();
                int integer = 0;
                try {
                    Constructor c = tfGui.containerClass.getConstructor(tfGui.containerArgs);
                    Object[] args = new Object[tfGui.containerArgs.length];
                    for (int i = 0; i < tfGui.containerArgs.length; ++i) {
                        Class clazz = tfGui.containerArgs[i];
                        if (InventoryPlayer.class.isAssignableFrom(clazz)) {
                            args[i] = player.field_71071_by;
                            continue;
                        }
                        if (TileEntity.class.isAssignableFrom(clazz)) {
                            args[i] = clazz.cast(world.func_147438_o(x, y, z));
                            continue;
                        }
                        if (ItemCSD.DimensionalCoords.class.isAssignableFrom(clazz)) {
                            args[i] = coords;
                            continue;
                        }
                        if (InventoryGroundBridge.class.isAssignableFrom(clazz)) {
                            ItemStack itemstack = player.func_70694_bm();
                            if (itemstack == null || itemstack.func_77973_b() != TFItems.groundBridgeRemote) {
                                return null;
                            }
                            args[i] = new InventoryGroundBridge(player, itemstack);
                            continue;
                        }
                        if (World.class.isAssignableFrom(clazz)) {
                            args[i] = world;
                            continue;
                        }
                        if (!Integer.TYPE.isAssignableFrom(clazz)) continue;
                        args[i] = integer < aint.length ? Integer.valueOf(aint[integer]) : Integer.valueOf(0);
                        ++integer;
                    }
                    return c.newInstance(args);
                }
                catch (Exception e) {
                    TFLog.error("Unable to load class for gui element %s", tfGui);
                    e.printStackTrace();
                    return null;
                }
            }
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        int dimension;
        TFGui tfGui;
        if ((tfGui = TFGui.get(id ^= (dimension = id >> 8) << 8)) != null) {
            if (tfGui.guiPath == null) {
                return null;
            }
            ItemCSD.DimensionalCoords coords = new ItemCSD.DimensionalCoords(x, y, z, dimension);
            if (tfGui == TFGui.GROUND_BRIDGE_REMOTE || tfGui.containerBlock == null || world.func_147439_a(x, y, z) == tfGui.containerBlock) {
                int[] aint = coords.toArray();
                int integer = 0;
                try {
                    Constructor<?> c = Class.forName(tfGui.guiPath).getConstructor(tfGui.guiArgs);
                    Object[] args = new Object[tfGui.guiArgs.length];
                    for (int i = 0; i < tfGui.guiArgs.length; ++i) {
                        Class clazz = tfGui.guiArgs[i];
                        if (InventoryPlayer.class.isAssignableFrom(clazz)) {
                            args[i] = player.field_71071_by;
                            continue;
                        }
                        if (TileEntity.class.isAssignableFrom(clazz)) {
                            args[i] = clazz.cast(world.func_147438_o(x, y, z));
                            continue;
                        }
                        if (ItemCSD.DimensionalCoords.class.isAssignableFrom(clazz)) {
                            args[i] = coords;
                            continue;
                        }
                        if (InventoryGroundBridge.class.isAssignableFrom(clazz)) {
                            ItemStack itemstack = player.func_70694_bm();
                            if (itemstack == null || itemstack.func_77973_b() != TFItems.groundBridgeRemote) {
                                return null;
                            }
                            args[i] = new InventoryGroundBridge(player, itemstack);
                            continue;
                        }
                        if (World.class.isAssignableFrom(clazz)) {
                            args[i] = world;
                            continue;
                        }
                        if (!Integer.TYPE.isAssignableFrom(clazz)) continue;
                        args[i] = integer < aint.length ? Integer.valueOf(aint[integer]) : Integer.valueOf(0);
                        ++integer;
                    }
                    return c.newInstance(args);
                }
                catch (Exception e) {
                    TFLog.error("Unable to load class for gui element '%s'", tfGui);
                    e.printStackTrace();
                    return null;
                }
            }
        }
        return null;
    }

    public static class TFGui {
        private static final List<TFGui> guis = Lists.newArrayList();
        private static int nextId = -1;
        public static TFGui ALLOY_CRUCIBLE;
        public static TFGui ASSEMBLY_TABLE;
        public static TFGui DISPLAY_STATION;
        public static TFGui DISPLAY_STATION_ARMOR;
        public static TFGui DISPLAY_STATION_COLOR;
        public static TFGui ENERGON_PROCESSOR;
        public static TFGui ENERGON_TANK;
        public static TFGui ENERGON_TRANSMITTER;
        public static TFGui ENERGY_COLUMN;
        public static TFGui GROUND_BRIDGE_REMOTE;
        public static TFGui ISOTOPIC_CONDENSER;
        public static TFGui RECEIVER_NETWORK;
        public final int guiId;
        private final Block containerBlock;
        private final Class containerClass;
        private final Class[] containerArgs;
        private final String guiPath;
        private final Class[] guiArgs;

        public TFGui(Block block, Class<? extends Container> clazz, String path, Class ... gui) {
            this(block, clazz, path, gui, gui);
        }

        public TFGui(Block block, Class<? extends Container> clazz, String path, Class[] gui, Class[] container) {
            this(++nextId, block, clazz, path, gui, container);
        }

        public TFGui(int id, Block block, Class<? extends Container> clazz, String path, Class ... gui) {
            this(id, block, clazz, path, gui, gui);
        }

        public TFGui(int id, Block block, Class<? extends Container> clazz, String path, Class[] gui, Class[] container) {
            this.guiId = id;
            this.guiPath = path;
            this.guiArgs = gui;
            this.containerClass = clazz;
            this.containerArgs = container;
            this.containerBlock = block;
            guis.add(this);
        }

        public static void register() {
            ALLOY_CRUCIBLE = new TFGui(TFBlocks.alloyCrucible, ContainerAlloyCrucible.class, "fiskfille.tf.client.gui.GuiAlloyCrucible", InventoryPlayer.class, TileEntityAlloyCrucible.class);
            ASSEMBLY_TABLE = new TFGui(TFBlocks.assemblyTable, ContainerAssemblyTable.class, "fiskfille.tf.client.gui.GuiAssemblyTable", InventoryPlayer.class, TileEntityAssemblyTable.class);
            DISPLAY_STATION = new TFGui(TFBlocks.displayStation, ContainerDisplayStation.class, "fiskfille.tf.client.gui.GuiDisplayStation", InventoryPlayer.class, TileEntityDisplayStation.class);
            DISPLAY_STATION_ARMOR = new TFGui(TFBlocks.displayStation, ContainerDisplayStationArmor.class, "fiskfille.tf.client.gui.GuiDisplayStationArmor", InventoryPlayer.class, TileEntityDisplayStation.class);
            DISPLAY_STATION_COLOR = new TFGui(TFBlocks.displayStation, null, "fiskfille.tf.client.gui.GuiColor", TileEntityDisplayStation.class);
            ENERGON_PROCESSOR = new TFGui(TFBlocks.energonProcessor, ContainerEnergonProcessor.class, "fiskfille.tf.client.gui.GuiEnergonProcessor", InventoryPlayer.class, TileEntityEnergonProcessor.class);
            ENERGON_TANK = new TFGui(TFBlocks.energonFluidTank, ContainerEnergonTank.class, "fiskfille.tf.client.gui.GuiEnergonTank", InventoryPlayer.class, TileEntityEnergonTank.class);
            ENERGON_TRANSMITTER = new TFGui(TFBlocks.transmitter, ContainerTransmitter.class, "fiskfille.tf.client.gui.GuiTransmitter", InventoryPlayer.class, TileEntityTransmitter.class);
            ENERGY_COLUMN = new TFGui(TFBlocks.energyColumn, ContainerColumn.class, "fiskfille.tf.client.gui.GuiColumn", InventoryPlayer.class, TileEntityColumn.class);
            GROUND_BRIDGE_REMOTE = new TFGui(TFBlocks.groundBridgeControlPanel, (Class<? extends Container>)ContainerGroundBridge.class, "fiskfille.tf.client.gui.GuiGroundBridge", new Class[]{InventoryPlayer.class, InventoryGroundBridge.class, ItemCSD.DimensionalCoords.class}, new Class[]{InventoryPlayer.class, InventoryGroundBridge.class});
            ISOTOPIC_CONDENSER = new TFGui(TFBlocks.isoCondenser, (Class<? extends Container>)ContainerEmpty.class, "fiskfille.tf.client.gui.GuiIsoCondenser", new Class[]{InventoryPlayer.class, TileEntityIsoCondenser.class}, new Class[]{InventoryPlayer.class});
            RECEIVER_NETWORK = new TFGui(null, null, "fiskfille.tf.client.gui.GuiSelectReceivers", TileEntity.class);
        }

        public void open(EntityPlayer player, TileEntity tile) {
            this.open(player, player.field_70170_p, tile);
        }

        public void open(EntityPlayer player, World world, TileEntity tile) {
            this.open(player, world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        }

        public void open(EntityPlayer player, int x, int y, int z) {
            this.open(player, player.field_70170_p, x, y, z);
        }

        public void open(EntityPlayer player, World world, int x, int y, int z) {
            player.openGui((Object)TransformersMod.instance, this.guiId, world, x, y, z);
        }

        public static TFGui get(int id) {
            for (TFGui gui : guis) {
                if (gui.guiId != id) continue;
                return gui;
            }
            return null;
        }

        public String toString() {
            return String.format("TFGui{id=%s, path=%s}", this.guiId, this.guiPath);
        }
    }
}

