/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.client.gui;

import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fiskfille.tf.client.gui.GuiButtonFlat;
import fiskfille.tf.client.gui.GuiContainerTF;
import fiskfille.tf.client.gui.GuiHoverFieldEnergy;
import fiskfille.tf.client.gui.GuiTextFieldFlat;
import fiskfille.tf.common.container.ContainerGroundBridge;
import fiskfille.tf.common.container.InventoryGroundBridge;
import fiskfille.tf.common.data.tile.TileData;
import fiskfille.tf.common.data.tile.TileDataControlPanel;
import fiskfille.tf.common.groundbridge.DataCore;
import fiskfille.tf.common.groundbridge.GroundBridgeError;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.common.item.TFItems;
import fiskfille.tf.common.network.MessageControlPanelSetConfig;
import fiskfille.tf.common.network.MessageTileTrigger;
import fiskfille.tf.common.network.base.TFNetworkManager;
import fiskfille.tf.helper.TFDimensionHelper;
import fiskfille.tf.helper.TFRenderHelper;
import fiskfille.tf.helper.TFTileHelper;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems")
public class GuiGroundBridge
extends GuiContainerTF
implements INEIGuiHandler {
    private static final ResourceLocation guiTextures = new ResourceLocation("transformers", "textures/gui/container/ground_bridge.png");
    public InventoryGroundBridge inventory;
    public GuiTextField[] coordinateFields = new GuiTextField[3];
    public GuiTextField dimensionField;
    public GuiButton buttonDeactivate;
    public GuiButton buttonActivate;
    public GuiButton buttonDimRight;
    public GuiButton buttonDimLeft;
    public GuiButton buttonDirection;
    private GuiHoverFieldEnergy fieldEnergy;
    public ItemCSD.DimensionalCoords tileCoords;
    public TileDataControlPanel data;

    public GuiGroundBridge(InventoryPlayer inventoryPlayer, InventoryGroundBridge inventoryGroundBridge, ItemCSD.DimensionalCoords coords) {
        super(new ContainerGroundBridge(inventoryPlayer, inventoryGroundBridge));
        this.inventory = inventoryGroundBridge;
        this.tileCoords = coords;
        this.data = (TileDataControlPanel)TFTileHelper.getTileData(coords);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.data == null) {
            return;
        }
        this.fieldEnergy = new GuiHoverFieldEnergy(x + this.field_146999_f + 2, y + 2, 16, 86, this.data.storage);
        this.field_146292_n.add(this.fieldEnergy);
        this.buttonDeactivate = new GuiButtonFlat(0, x + 37, y + 66, 64, I18n.func_135052_a((String)"ground_bridge_remote.ui.deactivate", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonDeactivate);
        this.buttonActivate = new GuiButtonFlat(1, x + 105, y + 66, 64, I18n.func_135052_a((String)"ground_bridge_remote.ui.activate", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonActivate);
        this.buttonDimLeft = new GuiButtonFlat(2, x + 37, y + 49, 13, "<");
        this.field_146292_n.add(this.buttonDimLeft);
        this.buttonDimRight = new GuiButtonFlat(3, x + 64, y + 49, 13, ">");
        this.field_146292_n.add(this.buttonDimRight);
        this.buttonDirection = new GuiButtonFlat(4, x + 156, y + 49, 13, "");
        this.field_146292_n.add(this.buttonDirection);
        Keyboard.enableRepeatEvents((boolean)true);
        int[] destination = this.data.destination.toArray();
        for (int i = 0; i < this.coordinateFields.length; ++i) {
            this.coordinateFields[i] = new GuiTextFieldFlat(this.field_146289_q, x + 7 + 55 * i, y + 7, 52);
            this.coordinateFields[i].func_146203_f(20);
            this.coordinateFields[i].func_146180_a(destination[i] + "");
        }
        this.dimensionField = new GuiTextFieldFlat(this.field_146289_q, x + 81, y + 49, 71);
        this.updateButtons();
    }

    public void func_73876_c() {
        ItemCSD.DimensionalCoords coords;
        super.func_73876_c();
        TileData newData = TFTileHelper.getTileData(this.tileCoords);
        if (!(newData instanceof TileDataControlPanel)) {
            this.field_146297_k.field_71439_g.func_71053_j();
            return;
        }
        this.data = (TileDataControlPanel)newData;
        int[] newDestination = this.data.destination.toArray();
        for (int i = 0; i < this.coordinateFields.length; ++i) {
            this.coordinateFields[i].func_146178_a();
            try {
                newDestination[i] = Integer.valueOf(this.coordinateFields[i].func_146179_b());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.inventory.func_70301_a(0) != null) {
            int[] originalDestination = this.data.destination.toArray();
            for (int i = 0; i < this.coordinateFields.length; ++i) {
                this.coordinateFields[i].func_146180_a(originalDestination[i] + "");
            }
        } else if (!this.data.activationLeverState && !this.data.destination.equals((Object)(coords = ItemCSD.DimensionalCoords.fromArray(newDestination)))) {
            coords.set(newDestination[0], newDestination[1], newDestination[2], newDestination[3]);
            this.data.destination.set(coords);
            for (int i = 0; i < this.coordinateFields.length; ++i) {
                this.coordinateFields[i].func_146180_a(newDestination[i] + "");
            }
            TFNetworkManager.networkWrapper.sendToServer((IMessage)new MessageControlPanelSetConfig(this.data.getCoords(), coords));
        }
        this.fieldEnergy.update(this.data.storage);
        this.updateButtons();
    }

    public void updateButtons() {
        boolean activationLeverState = this.data.activationLeverState;
        boolean canEditCoords = this.data != null && !activationLeverState && this.inventory.func_70301_a(0) == null;
        for (GuiTextField coordinateField : this.coordinateFields) {
            coordinateField.func_146184_c(canEditCoords);
        }
        this.buttonActivate.field_146124_l = this.data != null && !activationLeverState && this.data.errors.isEmpty();
        this.buttonDeactivate.field_146124_l = this.data != null && activationLeverState;
        this.buttonDimRight.field_146124_l = canEditCoords && this.data.hasUpgrade(DataCore.spaceBridge);
        this.buttonDimLeft.field_146124_l = this.buttonDimRight.field_146124_l;
        this.buttonDirection.field_146124_l = this.data != null && !activationLeverState;
        this.dimensionField.func_146184_c(canEditCoords && this.data.hasUpgrade(DataCore.spaceBridge));
        if (this.data != null) {
            String[] directions = new String[]{"north", "east", "south", "west"};
            this.buttonDirection.field_146126_j = I18n.func_135052_a((String)("direction." + directions[this.data.direction % directions.length] + ".short"), (Object[])new Object[0]);
            this.dimensionField.func_146180_a(TFDimensionHelper.getDimensionName(this.data.destination.dimension));
            this.dimensionField.func_146196_d();
        }
    }

    protected void func_146284_a(GuiButton button) {
        int id = button.field_146127_k;
        if (id == 0 || id == 1) {
            TFNetworkManager.networkWrapper.sendToServer((IMessage)new MessageTileTrigger(this.tileCoords, (EntityPlayer)this.field_146297_k.field_71439_g, 14));
        } else if (id == 2 || id == 3) {
            TFNetworkManager.networkWrapper.sendToServer((IMessage)new MessageTileTrigger(this.tileCoords, (EntityPlayer)this.field_146297_k.field_71439_g, 16 + id));
        } else if (id == 4) {
            TFNetworkManager.networkWrapper.sendToServer((IMessage)new MessageTileTrigger(this.tileCoords, (EntityPlayer)this.field_146297_k.field_71439_g, 13));
        }
        this.updateButtons();
    }

    protected void func_73869_a(char c, int key) {
        super.func_73869_a(c, key);
        for (GuiTextField coordinateField : this.coordinateFields) {
            coordinateField.func_146201_a(c, key);
            String s = "";
            for (int k = 0; k < coordinateField.func_146179_b().length(); ++k) {
                char c1 = coordinateField.func_146179_b().charAt(k);
                if (!Character.isDigit(c1) && (k != 0 || c1 != '-')) continue;
                s = s + c1;
            }
            if (s.equals(coordinateField.func_146179_b())) continue;
            coordinateField.func_146180_a(s);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        super.func_73864_a(mouseX, mouseY, button);
        for (GuiTextField coordinateField : this.coordinateFields) {
            coordinateField.func_146192_a(mouseX, mouseY, button);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.data == null) {
            return;
        }
        String destDimension = String.valueOf(this.data.destination.dimension);
        this.field_146289_q.func_78276_b(destDimension, (this.buttonDimLeft.field_146128_h + this.buttonDimRight.field_146128_h + this.buttonDimRight.field_146120_f - this.field_146289_q.func_78256_a(destDimension)) / 2 - x, (this.buttonDimLeft.field_146129_i + this.buttonDimLeft.field_146121_g / 2 + this.buttonDimRight.field_146129_i + this.buttonDimRight.field_146121_g / 2 - this.field_146289_q.field_78288_b + 1) / 2 + 1 - y, -1);
        if (this.data.hasUpgrade(DataCore.leveler)) {
            String modifiedY = "(-> " + this.data.modifiedDestY + ")";
            this.field_146289_q.func_78276_b(modifiedY, this.coordinateFields[1].field_146209_f + (this.coordinateFields[1].field_146218_h - this.field_146289_q.func_78256_a(modifiedY)) / 2 - x, this.coordinateFields[1].field_146210_g + this.coordinateFields[1].field_146219_i + this.field_146289_q.field_78288_b / 2 - y, 0x7F7F7F);
        }
        TFRenderHelper.setupRenderItemIntoGUI();
        for (int i = 0; i < this.data.upgrades.size(); ++i) {
            DataCore core = this.data.upgrades.get(i);
            if (core == null) continue;
            TFRenderHelper.renderItemIntoGUI(116 + i * 18, 28, new ItemStack(TFItems.dataCore, 1, core.index));
        }
        TFRenderHelper.finishRenderItemIntoGUI();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiTextures);
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(x + this.field_146999_f + 2, y + 2, 192, 0, 16, 86);
        float energy = this.data.getEnergy();
        if (energy > 0.0f) {
            float f = energy / this.data.getMaxEnergy();
            this.func_73729_b(x + this.field_146999_f + 6, y + 6 + Math.round(78.0f * (1.0f - f)), 208, Math.round(78.0f * (1.0f - f)), 8, Math.round(78.0f * f));
        }
        for (int i = 0; i < this.data.errors.size(); ++i) {
            boolean flag = new Rectangle(x + this.field_146999_f + 20, y + 10 + i * 17, 16, 16).contains(mouseX, mouseY);
            this.func_73729_b(x + this.field_146999_f + 20, y + 10 + i * 17, 176, flag ? 16 : 0, 16, 16);
        }
        for (GuiTextField coordinateField : this.coordinateFields) {
            coordinateField.func_146194_f();
        }
        this.dimensionField.func_146194_f();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int i;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        for (i = 0; i < this.data.upgrades.size(); ++i) {
            DataCore core = this.data.upgrades.get(i);
            if (core == null || !new Rectangle(x + 115 + i * 18, y + 27, 18, 18).contains(mouseX, mouseY)) continue;
            this.drawHoveringText(Arrays.asList(core.getTranslatedName()), mouseX, mouseY, this.field_146289_q);
        }
        for (i = 0; i < this.data.errors.size(); ++i) {
            GroundBridgeError.ErrorContainer container = this.data.errors.get(i);
            if (!new Rectangle(x + this.field_146999_f + 20, y + 10 + i * 17, 16, 16).contains(mouseX, mouseY)) continue;
            List list = this.field_146289_q.func_78271_c(container.translate(), 200);
            for (int j = 0; j < list.size(); ++j) {
                list.set(j, EnumChatFormatting.RED + (String)list.get(j));
            }
            this.drawHoveringText(list, mouseX, mouseY, this.field_146289_q);
        }
    }

    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        currentVisibility.showWidgets = this.field_146294_l - this.field_146999_f >= 107;
        if (this.field_147003_i < 58) {
            currentVisibility.showStateButtons = false;
        }
        return currentVisibility;
    }

    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return null;
    }

    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return Collections.emptyList();
    }

    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        return false;
    }

    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        Rectangle slot = new Rectangle(x, y, w, h);
        Rectangle bounds = new Rectangle(this.field_147003_i + this.field_146999_f, this.field_147009_r, 18, 88);
        slot.grow(4, 4);
        if (!this.data.errors.isEmpty()) {
            bounds.width += 18;
        }
        return slot.intersects(bounds);
    }
}

