/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.client.gui;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fiskfille.tf.client.gui.GuiButtonDistribution;
import fiskfille.tf.client.gui.GuiButtonIO;
import fiskfille.tf.client.gui.GuiContainerTF;
import fiskfille.tf.common.block.BlockMachineBase;
import fiskfille.tf.common.container.ContainerEmpty;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.common.network.MessageTileTrigger;
import fiskfille.tf.common.network.base.TFNetworkManager;
import fiskfille.tf.common.tick.ClientTickHandler;
import fiskfille.tf.common.tileentity.TileEntityMachine;
import fiskfille.tf.helper.TFHelper;
import fiskfille.tf.helper.TFRenderHelper;
import fiskfille.tf.helper.TFTextureHelper;
import fiskfille.tf.helper.TFTileHelper;
import java.util.List;
import javax.vecmath.Vector3d;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@SideOnly(value=Side.CLIENT)
public class GuiConfigSides
extends GuiContainerTF {
    private static final ResourceLocation guiTextures = new ResourceLocation("transformers", "textures/gui/container/configure.png");
    private TileEntityMachine machine;
    private GuiScreen parent;
    private GuiButton buttonDistribution;
    private RenderBlocks renderBlocks;
    private World world;
    private List<ChunkCoordinates> neighbors = Lists.newArrayList();
    private List<ChunkCoordinates> configurables = Lists.newArrayList();
    private Vector3d camera;
    private boolean renderNeighbours = true;

    public GuiConfigSides(InventoryPlayer inventoryPlayer, GuiScreen gui, TileEntityMachine tile) {
        super(new ContainerEmpty(inventoryPlayer, 16));
        this.machine = tile;
        this.parent = gui;
        this.field_147000_g = 182;
        this.world = tile.func_145831_w();
        this.renderBlocks = new RenderBlocks((IBlockAccess)this.world);
        this.camera = new Vector3d((double)((float)(-this.machine.field_145851_c) - 0.5f), (double)((float)(-this.machine.field_145848_d) - 0.5f), (double)((float)(-this.machine.field_145849_e) - 0.5f));
        this.configurables.add(new ItemCSD.DimensionalCoords(tile));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.buttonDistribution = new GuiButtonDistribution(0, x + 111, y + 66, this.machine);
        this.field_146292_n.add(this.buttonDistribution);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int index = dir.ordinal();
            this.field_146292_n.add(new GuiButtonIO(index + 1, x + 108 + index % 2 * 15, y + 18 + index / 2 * 15, this.machine, dir));
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof GuiButtonIO)) continue;
            GuiButtonIO iobutton = (GuiButtonIO)button;
            button.field_146124_l = iobutton.machine.canTransfer(iobutton.side);
        }
        this.neighbors.clear();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int z;
            int x = this.machine.field_145851_c + dir.offsetX;
            int y = this.machine.field_145848_d + dir.offsetY + (dir.offsetY > 0 ? this.machine.getBlockType().getBlockHeight() - 1 : 0);
            if (this.world.func_147437_c(x, y, z = this.machine.field_145849_e + dir.offsetZ)) continue;
            this.neighbors.add(new ChunkCoordinates(x, y, z));
        }
    }

    protected void func_146284_a(GuiButton button) {
        int id = button.field_146127_k;
        if (id == 0) {
            TFNetworkManager.networkWrapper.sendToServer((IMessage)new MessageTileTrigger(new ItemCSD.DimensionalCoords(this.machine), (EntityPlayer)this.field_146297_k.field_71439_g, -this.machine.io.length - 3));
        } else if (id > 0 && id <= ForgeDirection.VALID_DIRECTIONS.length) {
            TFNetworkManager.networkWrapper.sendToServer((IMessage)new MessageTileTrigger(new ItemCSD.DimensionalCoords(this.machine), (EntityPlayer)this.field_146297_k.field_71439_g, -id));
        }
    }

    protected void func_73869_a(char c, int key) {
        if (key == 1 || key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.func_147108_a(this.parent);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        String s = I18n.func_135052_a((String)"gui.tf.io", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 94, 0x404040);
        float height = this.machine.getBlockType().getBlockHeight();
        float scale = 30.0f - (height - 1.0f) * 5.0f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)73.0f, (float)51.0f, (float)100.0f);
        GL11.glRotatef((float)(-TFHelper.median(this.field_146297_k.field_71439_g.field_70125_A, this.field_146297_k.field_71439_g.field_70127_C, ClientTickHandler.renderTick)), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)TFHelper.median(this.field_146297_k.field_71439_g.field_70177_z, this.field_146297_k.field_71439_g.field_70126_B, ClientTickHandler.renderTick), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)(-scale), (float)(-scale), (float)(-scale));
        GL11.glTranslatef((float)0.0f, (float)(0.5f - height / 2.0f), (float)0.0f);
        TFRenderHelper.startGlScissor(x + 41, y + 19, 64, 64);
        this.renderScene();
        TFRenderHelper.endGlScissor();
        GL11.glPopMatrix();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiTextures);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    private void renderScene() {
        int pass;
        Tessellator tessellator = Tessellator.field_78398_a;
        BlockMachineBase block = this.machine.getBlockType();
        int x = this.machine.field_145851_c;
        int y = this.machine.field_145848_d;
        int z = this.machine.field_145849_e;
        this.field_146297_k.field_71460_t.func_78483_a(0.0);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)32826);
        for (pass = 0; pass < 2; ++pass) {
            this.setGlStateForPass(pass, false);
            this.doTileEntityRenderPass(this.configurables, pass);
            if (!this.renderNeighbours) continue;
            this.setGlStateForPass(pass, true);
            this.doTileEntityRenderPass(this.neighbors, pass);
        }
        this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GL11.glDisable((int)2896);
        for (pass = 0; pass < 1; ++pass) {
            this.setGlStateForPass(pass, false);
            this.doWorldRenderPass(this.configurables, pass);
            if (!this.renderNeighbours) continue;
            this.setGlStateForPass(pass, true);
            this.doWorldRenderPass(this.neighbors, pass);
        }
        ForgeHooksClient.setRenderPass((int)-1);
        this.setGlStateForPass(0, false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2929);
        tessellator.func_78373_b((double)((float)(-x) - 0.5f), (double)((float)(-y) - 0.5f), (double)((float)(-z) - 0.5f));
        this.renderBlocks.func_147753_b(true);
        block2: for (GuiButton button : this.field_146292_n) {
            GuiButtonIO iobutton;
            if (!(button instanceof GuiButtonIO) || !(iobutton = (GuiButtonIO)button).func_146115_a()) continue;
            ForgeDirection dir = iobutton.side;
            IIcon icon = this.renderBlocks.func_147745_b(Blocks.field_150325_L);
            if (iobutton.field_146124_l) {
                GL11.glColor4f((float)0.2f, (float)1.0f, (float)0.2f, (float)0.5f);
            } else {
                GL11.glColor4f((float)1.0f, (float)0.2f, (float)0.2f, (float)0.5f);
            }
            block.func_149719_a((IBlockAccess)this.world, x, y, z);
            this.renderBlocks.func_147775_a((Block)block);
            for (int i = 0; i < 2; ++i) {
                if (i == 1) {
                    TileEntityMachine.EnumIO io = this.machine.getInOutMode(dir);
                    if (io.ordinal() == 0) continue block2;
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                    icon = TFTextureHelper.ioIcons[io.ordinal()];
                }
                tessellator.func_78382_b();
                this.renderFace(dir, block, x, y + (i == 1 && dir.offsetY > 0 ? block.getBlockHeight() - 1 : 0), z, icon);
                tessellator.func_78381_a();
            }
        }
        tessellator.func_78373_b(0.0, 0.0, 0.0);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3042);
    }

    private void renderFace(ForgeDirection dir, Block block, int x, int y, int z, IIcon icon) {
        switch (dir) {
            case DOWN: {
                this.renderBlocks.func_147768_a(block, (double)x, (double)y, (double)z, icon);
                break;
            }
            case UP: {
                this.renderBlocks.func_147806_b(block, (double)x, (double)y, (double)z, icon);
                break;
            }
            case NORTH: {
                this.renderBlocks.func_147761_c(block, (double)x, (double)y, (double)z, icon);
                break;
            }
            case SOUTH: {
                this.renderBlocks.func_147734_d(block, (double)x, (double)y, (double)z, icon);
                break;
            }
            case EAST: {
                this.renderBlocks.func_147764_f(block, (double)x, (double)y, (double)z, icon);
                break;
            }
            case WEST: {
                this.renderBlocks.func_147798_e(block, (double)x, (double)y, (double)z, icon);
                break;
            }
        }
    }

    private void doTileEntityRenderPass(List<ChunkCoordinates> blocks, int pass) {
        ForgeHooksClient.setRenderPass((int)pass);
        for (ChunkCoordinates coords : blocks) {
            TileEntity tile = TFTileHelper.getTileBase(this.world.func_147438_o(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c));
            if (tile == null) continue;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TileEntityRendererDispatcher.field_147556_a.func_147549_a(tile, (double)tile.field_145851_c + this.camera.x, (double)tile.field_145848_d + this.camera.y, (double)tile.field_145849_e + this.camera.z, 0.0f);
        }
    }

    private void doWorldRenderPass(List<ChunkCoordinates> blocks, int pass) {
        ForgeHooksClient.setRenderPass((int)pass);
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78373_b(this.camera.x, this.camera.y, this.camera.z);
        Tessellator.field_78398_a.func_78380_c(0xF000F0);
        for (ChunkCoordinates coords : blocks) {
            Block block = this.world.func_147439_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
            if (block == null || !block.canRenderInPass(pass)) continue;
            this.renderBlocks.field_147837_f = true;
            this.renderBlocks.func_147753_b(true);
            this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            this.renderBlocks.func_147805_b(block, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
        }
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78373_b(0.0, 0.0, 0.0);
    }

    private void setGlStateForPass(int pass, boolean isNeighbour) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (isNeighbour) {
            float alpha = 0.6f;
            if (pass == 0) {
                GL11.glEnable((int)2929);
                GL11.glEnable((int)3042);
                GL11.glEnable((int)2884);
                GL11.glBlendFunc((int)32771, (int)32769);
                GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GL11.glDepthMask((boolean)true);
            } else {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)32769);
                GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
                GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GL11.glDepthMask((boolean)false);
            }
            return;
        }
        if (pass == 0) {
            GL11.glEnable((int)2929);
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
        } else {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDepthMask((boolean)false);
        }
    }
}

