/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.asm.transformers;

import fiskfille.tf.TFLog;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class ClassTransformerBase
implements IClassTransformer,
Opcodes {
    protected final String classPath;
    protected final String unobfClass;

    public ClassTransformerBase(String classPath) {
        this.classPath = classPath;
        this.unobfClass = classPath.substring(classPath.lastIndexOf(46) + 1);
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        try {
            if (transformedName.equals(this.classPath)) {
                TFLog.info("Patching Class %s (%s)", this.unobfClass, name);
                ClassReader cr = new ClassReader(bytes);
                ClassNode cn = new ClassNode();
                cr.accept((ClassVisitor)cn, 0);
                this.setupMappings();
                boolean success = this.processFields(cn.fields) && this.processMethods(cn.methods);
                this.addInterface(cn.interfaces);
                ClassWriter cw = new ClassWriter(1);
                cn.accept((ClassVisitor)cw);
                if (success) {
                    TFLog.info("Patching Class %s done", this.unobfClass);
                } else {
                    TFLog.error("Patching Class %s FAILED!", this.unobfClass);
                }
                ClassTransformerBase.writeClassFile(cw, this.unobfClass + " (" + name + ")");
                return cw.toByteArray();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes;
    }

    public void addInterface(List<String> interfaces) {
    }

    public abstract boolean processMethods(List<MethodNode> var1);

    public abstract boolean processFields(List<FieldNode> var1);

    public abstract void setupMappings();

    public void sendPatchLog(String method) {
        TFLog.info("\tPatching method %s in %s", method, this.unobfClass);
    }

    public static void writeClassFile(ClassWriter cw, String name) {
        try {
            File outDir = new File("debug/");
            outDir.mkdirs();
            DataOutputStream dout = new DataOutputStream(new FileOutputStream(new File(outDir, name + ".class")));
            dout.write(cw.toByteArray());
            dout.flush();
            dout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static MethodNode generateSetter(String className, String methodName, String fieldName, String fieldType) {
        MethodNode mn = new MethodNode(1, methodName, "(" + fieldType + ")V", null, null);
        mn.visitCode();
        mn.visitVarInsn(25, 0);
        int opCode = fieldType.equals("I") || fieldType.equals("Z") ? 21 : (fieldType.equals("L") ? 22 : (fieldType.equals("F") ? 23 : (fieldType.equals("D") ? 24 : 25)));
        mn.visitVarInsn(opCode, 1);
        mn.visitFieldInsn(181, className, fieldName, fieldType);
        mn.visitInsn(177);
        mn.visitMaxs(2, 2);
        mn.visitEnd();
        return mn;
    }

    public static MethodNode generateGetter(String className, String methodName, String fieldName, String fieldType) {
        MethodNode mn = new MethodNode(1, methodName, "()" + fieldType, null, null);
        mn.visitCode();
        mn.visitVarInsn(25, 0);
        mn.visitFieldInsn(180, className, fieldName, fieldType);
        int opCode = fieldType.equals("I") || fieldType.equals("Z") ? 172 : (fieldType.equals("L") ? 173 : (fieldType.equals("F") ? 174 : (fieldType.equals("D") ? 175 : 176)));
        mn.visitInsn(opCode);
        mn.visitMaxs(1, 1);
        mn.visitEnd();
        return mn;
    }
}

