/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import fiskfille.tf.client.displayable.Displayable;
import fiskfille.tf.common.energon.Energon;
import fiskfille.tf.common.transformer.base.Transformer;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;

public class TransformersAPI {
    private static List<Transformer> transformers = Lists.newArrayList();
    private static List<Energon> energonTypes = Lists.newArrayList();
    private static Map<Item, Displayable> displayables = Maps.newHashMap();
    private static List<Item> displayablesServer = Lists.newArrayList();

    public static void registerTransformer(Transformer transformer) {
        if (!transformers.contains(transformer)) {
            transformers.add(transformer);
        } else {
            System.err.println("[TransformersAPI] " + transformer.getName() + " has already been registered!");
        }
    }

    public static List<Transformer> getTransformers() {
        return transformers;
    }

    public static Transformer getTransformerByName(String name) {
        for (Transformer transformer : transformers) {
            if (!transformer.getName().equals(name)) continue;
            return transformer;
        }
        return null;
    }

    public static void registerEnergonType(Energon energon) {
        if (!energonTypes.contains(energon)) {
            energonTypes.add(energon);
        } else {
            System.err.println("[TransformersAPI] A mod is trying to register an energon type twice!");
        }
    }

    public static List<Energon> getEnergonTypes() {
        return energonTypes;
    }

    public static Energon getEnergonTypeByName(String name) {
        for (Energon energon : energonTypes) {
            if (!energon.getId().equals(name)) continue;
            return energon;
        }
        return null;
    }

    public static void registerDisplayable(Item item, Class<? extends Displayable> displayableClass) {
        Side side = FMLCommonHandler.instance().getSide();
        if (side == Side.CLIENT) {
            try {
                Displayable displayable = displayableClass.newInstance();
                displayables.put(item, displayable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            displayablesServer.add(item);
        }
    }

    public static Map<Item, Displayable> getDisplayables() {
        return displayables;
    }

    public static Displayable getDisplayableFor(Item item) {
        for (Map.Entry<Item, Displayable> e : displayables.entrySet()) {
            if (e.getKey() != item) continue;
            return e.getValue();
        }
        return null;
    }

    public static boolean hasDisplayable(Item item) {
        Side side = FMLCommonHandler.instance().getSide();
        if (side == Side.CLIENT) {
            return TransformersAPI.getDisplayableFor(item) != null;
        }
        return displayablesServer.contains(item);
    }
}

