/*
 * Decompiled with CFR 0.152.
 */
package ckathode.archimedes;

import ckathode.archimedes.ArchimedesConfig;
import ckathode.archimedes.CommonProxy;
import ckathode.archimedes.blockitem.BlockAS;
import ckathode.archimedes.blockitem.BlockCrate;
import ckathode.archimedes.blockitem.BlockEngine;
import ckathode.archimedes.blockitem.BlockGauge;
import ckathode.archimedes.blockitem.BlockHelm;
import ckathode.archimedes.blockitem.BlockSeat;
import ckathode.archimedes.blockitem.ItemGaugeBlock;
import ckathode.archimedes.blockitem.TileEntityCrate;
import ckathode.archimedes.blockitem.TileEntityEngine;
import ckathode.archimedes.blockitem.TileEntityGauge;
import ckathode.archimedes.blockitem.TileEntityHelm;
import ckathode.archimedes.command.CommandASHelp;
import ckathode.archimedes.command.CommandDisassembleNear;
import ckathode.archimedes.command.CommandDisassembleShip;
import ckathode.archimedes.command.CommandShipInfo;
import ckathode.archimedes.entity.EntityEntityAttachment;
import ckathode.archimedes.entity.EntityParachute;
import ckathode.archimedes.entity.EntitySeat;
import ckathode.archimedes.entity.EntityShip;
import ckathode.archimedes.mrot.MetaRotations;
import ckathode.archimedes.network.ASMessagePipeline;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemCloth;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Logger;

@Mod(modid="ArchimedesShips", name="Archimedes' Ships", version="1.7.10 v1.7.1")
public class ArchimedesShipMod {
    public static final String MOD_ID = "ArchimedesShips";
    public static final String MOD_VERSION = "1.7.10 v1.7.1";
    public static final String MOD_NAME = "Archimedes' Ships";
    @Mod.Instance(value="ArchimedesShips")
    public static ArchimedesShipMod instance;
    @SidedProxy(clientSide="ckathode.archimedes.ClientProxy", serverSide="ckathode.archimedes.CommonProxy")
    public static CommonProxy proxy;
    public static Logger modLog;
    public static BlockHelm blockMarkShip;
    public static Block blockFloater;
    public static Block blockBalloon;
    public static BlockGauge blockGauge;
    public static BlockSeat blockSeat;
    public static Block blockBuffer;
    public static Block blockEngine;
    public static Block blockCrateWood;
    public static Material materialFloater;
    public ArchimedesConfig modConfig;
    public ASMessagePipeline pipeline = new ASMessagePipeline();
    public MetaRotations metaRotations = new MetaRotations();

    @Mod.EventHandler
    public void preInitMod(FMLPreInitializationEvent event) {
        modLog = event.getModLog();
        this.modConfig = new ArchimedesConfig(new Configuration(event.getSuggestedConfigurationFile()));
        this.modConfig.loadAndSave();
        this.metaRotations.setConfigDirectory(event.getModConfigurationDirectory());
        this.pipeline.initalize();
        this.createBlocksAndItems();
        this.modConfig.postLoad();
    }

    private void createBlocksAndItems() {
        materialFloater = new Material(MapColor.field_151659_e);
        blockMarkShip = (BlockHelm)new BlockHelm().func_149647_a(CreativeTabs.field_78029_e);
        blockMarkShip.func_149672_a(Block.field_149766_f).func_149711_c(1.0f).func_149752_b(1.0f);
        this.registerBlock("marker", (Block)blockMarkShip);
        blockFloater = new BlockAS(materialFloater).func_149647_a(CreativeTabs.field_78029_e);
        blockFloater.func_149672_a(Block.field_149766_f).func_149711_c(1.0f).func_149752_b(1.0f);
        this.registerBlock("floater", blockFloater);
        blockBalloon = new BlockColored(Material.field_151580_n).func_149647_a(CreativeTabs.field_78029_e);
        blockBalloon.func_149672_a(Block.field_149775_l).func_149711_c(0.35f).func_149752_b(1.0f);
        this.registerBlock("balloon", blockBalloon, ItemCloth.class);
        blockGauge = (BlockGauge)new BlockGauge().func_149647_a(CreativeTabs.field_78029_e);
        blockGauge.func_149672_a(Block.field_149777_j).func_149711_c(1.0f).func_149752_b(1.0f);
        this.registerBlock("gauge", (Block)blockGauge, ItemGaugeBlock.class);
        blockSeat = (BlockSeat)new BlockSeat().func_149711_c(1.0f).func_149752_b(1.0f).func_149647_a(CreativeTabs.field_78029_e);
        blockSeat.func_149672_a(Block.field_149775_l);
        this.registerBlock("seat", blockSeat);
        blockBuffer = new BlockAS(Material.field_151580_n).func_149711_c(1.0f).func_149752_b(1.0f).func_149647_a(CreativeTabs.field_78029_e);
        blockBuffer.func_149672_a(Block.field_149766_f);
        this.registerBlock("buffer", blockBuffer);
        blockEngine = new BlockEngine(Material.field_151573_f, 1.0f, 10).func_149711_c(2.0f).func_149752_b(3.0f).func_149647_a(CreativeTabs.field_78029_e);
        blockEngine.func_149672_a(Block.field_149777_j);
        this.registerBlock("engine", blockEngine);
        blockCrateWood = new BlockCrate(Material.field_151575_d).func_149711_c(1.0f).func_149752_b(1.0f).func_149647_a(CreativeTabs.field_78029_e);
        blockCrateWood.func_149672_a(Block.field_149766_f);
        this.registerBlock("crate_wood", blockCrateWood);
    }

    private void registerBlocksAndItems() {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockMarkShip, 1), (Object[])new Object[]{"X#X", "#O#", "X#X", Character.valueOf('X'), Blocks.field_150344_f, Character.valueOf('#'), Items.field_151055_y, Character.valueOf('O'), Items.field_151042_j});
        GameRegistry.registerTileEntity(TileEntityHelm.class, (String)"archiHelm");
        Blocks.field_150480_ab.setFireInfo((Block)blockMarkShip, 5, 5);
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(blockFloater, 1), (Object[])new Object[]{Blocks.field_150364_r, Blocks.field_150325_L});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(blockFloater, 1), (Object[])new Object[]{Blocks.field_150363_s, Blocks.field_150325_L});
        for (int i = 0; i < ItemDye.field_150923_a.length; ++i) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(blockBalloon, 1, i), (Object[])new Object[]{"X", "#", Character.valueOf('X'), new ItemStack(Blocks.field_150325_L, 1, i), Character.valueOf('#'), Items.field_151007_F});
        }
        Blocks.field_150480_ab.setFireInfo(blockBalloon, 30, 60);
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockGauge, 1, 0), (Object[])new Object[]{"VXV", "XO#", " # ", Character.valueOf('X'), Items.field_151042_j, Character.valueOf('#'), Items.field_151043_k, Character.valueOf('O'), Items.field_151137_ax, Character.valueOf('V'), Blocks.field_150410_aZ});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockGauge, 1, 0), (Object[])new Object[]{"VXV", "XO#", " # ", Character.valueOf('X'), Items.field_151043_k, Character.valueOf('#'), Items.field_151042_j, Character.valueOf('O'), Items.field_151137_ax, Character.valueOf('V'), Blocks.field_150410_aZ});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockGauge, 1, 1), (Object[])new Object[]{"VXV", "XO#", "V#V", Character.valueOf('X'), Items.field_151042_j, Character.valueOf('#'), Items.field_151043_k, Character.valueOf('O'), Items.field_151137_ax, Character.valueOf('V'), Blocks.field_150410_aZ});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockGauge, 1, 1), (Object[])new Object[]{"VXV", "XO#", "V#V", Character.valueOf('X'), Items.field_151043_k, Character.valueOf('#'), Items.field_151042_j, Character.valueOf('O'), Items.field_151137_ax, Character.valueOf('V'), Blocks.field_150410_aZ});
        GameRegistry.registerTileEntity(TileEntityGauge.class, (String)"archiGauge");
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockSeat), (Object[])new Object[]{"X ", "XX", Character.valueOf('X'), Blocks.field_150325_L});
        Blocks.field_150480_ab.setFireInfo((Block)blockSeat, 30, 30);
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(blockBuffer), (Object[])new Object[]{blockFloater, new ItemStack(Items.field_151100_aR, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockCrateWood, 3), (Object[])new Object[]{" # ", "# #", "XXX", Character.valueOf('#'), Items.field_151116_aA, Character.valueOf('X'), Blocks.field_150344_f});
        GameRegistry.registerTileEntity(TileEntityCrate.class, (String)"archiCrate");
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockEngine, 1), (Object[])new Object[]{"#O#", "#X#", "###", Character.valueOf('#'), Items.field_151042_j, Character.valueOf('O'), Items.field_151131_as, Character.valueOf('X'), Blocks.field_150460_al});
        GameRegistry.registerTileEntity(TileEntityEngine.class, (String)"archiEngine");
    }

    @Mod.EventHandler
    public void initMod(FMLInitializationEvent event) {
        this.registerBlocksAndItems();
        EntityRegistry.registerModEntity(EntityShip.class, (String)"shipmod", (int)1, (Object)this, (int)64, (int)this.modConfig.shipEntitySyncRate, (boolean)true);
        EntityRegistry.registerModEntity(EntityEntityAttachment.class, (String)"attachment", (int)2, (Object)this, (int)64, (int)100, (boolean)false);
        EntityRegistry.registerModEntity(EntitySeat.class, (String)"attachment.seat", (int)3, (Object)this, (int)64, (int)100, (boolean)false);
        EntityRegistry.registerModEntity(EntityParachute.class, (String)"parachute", (int)4, (Object)this, (int)32, (int)this.modConfig.shipEntitySyncRate, (boolean)true);
        proxy.registerKeyHandlers(this.modConfig);
        proxy.registerEventHandlers();
        proxy.registerRenderers();
        proxy.registerPackets(this.pipeline);
    }

    @Mod.EventHandler
    public void postInitMod(FMLPostInitializationEvent event) {
        this.metaRotations.readMetaRotationFiles();
        this.pipeline.postInitialize();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        this.registerASCommand(event, new CommandASHelp());
        this.registerASCommand(event, new CommandDisassembleShip());
        this.registerASCommand(event, new CommandShipInfo());
        this.registerASCommand(event, new CommandDisassembleNear());
        Collections.sort(CommandASHelp.asCommands);
    }

    private void registerASCommand(FMLServerStartingEvent event, CommandBase commandbase) {
        event.registerServerCommand((ICommand)commandbase);
        CommandASHelp.asCommands.add(commandbase);
    }

    private void registerBlock(String id, Block block) {
        this.registerBlock(id, block, ItemBlock.class);
    }

    private void registerBlock(String id, Block block, Class<? extends ItemBlock> itemblockclass) {
        block.func_149663_c("archimedes." + id);
        block.func_149658_d("archimedes:" + id);
        GameRegistry.registerBlock((Block)block, itemblockclass, (String)id);
    }
}

