/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.ai.improvements;

import com.builtbroken.ai.improvements.FastTrig;
import com.builtbroken.ai.improvements.FixedEntityLookHelper;
import java.io.File;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLModDisabledEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="aiimprovements", name="AI Improvements", version="0.0.1.20160401184835", acceptableRemoteVersions="*", canBeDeactivated=true, acceptedMinecraftVersions="[1.8.9]")
public class AIImprovements {
    public static Logger LOGGER;
    public static boolean REMOVE_LOOK_AI;
    public static boolean REMOVE_LOOK_IDLE;
    public static boolean REPLACE_LOOK_HELPER;

    @Mod.EventHandler
    public void disableEvent(FMLModDisabledEvent event) {
        LOGGER.info("Disabling mod");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(new File(event.getModConfigurationDirectory(), "bbm/AI_Improvements.cfg"));
        config.load();
        REMOVE_LOOK_AI = config.getBoolean("RemoveEntityAIWatchClosest", "general", REMOVE_LOOK_AI, "Disabled the AI segment that controls entities looking at the closest player");
        REMOVE_LOOK_IDLE = config.getBoolean("RemoveEntityAILookIdle", "general", REMOVE_LOOK_IDLE, "Disabled the AI segment that controls entities looking at random locations");
        REPLACE_LOOK_HELPER = config.getBoolean("ReplaceLookHelper", "general", REPLACE_LOOK_HELPER, "Replaces the EntityLookHelper with a more CPU efficient version");
        config.save();
        LOGGER = LogManager.getLogger((String)"AI_Improvements");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        FastTrig.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.entity;
        if (entity instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)entity;
            if (REMOVE_LOOK_AI || REMOVE_LOOK_IDLE) {
                Iterator it = living.field_70714_bg.field_75782_a.iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof EntityAITasks.EntityAITaskEntry)) continue;
                    EntityAITasks.EntityAITaskEntry task = (EntityAITasks.EntityAITaskEntry)obj;
                    if (REMOVE_LOOK_AI && task.field_75733_a instanceof EntityAIWatchClosest) {
                        it.remove();
                        continue;
                    }
                    if (!REMOVE_LOOK_IDLE || !(task.field_75733_a instanceof EntityAILookIdle)) continue;
                    it.remove();
                }
            }
            if (REPLACE_LOOK_HELPER && (living.func_70671_ap() == null || living.func_70671_ap().getClass() == EntityLookHelper.class)) {
                EntityLookHelper oldHelper = living.field_70749_g;
                living.field_70749_g = new FixedEntityLookHelper(living);
                living.field_70749_g.field_75656_e = oldHelper.field_75656_e;
                living.field_70749_g.field_75656_e = oldHelper.field_75656_e;
                living.field_70749_g.field_75656_e = oldHelper.field_75656_e;
                living.field_70749_g.field_75655_d = oldHelper.field_75655_d;
                living.field_70749_g.field_75658_c = oldHelper.field_75658_c;
                living.field_70749_g.field_75657_b = oldHelper.field_75657_b;
            }
        }
    }

    static {
        REMOVE_LOOK_AI = false;
        REMOVE_LOOK_IDLE = false;
        REPLACE_LOOK_HELPER = true;
    }
}

