/*
 * Decompiled with CFR 0.152.
 */
package tt.betterslabsmod.items;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import tt.betterslabsmod.blocks.BSMSlab;
import tt.betterslabsmod.capability.placementmode.IPlacementMode;
import tt.betterslabsmod.capability.placementmode.PlacementMode;
import tt.betterslabsmod.utils.Pair;

public class BSMItemBlock
extends ItemBlock {
    private IBlockState fullBlock;

    public BSMItemBlock(BSMSlab block, IBlockState fullBlock_) {
        super((Block)block);
        this.fullBlock = fullBlock_;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.add("ID: " + ((BSMSlab)this.field_150939_a).ID);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos position, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!player.func_184614_ca().func_190926_b() && player.field_71075_bZ.field_75099_e) {
            if (!world.field_72995_K) {
                Pair<BlockPos, IBlockState> pair = this.getDetails(world, position, player, hitX, hitY, hitZ, side);
                world.func_175656_a(pair.getFirstElement(), pair.getSecondElement());
                this.playSound(world, position, player);
                player.func_184614_ca().func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public Pair<BlockPos, IBlockState> getDetails(World world, BlockPos position, EntityPlayer player, float hitX, float hitY, float hitZ, EnumFacing side) {
        IBlockState blockLookedAt = world.func_180495_p(position);
        PlacementMode.EnumMode mode = ((IPlacementMode)player.getCapability(PlacementMode.CAPABILITY, null)).getCurrentPlacementMode();
        boolean isShiftDown = Keyboard.isKeyDown((int)42);
        if (mode == PlacementMode.EnumMode.NORMAL) {
            if (blockLookedAt.func_177230_c() == this.field_150939_a) {
                if (BSMSlab.SlabState.isNormal((BSMSlab.SlabState)((Object)blockLookedAt.func_177229_b(BSMSlab.SLAB_STATE))) && !isShiftDown) {
                    return new Pair<BlockPos, IBlockState>(position, this.fullBlock);
                }
                return new Pair<BlockPos, IBlockState>(position.func_177972_a(side), this.field_150939_a.func_176223_P().func_177226_a(BSMSlab.SLAB_STATE, blockLookedAt.func_177229_b(BSMSlab.SLAB_STATE)));
            }
            boolean isBottomHalf = hitY > 0.0f && (double)hitY < 0.5 || (double)hitY == 1.0;
            return new Pair<BlockPos, IBlockState>(position.func_177972_a(side), this.field_150939_a.func_176223_P().func_177226_a(BSMSlab.SLAB_STATE, (Comparable)((Object)(isShiftDown ? (isBottomHalf ? BSMSlab.SlabState.UP : BSMSlab.SlabState.DOWN) : (isBottomHalf ? BSMSlab.SlabState.DOWN : BSMSlab.SlabState.UP)))));
        }
        if (mode == PlacementMode.EnumMode.VERTICAL) {
            if (blockLookedAt.func_177230_c() == this.field_150939_a && BSMSlab.SlabState.isVertical((BSMSlab.SlabState)((Object)blockLookedAt.func_177229_b(BSMSlab.SLAB_STATE))) && ((BSMSlab.SlabState)((Object)blockLookedAt.func_177229_b(BSMSlab.SLAB_STATE))).isOppositeSide(side)) {
                return new Pair<BlockPos, IBlockState>(position, this.fullBlock);
            }
            int facing = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            return new Pair<BlockPos, IBlockState>(position.func_177972_a(side), this.field_150939_a.func_176223_P().func_177226_a(BSMSlab.SLAB_STATE, (Comparable)((Object)BSMSlab.SlabState.values()[isShiftDown ? facing : (facing + 2) % 4])));
        }
        if (mode == PlacementMode.EnumMode.FACED) {
            return new Pair<BlockPos, IBlockState>(position.func_177972_a(side), this.field_150939_a.func_176223_P().func_177226_a(BSMSlab.SLAB_STATE, (Comparable)((Object)BSMSlab.SlabState.getStateFromSide(side))));
        }
        if (mode == PlacementMode.EnumMode.SLOPE) {
            int facing = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            return new Pair<BlockPos, IBlockState>(position.func_177972_a(side), this.field_150939_a.func_176223_P().func_177226_a(BSMSlab.SLAB_STATE, (Comparable)((Object)BSMSlab.SlabState.values()[(isShiftDown ? facing : (facing + 2) % 4) + BSMSlab.SlabState.SLOPE_NORTH.getID()])));
        }
        if (mode == PlacementMode.EnumMode.AXIS) {
            return new Pair<BlockPos, IBlockState>(position.func_177972_a(side), this.field_150939_a.func_176223_P().func_177226_a(BSMSlab.SLAB_STATE, (Comparable)((Object)BSMSlab.SlabState.getAxisFromSide(side))));
        }
        if (mode == PlacementMode.EnumMode.ROTATIONAL) {
            int facing = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 8.0f / 360.0f) + 0.5)) & 7;
            BSMSlab.SlabState[] states = new BSMSlab.SlabState[]{BSMSlab.SlabState.Z_AXIS, BSMSlab.SlabState.DIAGONAL_RIGHT, BSMSlab.SlabState.X_AXIS, BSMSlab.SlabState.DIAGONAL_LEFT};
            return new Pair<BlockPos, IBlockState>(position.func_177972_a(side), this.field_150939_a.func_176223_P().func_177226_a(BSMSlab.SLAB_STATE, (Comparable)((Object)states[facing % 4])));
        }
        if (mode == PlacementMode.EnumMode.FILL) {
            if (blockLookedAt.func_177230_c() == this.field_150939_a) {
                return new Pair<BlockPos, IBlockState>(position, this.fullBlock);
            }
        } else if (mode == PlacementMode.EnumMode.RANDOM) {
            return new Pair<BlockPos, IBlockState>(position.func_177972_a(side), this.field_150939_a.func_176223_P().func_177226_a(BSMSlab.SLAB_STATE, (Comparable)((Object)BSMSlab.SlabState.values()[new Random().nextInt(BSMSlab.SlabState.values().length)])));
        }
        return new Pair<BlockPos, IBlockState>(position, this.fullBlock);
    }

    private void playSound(World world, BlockPos position, EntityPlayer player) {
        SoundType soundtype = world.func_180495_p(position).func_177230_c().getSoundType(world.func_180495_p(position), world, position, (Entity)player);
        world.func_184133_a(player, position, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
    }
}

