/*
 * Decompiled with CFR 0.152.
 */
package tt.betterslabsmod.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import tt.betterslabsmod.blocks.BSMSlab;
import tt.betterslabsmod.main.BSMBlocks;

public class BSMSlabGravity
extends BSMSlab {
    private ItemStack stackDropped;

    public BSMSlabGravity(int ID, String name, GravityVariant variant) {
        super(ID, name, variant.material, variant.hardness, variant.resistance, variant.fullBlock, variant.mapColor, variant.soundType);
        this.stackDropped = variant.stackDropped;
        this.func_149663_c(StringUtils.uncapitalize((String)(name + "_slab")));
        this.func_149675_a(true);
    }

    public int func_149738_a(World world) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos position, Random random) {
        BlockPos blockpos;
        if (random.nextInt(16) == 0 && BSMSlabGravity.canFallThrough(world.func_180495_p(blockpos = position.func_177977_b()))) {
            double d0 = (float)position.func_177958_n() + random.nextFloat();
            double d1 = (double)position.func_177956_o() - 0.05;
            double d2 = (float)position.func_177952_p() + random.nextFloat();
            world.func_175688_a(EnumParticleTypes.FALLING_DUST, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
        }
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (fortune > 3) {
            fortune = 3;
        }
        if (this == BSMBlocks.GRAVEL) {
            return rand.nextInt(10 - fortune * 3) == 0 ? Items.field_151145_ak : this.stackDropped.func_77973_b();
        }
        return this.stackDropped.func_77973_b();
    }

    public int func_149745_a(Random random) {
        return this.stackDropped.func_190916_E();
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return this.stackDropped.func_77952_i();
    }

    public void func_176213_c(World world, BlockPos position, IBlockState state) {
        world.func_175684_a(position, (Block)this, this.func_149738_a(world));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos position, Block block, BlockPos fromPosition) {
        world.func_175684_a(position, (Block)this, this.func_149738_a(world));
    }

    public void func_180650_b(World world, BlockPos position, IBlockState state, Random random) {
        if (!world.field_72995_K) {
            this.checkFallable(world, position);
        }
    }

    private void checkFallable(World world, BlockPos position) {
        if ((world.func_175623_d(position.func_177977_b()) || BSMSlabGravity.canFallThrough(world.func_180495_p(position.func_177977_b()))) && position.func_177956_o() >= 0) {
            int i = 32;
            if (world.func_175707_a(position.func_177982_a(-32, -32, -32), position.func_177982_a(32, 32, 32))) {
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)new EntityFallingBlock(world, (double)position.func_177958_n() + 0.5, (double)position.func_177956_o(), (double)position.func_177952_p() + 0.5, world.func_180495_p(position)));
                }
            } else {
                IBlockState state = world.func_180495_p(position);
                world.func_175698_g(position);
                BlockPos blockpos = position.func_177977_b();
                while ((world.func_175623_d(blockpos) || BSMSlabGravity.canFallThrough(world.func_180495_p(blockpos))) && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177977_b();
                }
                if (blockpos.func_177956_o() > 0) {
                    world.func_175656_a(blockpos.func_177984_a(), state);
                }
            }
        }
    }

    public static boolean canFallThrough(IBlockState state) {
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return block == Blocks.field_150480_ab || material == Material.field_151579_a || material == Material.field_151586_h || material == Material.field_151587_i;
    }

    public static enum GravityVariant {
        SAND(Material.field_151595_p, 0.25f, 0.0f, Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.SAND), MapColor.field_151658_d, SoundType.field_185855_h, new ItemStack((Block)BSMBlocks.SAND, 1, 0), -2370656.0f),
        RED_SAND(Material.field_151595_p, 0.25f, 0.0f, Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND), MapColor.field_151676_q, SoundType.field_185855_h, new ItemStack((Block)BSMBlocks.RED_SAND, 1, 0), -5679071.0f),
        GRAVEL(Material.field_151595_p, 0.3f, 0.0f, Blocks.field_150351_n.func_176223_P(), MapColor.field_151665_m, SoundType.field_185849_b, new ItemStack((Block)BSMBlocks.GRAVEL, 1, 0), -8356741.0f);

        private Material material;
        private float hardness;
        private float resistance;
        private IBlockState fullBlock;
        private MapColor mapColor;
        private SoundType soundType;
        private ItemStack stackDropped;
        private float dustColor;

        private GravityVariant(Material material_, float hardness_, float resistance_, IBlockState fullBlock_, MapColor mapColor_, SoundType soundType_, ItemStack stackDropped_, float dustColor_) {
            this.material = material_;
            this.hardness = hardness_;
            this.resistance = resistance_;
            this.fullBlock = fullBlock_;
            this.mapColor = mapColor_;
            this.soundType = soundType_;
            this.stackDropped = stackDropped_;
            this.dustColor = dustColor_;
        }
    }
}

