/*
 * Decompiled with CFR 0.152.
 */
package tt.betterslabsmod.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import tt.betterslabsmod.blocks.BSMSlab;

public class BSMSlabColored
extends BSMSlab {
    private boolean isGlass;

    public BSMSlabColored(int ID, String name, ColoredVariant variant, int meta) {
        super(ID, name, variant.material, variant.hardness, variant.resistance, variant.fullBlock.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.values()[meta]), EnumDyeColor.values()[meta].func_176768_e(), variant.soundType);
        this.func_149663_c(StringUtils.uncapitalize((String)(EnumDyeColor.values()[meta].func_176610_l() + variant.name)));
        this.isGlass = variant == ColoredVariant.STAINED_GLASS;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.isGlass ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos position, EnumFacing side) {
        if (this.isGlass) {
            IBlockState iState = world.func_180495_p(position.func_177972_a(side));
            Block block = iState.func_177230_c();
            if (blockState != iState) {
                return true;
            }
            return block != this;
        }
        return super.func_176225_a(blockState, world, position, side);
    }

    public static enum ColoredVariant {
        WOOL("wool", Material.field_151580_n, 0.4f, 0.0f, Blocks.field_150325_L.func_176223_P(), SoundType.field_185854_g),
        STAINED_GLASS("stained_glass", Material.field_151592_s, 0.4f, 0.0f, Blocks.field_150399_cn.func_176223_P(), SoundType.field_185853_f),
        HARDENED_CLAY("hardened_clay", Material.field_151576_e, 0.625f, 3.0f, Blocks.field_150406_ce.func_176223_P(), SoundType.field_185851_d);

        private String name;
        private Material material;
        private float hardness;
        private float resistance;
        private IBlockState fullBlock;
        private SoundType soundType;

        private ColoredVariant(String name_, Material material_, float hardness_, float resistance_, IBlockState fullBlock_, SoundType soundType_) {
            this.name = "_" + name_ + "_slab";
            this.material = material_;
            this.hardness = hardness_;
            this.resistance = resistance_;
            this.fullBlock = fullBlock_;
            this.soundType = soundType_;
        }
    }
}

