/*
 * Decompiled with CFR 0.152.
 */
package tt.betterslabsmod.blocks;

import java.util.List;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tt.betterslabsmod.blocks.BSMSlabBasic;
import tt.betterslabsmod.blocks.BSMSlabColored;
import tt.betterslabsmod.blocks.BSMSlabDirt;
import tt.betterslabsmod.blocks.BSMSlabGlass;
import tt.betterslabsmod.blocks.BSMSlabGrass;
import tt.betterslabsmod.blocks.BSMSlabGravity;
import tt.betterslabsmod.blocks.BSMSlabOre;
import tt.betterslabsmod.blocks.BSMSlabPlank;
import tt.betterslabsmod.blocks.BSMSlabPodzol;
import tt.betterslabsmod.blocks.BSMSlabStone;
import tt.betterslabsmod.items.BSMItemBlock;
import tt.betterslabsmod.main.BSMBlocks;
import tt.betterslabsmod.options.BSMOptions;

public class BSMSlab
extends Block {
    public static SortedMap<Integer, BSMSlab> BLOCK_REGISTRY = new TreeMap<Integer, BSMSlab>();
    public static final AxisAlignedBB[] bounding_boxes = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5), new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 0.75), new AxisAlignedBB(0.0, 0.25, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 1.0, 1.0), field_185505_j};
    private static final CreativeTabs CREATIVE_TAB = new CreativeTabs("tabBetterSlabs"){

        @SideOnly(value=Side.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack(Item.func_150898_a((Block)BSMBlocks.STONE));
        }

        @SideOnly(value=Side.CLIENT)
        public void func_78018_a(NonNullList<ItemStack> list) {
            for (BSMSlab slab : BLOCK_REGISTRY.values()) {
                list.add((Object)new ItemStack((Block)slab, 1, 0));
            }
        }
    };
    public static final PropertyEnum<SlabState> SLAB_STATE = PropertyEnum.func_177709_a((String)"slab_state", SlabState.class);
    public String name;
    public int ID;

    public BSMSlab(int ID, String name, Material material, float hardness, float resistance, IBlockState fullBlock, MapColor mapColor, SoundType soundType) {
        super(material, mapColor);
        this.name = name + "_slab";
        this.ID = ID;
        this.func_149672_a(soundType);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SLAB_STATE, (Comparable)((Object)SlabState.DOWN)));
        this.func_149647_a(CREATIVE_TAB);
        GameRegistry.register((IForgeRegistryEntry)this.setRegistryName(this.name));
        GameRegistry.register((IForgeRegistryEntry)new BSMItemBlock(this, fullBlock).setRegistryName(this.getRegistryName()));
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState blockState) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState blockState, IBlockAccess world, BlockPos blockPosition) {
        int slabStateID = ((SlabState)((Object)blockState.func_177229_b(SLAB_STATE))).getID();
        return bounding_boxes[slabStateID < 9 ? slabStateID : 9];
    }

    public void func_185477_a(IBlockState blockState, World world, BlockPos blockPosition, AxisAlignedBB axisAlignedBB, List<AxisAlignedBB> list, @Nullable Entity player, boolean bool) {
        int slabStateID = ((SlabState)((Object)blockState.func_177229_b(SLAB_STATE))).getID();
        if (slabStateID < 9) {
            BSMSlab.func_185492_a((BlockPos)blockPosition, (AxisAlignedBB)axisAlignedBB, list, (AxisAlignedBB)bounding_boxes[slabStateID]);
        } else if (slabStateID >= 9 && slabStateID <= 12) {
            BSMSlab.func_185492_a((BlockPos)blockPosition, (AxisAlignedBB)axisAlignedBB, list, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
            if (slabStateID == 9) {
                BSMSlab.func_185492_a((BlockPos)blockPosition, (AxisAlignedBB)axisAlignedBB, list, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 0.5));
            } else if (slabStateID == 10) {
                BSMSlab.func_185492_a((BlockPos)blockPosition, (AxisAlignedBB)axisAlignedBB, list, (AxisAlignedBB)new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 1.0));
            } else if (slabStateID == 11) {
                BSMSlab.func_185492_a((BlockPos)blockPosition, (AxisAlignedBB)axisAlignedBB, list, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.5, 0.5, 1.0, 1.0, 1.0));
            } else if (slabStateID == 12) {
                BSMSlab.func_185492_a((BlockPos)blockPosition, (AxisAlignedBB)axisAlignedBB, list, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 1.0));
            }
        } else if (slabStateID == 13) {
            BSMSlab.func_185492_a((BlockPos)blockPosition, (AxisAlignedBB)axisAlignedBB, list, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 0.5));
            BSMSlab.func_185492_a((BlockPos)blockPosition, (AxisAlignedBB)axisAlignedBB, list, (AxisAlignedBB)new AxisAlignedBB(0.5, 0.0, 0.5, 1.0, 1.0, 1.0));
        } else if (slabStateID == 14) {
            BSMSlab.func_185492_a((BlockPos)blockPosition, (AxisAlignedBB)axisAlignedBB, list, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.5, 0.5, 1.0, 1.0));
            BSMSlab.func_185492_a((BlockPos)blockPosition, (AxisAlignedBB)axisAlignedBB, list, (AxisAlignedBB)new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 0.5));
        }
    }

    public void func_180633_a(World world, BlockPos blockPosition, IBlockState blockState, EntityLivingBase player, ItemStack itemStack) {
        if (!world.field_72995_K) {
            world.func_175656_a(blockPosition, this.func_176223_P().func_177226_a(SLAB_STATE, (Comparable)((Object)SlabState.values()[new Random().nextInt(12)])));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SLAB_STATE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SLAB_STATE, (Comparable)((Object)SlabState.values()[meta]));
    }

    public int func_176201_c(IBlockState blockState) {
        return ((SlabState)((Object)blockState.func_177229_b(SLAB_STATE))).getID();
    }

    public Item func_180660_a(IBlockState blockState, Random random, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public int func_180651_a(IBlockState blockState) {
        return 0;
    }

    public ItemStack getPickBlock(IBlockState blockState, RayTraceResult rayTrace, World world, BlockPos blockPosistion, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, 0);
    }

    private static void register(int ID, BSMSlab slab) {
        if (BSMOptions.allow_slab[ID]) {
            BLOCK_REGISTRY.put(ID, slab);
            System.out.println((Object)((Object)slab) + "with ID " + ID + " has been registered.");
        }
    }

    public static void initializeSlabs() {
        BSMSlab.register(0, new BSMSlabStone(0, "stone", 0));
        BSMSlab.register(1, new BSMSlabStone(1, "granite", 1));
        BSMSlab.register(2, new BSMSlabStone(2, "polished_granite", 2));
        BSMSlab.register(3, new BSMSlabStone(3, "diorite", 3));
        BSMSlab.register(4, new BSMSlabStone(4, "polished_diorite", 4));
        BSMSlab.register(5, new BSMSlabStone(5, "andesite", 5));
        BSMSlab.register(6, new BSMSlabStone(6, "polished_andesite", 6));
        BSMSlab.register(7, new BSMSlabGrass(7, "grass"));
        BSMSlab.register(8, new BSMSlabDirt(8, "dirt", 0));
        BSMSlab.register(9, new BSMSlabDirt(9, "coarse_dirt", 1));
        BSMSlab.register(10, new BSMSlabPodzol(10, "podzol"));
        BSMSlab.register(11, new BSMSlabBasic(11, "cobblestone", BSMSlabBasic.BasicVariant.COBBLESTONE));
        BSMSlab.register(12, new BSMSlabPlank(12, "oak", 0));
        BSMSlab.register(13, new BSMSlabPlank(13, "spruce", 1));
        BSMSlab.register(14, new BSMSlabPlank(14, "birch", 2));
        BSMSlab.register(15, new BSMSlabPlank(15, "jungle", 3));
        BSMSlab.register(16, new BSMSlabPlank(16, "acacia", 5));
        BSMSlab.register(17, new BSMSlabPlank(17, "dark_oak", 4));
        BSMSlab.register(18, new BSMSlabBasic(18, "bedrock", BSMSlabBasic.BasicVariant.BEDROCK));
        BSMSlab.register(19, new BSMSlabGravity(19, "sand", BSMSlabGravity.GravityVariant.SAND));
        BSMSlab.register(20, new BSMSlabGravity(20, "red_sand", BSMSlabGravity.GravityVariant.RED_SAND));
        BSMSlab.register(21, new BSMSlabGravity(21, "gravel", BSMSlabGravity.GravityVariant.GRAVEL));
        BSMSlab.register(22, new BSMSlabOre(22, "gold", BSMSlabOre.OreVariant.GOLD));
        BSMSlab.register(23, new BSMSlabOre(23, "iron", BSMSlabOre.OreVariant.IRON));
        BSMSlab.register(24, new BSMSlabOre(24, "coal", BSMSlabOre.OreVariant.COAL));
        BSMSlab.register(43, new BSMSlabGlass(43, "glass"));
        BSMSlab.register(49, new BSMSlabColored(49, "white_wool", BSMSlabColored.ColoredVariant.WOOL, 0));
        BSMSlab.register(50, new BSMSlabColored(50, "orange_wool", BSMSlabColored.ColoredVariant.WOOL, 1));
        BSMSlab.register(51, new BSMSlabColored(51, "magenta_wool", BSMSlabColored.ColoredVariant.WOOL, 2));
        BSMSlab.register(52, new BSMSlabColored(52, "light_blue_wool", BSMSlabColored.ColoredVariant.WOOL, 3));
        BSMSlab.register(53, new BSMSlabColored(53, "yellow_wool", BSMSlabColored.ColoredVariant.WOOL, 4));
        BSMSlab.register(54, new BSMSlabColored(54, "lime_wool", BSMSlabColored.ColoredVariant.WOOL, 5));
        BSMSlab.register(55, new BSMSlabColored(55, "pink_wool", BSMSlabColored.ColoredVariant.WOOL, 6));
        BSMSlab.register(56, new BSMSlabColored(56, "gray_wool", BSMSlabColored.ColoredVariant.WOOL, 7));
        BSMSlab.register(57, new BSMSlabColored(57, "light_gray_wool", BSMSlabColored.ColoredVariant.WOOL, 8));
        BSMSlab.register(58, new BSMSlabColored(58, "cyan_wool", BSMSlabColored.ColoredVariant.WOOL, 9));
        BSMSlab.register(59, new BSMSlabColored(59, "purple_wool", BSMSlabColored.ColoredVariant.WOOL, 10));
        BSMSlab.register(60, new BSMSlabColored(60, "blue_wool", BSMSlabColored.ColoredVariant.WOOL, 11));
        BSMSlab.register(61, new BSMSlabColored(61, "brown_wool", BSMSlabColored.ColoredVariant.WOOL, 12));
        BSMSlab.register(62, new BSMSlabColored(62, "green_wool", BSMSlabColored.ColoredVariant.WOOL, 13));
        BSMSlab.register(63, new BSMSlabColored(63, "red_wool", BSMSlabColored.ColoredVariant.WOOL, 14));
        BSMSlab.register(64, new BSMSlabColored(64, "black_wool", BSMSlabColored.ColoredVariant.WOOL, 15));
        BSMSlab.register(81, new BSMSlabColored(81, "white_stained_glass", BSMSlabColored.ColoredVariant.STAINED_GLASS, 0));
        BSMSlab.register(82, new BSMSlabColored(82, "orange_stained_glass", BSMSlabColored.ColoredVariant.STAINED_GLASS, 1));
        BSMSlab.register(83, new BSMSlabColored(83, "magenta_stained_glass", BSMSlabColored.ColoredVariant.STAINED_GLASS, 2));
        BSMSlab.register(84, new BSMSlabColored(84, "light_blue_stained_glass", BSMSlabColored.ColoredVariant.STAINED_GLASS, 3));
        BSMSlab.register(85, new BSMSlabColored(85, "yellow_stained_glass", BSMSlabColored.ColoredVariant.STAINED_GLASS, 4));
        BSMSlab.register(86, new BSMSlabColored(86, "lime_stained_glass", BSMSlabColored.ColoredVariant.STAINED_GLASS, 5));
        BSMSlab.register(87, new BSMSlabColored(87, "pink_stained_glass", BSMSlabColored.ColoredVariant.STAINED_GLASS, 6));
        BSMSlab.register(88, new BSMSlabColored(88, "gray_stained_glass", BSMSlabColored.ColoredVariant.STAINED_GLASS, 7));
        BSMSlab.register(89, new BSMSlabColored(89, "light_gray_stained_glass", BSMSlabColored.ColoredVariant.STAINED_GLASS, 8));
        BSMSlab.register(90, new BSMSlabColored(90, "cyan_stained_glass", BSMSlabColored.ColoredVariant.STAINED_GLASS, 9));
        BSMSlab.register(91, new BSMSlabColored(91, "purple_stained_glass", BSMSlabColored.ColoredVariant.STAINED_GLASS, 10));
        BSMSlab.register(92, new BSMSlabColored(92, "blue_stained_glass", BSMSlabColored.ColoredVariant.STAINED_GLASS, 11));
        BSMSlab.register(93, new BSMSlabColored(93, "brown_stained_glass", BSMSlabColored.ColoredVariant.STAINED_GLASS, 12));
        BSMSlab.register(94, new BSMSlabColored(94, "green_stained_glass", BSMSlabColored.ColoredVariant.STAINED_GLASS, 13));
        BSMSlab.register(95, new BSMSlabColored(95, "red_stained_glass", BSMSlabColored.ColoredVariant.STAINED_GLASS, 14));
        BSMSlab.register(96, new BSMSlabColored(96, "black_stained_glass", BSMSlabColored.ColoredVariant.STAINED_GLASS, 15));
        BSMSlab.register(120, new BSMSlabColored(120, "white_hardened_clay", BSMSlabColored.ColoredVariant.HARDENED_CLAY, 0));
        BSMSlab.register(121, new BSMSlabColored(121, "orange_hardened_clay", BSMSlabColored.ColoredVariant.HARDENED_CLAY, 1));
        BSMSlab.register(122, new BSMSlabColored(122, "magenta_hardened_clay", BSMSlabColored.ColoredVariant.HARDENED_CLAY, 2));
        BSMSlab.register(123, new BSMSlabColored(123, "light_blue_hardened_clay", BSMSlabColored.ColoredVariant.HARDENED_CLAY, 3));
        BSMSlab.register(124, new BSMSlabColored(124, "yellow_hardened_clay", BSMSlabColored.ColoredVariant.HARDENED_CLAY, 4));
        BSMSlab.register(125, new BSMSlabColored(125, "lime_hardened_clay", BSMSlabColored.ColoredVariant.HARDENED_CLAY, 5));
        BSMSlab.register(126, new BSMSlabColored(126, "pink_hardened_clay", BSMSlabColored.ColoredVariant.HARDENED_CLAY, 6));
        BSMSlab.register(127, new BSMSlabColored(127, "gray_hardened_clay", BSMSlabColored.ColoredVariant.HARDENED_CLAY, 7));
        BSMSlab.register(128, new BSMSlabColored(128, "light_gray_hardened_clay", BSMSlabColored.ColoredVariant.HARDENED_CLAY, 8));
        BSMSlab.register(129, new BSMSlabColored(129, "cyan_hardened_clay", BSMSlabColored.ColoredVariant.HARDENED_CLAY, 9));
        BSMSlab.register(130, new BSMSlabColored(130, "purple_hardened_clay", BSMSlabColored.ColoredVariant.HARDENED_CLAY, 10));
        BSMSlab.register(131, new BSMSlabColored(131, "blue_hardened_clay", BSMSlabColored.ColoredVariant.HARDENED_CLAY, 11));
        BSMSlab.register(132, new BSMSlabColored(132, "brown_hardened_clay", BSMSlabColored.ColoredVariant.HARDENED_CLAY, 12));
        BSMSlab.register(133, new BSMSlabColored(133, "green_hardened_clay", BSMSlabColored.ColoredVariant.HARDENED_CLAY, 13));
        BSMSlab.register(134, new BSMSlabColored(134, "red_hardened_clay", BSMSlabColored.ColoredVariant.HARDENED_CLAY, 14));
        BSMSlab.register(135, new BSMSlabColored(135, "black_hardened_clay", BSMSlabColored.ColoredVariant.HARDENED_CLAY, 15));
    }

    public static enum SlabState implements IStringSerializable
    {
        NORTH(0, "north", EnumFacing.SOUTH),
        EAST(1, "east", EnumFacing.WEST),
        SOUTH(2, "south", EnumFacing.NORTH),
        WEST(3, "west", EnumFacing.EAST),
        DOWN(4, "down", EnumFacing.UP),
        UP(5, "up", EnumFacing.DOWN),
        X_AXIS(6, "x_axis"),
        Y_AXIS(7, "y_axis"),
        Z_AXIS(8, "z_axis"),
        SLOPE_NORTH(9, "slope_north"),
        SLOPE_EAST(10, "slope_east"),
        SLOPE_SOUTH(11, "slope_south"),
        SLOPE_WEST(12, "slope_west"),
        DIAGONAL_LEFT(13, "diagonal_left"),
        DIAGONAL_RIGHT(14, "diagonal_right");

        public static final String NAME = "slab_state";
        private int stateID;
        private String stateName;
        private EnumFacing oppositeSide;

        private SlabState(int stateID_, String stateName_) {
            this(stateID_, stateName_, null);
        }

        private SlabState(@Nullable int stateID_, String stateName_, EnumFacing oppositeSide_) {
            this.stateID = stateID_;
            this.stateName = stateName_;
            this.oppositeSide = oppositeSide_;
        }

        public int getID() {
            return this.stateID;
        }

        public String func_176610_l() {
            return this.stateName;
        }

        public boolean isOppositeSide(EnumFacing side) {
            return side == this.oppositeSide;
        }

        public static SlabState getAxisFromSide(EnumFacing side) {
            return side == EnumFacing.DOWN || side == EnumFacing.UP ? Y_AXIS : (side == EnumFacing.NORTH || side == EnumFacing.SOUTH ? Z_AXIS : X_AXIS);
        }

        public static SlabState getStateFromSide(EnumFacing side) {
            switch (side) {
                case NORTH: {
                    return SOUTH;
                }
                case EAST: {
                    return WEST;
                }
                case SOUTH: {
                    return NORTH;
                }
                case WEST: {
                    return EAST;
                }
                case DOWN: {
                    return UP;
                }
                case UP: {
                    return DOWN;
                }
            }
            return DOWN;
        }

        public static boolean isNormal(SlabState state) {
            return state.getID() == 4 || state.getID() == 5;
        }

        public static boolean isVertical(SlabState state) {
            return state.getID() <= 3;
        }
    }
}

