/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.handler.MultipartProxy;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import mrtjp.projectred.core.CommandDebug;
import mrtjp.projectred.transmission.IWirePart;

public class WirePropogator {
    private static Field wiresProvidePower = aqb.class.getDeclaredFields()[0];
    public static boolean redwiresProvidePower = true;
    private static ThreadLocal<Boolean> redwiresConnectable = new ThreadLocal();
    private static TMultiPart notApart = new TMultiPart(){

        public String getType() {
            return null;
        }
    };
    private static Stack<PropogationRun> reusableRuns;
    private static PropogationRun currentRun;
    private static PropogationRun finishing;

    public static void setWiresProvidePower(boolean b) {
        try {
            wiresProvidePower.setBoolean(aqz.aA, b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean redwiresConnectable() {
        Boolean b = redwiresConnectable.get();
        return b == null ? true : b;
    }

    public static void setRedwiresConnectable(boolean b) {
        redwiresConnectable.set(b);
    }

    private static PropogationRun getRun() {
        if (reusableRuns.isEmpty()) {
            return new PropogationRun();
        }
        return reusableRuns.pop();
    }

    public static void addNeighborChange(BlockCoord pos) {
        currentRun.neighborChanges.add(pos);
    }

    public static void addPartChange(TMultiPart part) {
        currentRun.partChanges.put((Object)part.tile(), (Object)part);
    }

    public static void logCalculation() {
        if (finishing != null) {
            finishing.recalcs++;
        }
    }

    public static void propogateTo(IWirePart part, TMultiPart prev, int mode) {
        PropogationRun p = currentRun;
        if (p == null) {
            p = WirePropogator.getRun();
        }
        p.add(part, prev, mode);
        if (currentRun != p) {
            if (currentRun != null) {
                throw new RuntimeException("Report this to ProjectRed developers");
            }
            p.start(finishing, part.world());
        }
    }

    public static void propogateTo(IWirePart part, int mode) {
        WirePropogator.propogateTo(part, notApart, mode);
    }

    public static void propogateAnalogDrop(IWirePart part) {
        currentRun.addAnalogDrop(part);
    }

    static {
        try {
            wiresProvidePower.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        reusableRuns = new Stack();
        currentRun = null;
        finishing = null;
    }

    private static class PropogationRun {
        private abw world;
        private PropogationRun parent;
        private TMultiPart lastCaller;
        private int count;
        private int recalcs;
        private Multimap<TileMultipart, TMultiPart> partChanges = HashMultimap.create();
        private HashSet<BlockCoord> neighborChanges = new HashSet();
        private LinkedList<Propogation> propogationList = new LinkedList();
        private LinkedList<Propogation> analogDrops = new LinkedList();

        private PropogationRun() {
        }

        public void clear() {
            this.partChanges.clear();
            this.neighborChanges.clear();
            this.count = 0;
            this.recalcs = 0;
            this.lastCaller = null;
            reusableRuns.add(this);
        }

        public void finish() {
            currentRun = null;
            if (this.partChanges.isEmpty() && this.neighborChanges.isEmpty()) {
                finishing = this.parent;
                this.clear();
                return;
            }
            finishing = this;
            if (CommandDebug.WIRE_READING) {
                System.out.println("" + this.count + " propogations, " + this.partChanges.size() + " part changes, " + this.neighborChanges.size() + " block updates");
            }
            for (Map.Entry entry : this.partChanges.asMap().entrySet()) {
                Collection parts = (Collection)entry.getValue();
                for (TMultiPart part : parts) {
                    ((IWirePart)part).onSignalUpdate();
                }
                ((TileMultipart)entry.getKey()).multiPartChange(parts);
            }
            int blockID = MultipartProxy.block().cF;
            for (BlockCoord b : this.neighborChanges) {
                this.world.g(b.x, b.y, b.z, blockID);
            }
            finishing = this.parent;
            if (CommandDebug.WIRE_READING) {
                System.out.println("" + this.recalcs + " recalculations");
            }
            this.clear();
        }

        public void start(PropogationRun parent, abw world) {
            this.world = world;
            this.parent = parent;
            currentRun = this;
            this.runLoop();
        }

        private void runLoop() {
            do {
                LinkedList<Propogation> list = this.propogationList;
                this.propogationList = new LinkedList();
                for (Propogation p : list) {
                    p.propogate();
                }
                if (!this.propogationList.isEmpty() || this.analogDrops.isEmpty()) continue;
                this.propogationList = this.analogDrops;
                this.analogDrops = new LinkedList();
            } while (!this.propogationList.isEmpty());
            this.finish();
        }

        public void add(IWirePart part, TMultiPart prev, int mode) {
            if (prev != this.lastCaller) {
                this.lastCaller = prev;
                ++this.count;
            }
            this.propogationList.add(new Propogation(part, prev, mode));
        }

        public void addAnalogDrop(IWirePart part) {
            this.analogDrops.add(new Propogation(part, notApart, 0));
        }

        public class Propogation {
            public IWirePart part;
            public TMultiPart prev;
            public int mode;

            public Propogation(IWirePart part, TMultiPart prev, int mode) {
                this.part = part;
                this.prev = prev;
                this.mode = mode;
            }

            public void propogate() {
                this.part.updateAndPropogate(this.prev, this.mode);
            }
        }
    }
}

