/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.multipart.TMultiPart;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.integration.RedstoneGateLogic;
import mrtjp.projectred.integration.RedstoneGatePart;
import mrtjp.projectred.integration.SimpleGateLogic;

public class SimpleGatePart
extends RedstoneGatePart {
    public byte state;

    public int state() {
        return this.state & 0xFF;
    }

    public void setState(int s) {
        this.state = (byte)s;
    }

    @Override
    public void save(by tag) {
        super.save(tag);
        tag.a("state", this.state);
    }

    @Override
    public void load(by tag) {
        super.load(tag);
        this.state = tag.c("state");
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte((int)this.state);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.state = packet.readByte();
    }

    @Override
    public void read(MCDataInput packet, int switch_key) {
        if (switch_key == 10) {
            this.state = packet.readByte();
            if (Configurator.staticGates) {
                this.tile().markRender();
            }
        } else {
            super.read(packet, switch_key);
        }
    }

    @Override
    public String getType() {
        return "pr_sgate";
    }

    @Override
    public RedstoneGateLogic getLogic() {
        return SimpleGateLogic.instances[this.subID & 0xFF];
    }

    public void sendStateUpdate() {
        this.getWriteStream(10).writeByte((int)this.state);
    }

    public void onWorldJoin() {
        super.onWorldJoin();
        if (this.getLogic() == null) {
            this.tile().remPart((TMultiPart)this);
        }
    }

    public void onInputChange() {
        this.tile().markDirty();
        this.sendStateUpdate();
    }

    public void onOutputChange(int mask) {
        this.tile().markDirty();
        this.sendStateUpdate();
        this.tile().internalPartChange((TMultiPart)this);
        this.notifyNeighbors(this.toAbsoluteMask(mask));
    }
}

