/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration;

import java.util.Random;
import mrtjp.projectred.ProjectRedExploration;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.IRetroGenerator;
import mrtjp.projectred.core.RetroactiveWorldGenerator;
import mrtjp.projectred.exploration.BlockOre;
import mrtjp.projectred.exploration.BlockSpecialStone;
import mrtjp.projectred.exploration.BlockStainedLeaf;
import mrtjp.projectred.exploration.GeneratorCustomTree;
import mrtjp.projectred.exploration.GeneratorMetamorphicCave;
import mrtjp.projectred.exploration.GeneratorOre;
import mrtjp.projectred.exploration.GeneratorVolcano;

public class RetroGenerationManager {
    public static void registerRetroGenerators() {
        if (Configurator.gen_Ruby.getBoolean(true)) {
            RetroactiveWorldGenerator.registerRetroGenerator((IRetroGenerator)new RetrogenRuby());
        }
        if (Configurator.gen_Sapphire.getBoolean(true)) {
            RetroactiveWorldGenerator.registerRetroGenerator((IRetroGenerator)new RetrogenSapphire());
        }
        if (Configurator.gen_Peridot.getBoolean(true)) {
            RetroactiveWorldGenerator.registerRetroGenerator((IRetroGenerator)new RetrogenPeridot());
        }
        if (Configurator.gen_MarbleCave.getBoolean(true)) {
            RetroactiveWorldGenerator.registerRetroGenerator((IRetroGenerator)new RetrogenMarbleCave());
        }
        if (Configurator.gen_Volcano.getBoolean(true)) {
            RetroactiveWorldGenerator.registerRetroGenerator((IRetroGenerator)new RetrogenVolcano());
        }
        if (Configurator.gen_dyeTrees.getBoolean(true)) {
            RetroactiveWorldGenerator.registerRetroGenerator((IRetroGenerator)new RetrogenDyeTrees());
        }
    }

    static class RetrogenDyeTrees
    implements IRetroGenerator {
        RetrogenDyeTrees() {
        }

        public String getSubgenerationID() {
            return "pr_dyetrees";
        }

        public boolean shouldGenerateInLocation(abw w, adr c) {
            int id = w.t.i;
            if (w.t.c == acg.c) {
                return false;
            }
            return id == 0;
        }

        public void generate(Random r2, abw w, int chunkX, int chunkZ) {
            int saplingMeta = r2.nextInt(16);
            int x = chunkX * 16 + r2.nextInt(16);
            int z = chunkZ * 16 + r2.nextInt(16);
            int y = w.f(x, z);
            if (r2.nextDouble() < (double)(BlockStainedLeaf.EnumDyeTrees.VALID_FOLIAGE[saplingMeta].growthChance / 3.0f)) {
                new GeneratorCustomTree(false, 5, aqz.O.cF, 0, ProjectRedExploration.blockStainedLeaf.cF, saplingMeta, -1, -1).a(w, r2, x, y, z);
            }
        }
    }

    static class RetrogenVolcano
    implements IRetroGenerator {
        RetrogenVolcano() {
        }

        public String getSubgenerationID() {
            return "pr_volcano";
        }

        public boolean shouldGenerateInLocation(abw w, adr c) {
            if (w.t.c == acg.c) {
                return false;
            }
            return w.t.i == 0;
        }

        public void generate(Random r2, abw w, int chunkX, int chunkZ) {
            int x = chunkX * 16 + r2.nextInt(16);
            int y = r2.nextInt(32);
            int z = chunkZ * 16 + r2.nextInt(16);
            new GeneratorVolcano(ProjectRedExploration.blockStones.cF, BlockSpecialStone.EnumSpecialStone.BASALT.meta, ls.a((Random)r2, (int)32000, (int)64000)).a(w, r2, x, y, z);
        }
    }

    static class RetrogenMarbleCave
    implements IRetroGenerator {
        RetrogenMarbleCave() {
        }

        public String getSubgenerationID() {
            return "pr_marbleCave";
        }

        public boolean shouldGenerateInLocation(abw w, adr c) {
            return w.t.i == 0;
        }

        public void generate(Random r2, abw w, int chunkX, int chunkZ) {
            int x = chunkX * 16 + r2.nextInt(16);
            int y = 32 + r2.nextInt(32);
            int z = chunkZ * 16 + r2.nextInt(16);
            new GeneratorMetamorphicCave(ProjectRedExploration.blockStones.cF, BlockSpecialStone.EnumSpecialStone.MARBLE.meta, r2.nextInt(4096)).a(w, r2, x, y, z);
        }
    }

    static class RetrogenPeridot
    implements IRetroGenerator {
        RetrogenPeridot() {
        }

        public String getSubgenerationID() {
            return "pr_peridot";
        }

        public boolean shouldGenerateInLocation(abw w, adr c) {
            int id = w.t.i;
            return id != -1 && id != 1;
        }

        public void generate(Random r2, abw w, int chunkX, int chunkZ) {
            for (int i = 0; i < 2; ++i) {
                int x = chunkX * 16 + r2.nextInt(16);
                int y = r2.nextInt(48);
                int z = chunkZ * 16 + r2.nextInt(16);
                new GeneratorOre(ProjectRedExploration.blockOres.cF, BlockOre.EnumOre.OREPERIDOT.meta, 5).a(w, r2, x, y, z);
            }
        }
    }

    static class RetrogenSapphire
    implements IRetroGenerator {
        RetrogenSapphire() {
        }

        public String getSubgenerationID() {
            return "pr_sapphire";
        }

        public boolean shouldGenerateInLocation(abw w, adr c) {
            int id = w.t.i;
            return id != -1 && id != 1;
        }

        public void generate(Random r2, abw w, int chunkX, int chunkZ) {
            for (int i = 0; i < 2; ++i) {
                int x = chunkX * 16 + r2.nextInt(16);
                int y = r2.nextInt(48);
                int z = chunkZ * 16 + r2.nextInt(16);
                new GeneratorOre(ProjectRedExploration.blockOres.cF, BlockOre.EnumOre.ORESAPPHIRE.meta, 5).a(w, r2, x, y, z);
            }
        }
    }

    static class RetrogenRuby
    implements IRetroGenerator {
        RetrogenRuby() {
        }

        public String getSubgenerationID() {
            return "pr_ruby";
        }

        public boolean shouldGenerateInLocation(abw w, adr c) {
            int id = w.t.i;
            return id != -1 && id != 1;
        }

        public void generate(Random r2, abw w, int chunkX, int chunkZ) {
            for (int i = 0; i < 2; ++i) {
                int x = chunkX * 16 + r2.nextInt(16);
                int y = r2.nextInt(48);
                int z = chunkZ * 16 + r2.nextInt(16);
                new GeneratorOre(ProjectRedExploration.blockOres.cF, BlockOre.EnumOre.ORERUBY.meta, 5).a(w, r2, x, y, z);
            }
        }
    }
}

