/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration;

import cpw.mods.fml.common.registry.GameRegistry;
import mrtjp.projectred.ProjectRedExploration;
import mrtjp.projectred.core.ItemPart;
import mrtjp.projectred.core.PRColors;
import mrtjp.projectred.core.ShapelessOreNBTRecipe;
import mrtjp.projectred.exploration.BlockOre;
import mrtjp.projectred.exploration.BlockSpecialStone;
import mrtjp.projectred.exploration.ItemBackpack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ExplorationRecipes {
    public static void initRecipes() {
        ExplorationRecipes.initOtherRecipes();
        ExplorationRecipes.initGemToolRecipes();
        ExplorationRecipes.initToolRecipes();
        ExplorationRecipes.initWorldRecipes();
    }

    public static void initOreDict() {
        ItemBackpack.EnumBackpack.initOreDictDefinitions();
        OreDictionary.registerOre((String)"gemRuby", (ye)ItemPart.EnumPart.RUBY.getItemStack());
        OreDictionary.registerOre((String)"gemSapphire", (ye)ItemPart.EnumPart.SAPPHIRE.getItemStack());
        OreDictionary.registerOre((String)"gemPeridot", (ye)ItemPart.EnumPart.PERIDOT.getItemStack());
        OreDictionary.registerOre((String)"oreRuby", (ye)BlockOre.EnumOre.ORERUBY.getItemStack(1));
        OreDictionary.registerOre((String)"oreSapphire", (ye)BlockOre.EnumOre.ORESAPPHIRE.getItemStack(1));
        OreDictionary.registerOre((String)"orePeridot", (ye)BlockOre.EnumOre.OREPERIDOT.getItemStack(1));
    }

    private static void initGemToolRecipes() {
        ExplorationRecipes.addAxeRecipe(new ye((yc)ProjectRedExploration.itemRubyAxe), "gemRuby");
        ExplorationRecipes.addAxeRecipe(new ye((yc)ProjectRedExploration.itemSapphireAxe), "gemSapphire");
        ExplorationRecipes.addAxeRecipe(new ye((yc)ProjectRedExploration.itemPeridotAxe), "gemPeridot");
        ExplorationRecipes.addHoeRecipe(new ye((yc)ProjectRedExploration.itemRubyHoe), "gemRuby");
        ExplorationRecipes.addHoeRecipe(new ye((yc)ProjectRedExploration.itemSapphireHoe), "gemSapphire");
        ExplorationRecipes.addHoeRecipe(new ye((yc)ProjectRedExploration.itemPeridotHoe), "gemPeridot");
        ExplorationRecipes.addPickaxeRecipe(new ye((yc)ProjectRedExploration.itemRubyPickaxe), "gemRuby");
        ExplorationRecipes.addPickaxeRecipe(new ye((yc)ProjectRedExploration.itemSapphirePickaxe), "gemSapphire");
        ExplorationRecipes.addPickaxeRecipe(new ye((yc)ProjectRedExploration.itemPeridotPickaxe), "gemPeridot");
        ExplorationRecipes.addShovelRecipe(new ye((yc)ProjectRedExploration.itemRubyShovel), "gemRuby");
        ExplorationRecipes.addShovelRecipe(new ye((yc)ProjectRedExploration.itemSapphireShovel), "gemSapphire");
        ExplorationRecipes.addShovelRecipe(new ye((yc)ProjectRedExploration.itemPeridotShovel), "gemPeridot");
        ExplorationRecipes.addSwordRecipe(new ye((yc)ProjectRedExploration.itemRubySword), "gemRuby");
        ExplorationRecipes.addSwordRecipe(new ye((yc)ProjectRedExploration.itemSapphireSword), "gemSapphire");
        ExplorationRecipes.addSwordRecipe(new ye((yc)ProjectRedExploration.itemPeridotSword), "gemPeridot");
        ExplorationRecipes.addSawRecipe(new ye((yc)ProjectRedExploration.itemGoldSaw), new ye(yc.r));
        ExplorationRecipes.addSawRecipe(new ye((yc)ProjectRedExploration.itemRubySaw), "gemRuby");
        ExplorationRecipes.addSawRecipe(new ye((yc)ProjectRedExploration.itemSapphireSaw), "gemSapphire");
        ExplorationRecipes.addSawRecipe(new ye((yc)ProjectRedExploration.itemPeridotSaw), "gemPeridot");
        ExplorationRecipes.addSickleRecipe(new ye((yc)ProjectRedExploration.itemWoodSickle), "plankWood");
        ExplorationRecipes.addSickleRecipe(new ye((yc)ProjectRedExploration.itemStoneSickle), new ye(yc.ar));
        ExplorationRecipes.addSickleRecipe(new ye((yc)ProjectRedExploration.itemIronSickle), new ye(yc.q));
        ExplorationRecipes.addSickleRecipe(new ye((yc)ProjectRedExploration.itemGoldSickle), new ye(yc.r));
        ExplorationRecipes.addSickleRecipe(new ye((yc)ProjectRedExploration.itemRubySickle), "gemRuby");
        ExplorationRecipes.addSickleRecipe(new ye((yc)ProjectRedExploration.itemSapphireSickle), "gemSapphire");
        ExplorationRecipes.addSickleRecipe(new ye((yc)ProjectRedExploration.itemPeridotSickle), "gemPeridot");
        ExplorationRecipes.addSickleRecipe(new ye((yc)ProjectRedExploration.itemDiamondSickle), new ye(yc.p));
    }

    private static void addAxeRecipe(ye o, Object m) {
        GameRegistry.addRecipe((aah)new ShapedOreRecipe(o, new Object[]{"mm", "ms", " s", Character.valueOf('m'), m, Character.valueOf('s'), yc.F}));
    }

    private static void addHoeRecipe(ye o, Object m) {
        GameRegistry.addRecipe((aah)new ShapedOreRecipe(o, new Object[]{"mm", " s", " s", Character.valueOf('m'), m, Character.valueOf('s'), yc.F}));
    }

    private static void addPickaxeRecipe(ye o, Object m) {
        GameRegistry.addRecipe((aah)new ShapedOreRecipe(o, new Object[]{"mmm", " s ", " s ", Character.valueOf('m'), m, Character.valueOf('s'), yc.F}));
    }

    private static void addShovelRecipe(ye o, Object m) {
        GameRegistry.addRecipe((aah)new ShapedOreRecipe(o, new Object[]{"m", "s", "s", Character.valueOf('m'), m, Character.valueOf('s'), yc.F}));
    }

    private static void addSwordRecipe(ye o, Object m) {
        GameRegistry.addRecipe((aah)new ShapedOreRecipe(o, new Object[]{"m", "m", "s", Character.valueOf('m'), m, Character.valueOf('s'), yc.F}));
    }

    private static void addSawRecipe(ye o, Object m) {
        GameRegistry.addRecipe((aah)new ShapedOreRecipe(o, new Object[]{"srr", "sbb", Character.valueOf('s'), yc.F, Character.valueOf('r'), "stoneRod", Character.valueOf('b'), m}));
    }

    private static void addSickleRecipe(ye o, Object m) {
        GameRegistry.addRecipe((aah)new ShapedOreRecipe(o, new Object[]{" m ", "  m", "sm ", Character.valueOf('s'), yc.F, Character.valueOf('m'), m}));
    }

    private static void initOtherRecipes() {
        GameRegistry.addRecipe((ye)new ye(yc.M, 4), (Object[])new Object[]{"gw", Character.valueOf('g'), new ye((yc)ProjectRedExploration.itemWoolGin, 1, Short.MAX_VALUE), Character.valueOf('w'), aqz.ag});
    }

    private static void initToolRecipes() {
        GameRegistry.addRecipe((ye)new ye((yc)ProjectRedExploration.itemWoolGin), (Object[])new Object[]{"sis", "sss", " s ", Character.valueOf('s'), yc.F, Character.valueOf('i'), ItemPart.EnumPart.IRONCOIL.getItemStack()});
        for (int i = 0; i < ItemBackpack.EnumBackpack.VALID_BP.length; ++i) {
            GameRegistry.addRecipe((aah)new ShapedOreRecipe(ItemBackpack.EnumBackpack.get(i).getItemStack(), new Object[]{"ccc", "cdc", "ccc", Character.valueOf('c'), ItemPart.EnumPart.WOVENCLOTH.getItemStack(), Character.valueOf('d'), PRColors.get((int)i).getOreDict()}));
            GameRegistry.addRecipe((aah)new ShapelessOreNBTRecipe(ItemBackpack.EnumBackpack.get(i).getItemStack(), new Object[]{"ProjRed|Exploration:bag", PRColors.get((int)i).getOreDict()}).setKeepNBT());
        }
    }

    private static void initWorldRecipes() {
        GameRegistry.addRecipe((ye)BlockSpecialStone.EnumSpecialStone.MARBLEBRICK.getItemStack(4), (Object[])new Object[]{"bb", "bb", Character.valueOf('b'), BlockSpecialStone.EnumSpecialStone.MARBLE.getItemStack()});
        GameRegistry.addRecipe((ye)BlockSpecialStone.EnumSpecialStone.BASALTBRICK.getItemStack(4), (Object[])new Object[]{"bb", "bb", Character.valueOf('b'), BlockSpecialStone.EnumSpecialStone.BASALT.getItemStack()});
        aab.a().addSmelting(ProjectRedExploration.blockStones.cF, BlockSpecialStone.EnumSpecialStone.BASALTCOBBLE.meta, BlockSpecialStone.EnumSpecialStone.BASALT.getItemStack(), 0.0f);
        GameRegistry.addRecipe((ye)BlockSpecialStone.EnumSpecialStone.RUBYBLOCK.getItemStack(), (Object[])new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), ItemPart.EnumPart.RUBY.getItemStack()});
        GameRegistry.addRecipe((ye)BlockSpecialStone.EnumSpecialStone.SAPPHIREBLOCK.getItemStack(), (Object[])new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), ItemPart.EnumPart.SAPPHIRE.getItemStack()});
        GameRegistry.addRecipe((ye)BlockSpecialStone.EnumSpecialStone.PERIDOTBLOCK.getItemStack(), (Object[])new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), ItemPart.EnumPart.PERIDOT.getItemStack()});
        GameRegistry.addShapelessRecipe((ye)ItemPart.EnumPart.RUBY.getItemStack(9), (Object[])new Object[]{BlockSpecialStone.EnumSpecialStone.RUBYBLOCK.getItemStack()});
        GameRegistry.addShapelessRecipe((ye)ItemPart.EnumPart.SAPPHIRE.getItemStack(9), (Object[])new Object[]{BlockSpecialStone.EnumSpecialStone.SAPPHIREBLOCK.getItemStack()});
        GameRegistry.addShapelessRecipe((ye)ItemPart.EnumPart.PERIDOT.getItemStack(9), (Object[])new Object[]{BlockSpecialStone.EnumSpecialStone.PERIDOTBLOCK.getItemStack()});
        for (BlockSpecialStone.EnumSpecialStone s : BlockSpecialStone.EnumSpecialStone.VALID_STONE) {
            ExplorationRecipes.addWallRecipe(new ye((aqz)ProjectRedExploration.blockStoneWalls, 6, s.meta), s.getItemStack());
        }
    }

    private static void addWallRecipe(ye o, ye m) {
        GameRegistry.addRecipe((ye)o, (Object[])new Object[]{"mmm", "mmm", Character.valueOf('m'), m});
    }
}

