/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.fx;

import mrtjp.projectred.core.fx.ParticleLogic;

public class ParticleLogicApproachEntity
extends ParticleLogic {
    private final nn target;
    private final double approachSpeed;
    private final double targetDistance;

    public ParticleLogicApproachEntity(nn approachEntity, double approachSpeed, double targetDistance) {
        this.target = approachEntity;
        this.approachSpeed = approachSpeed;
        this.targetDistance = targetDistance;
    }

    @Override
    public void doUpdate() {
        double deltaY;
        double angle;
        if (this.target == null) {
            this.finishLogic();
            return;
        }
        double distanceToTarget = this.particle.e(this.target);
        double deltaX = this.target.u - this.particle.u;
        double deltaZ = this.target.w - this.particle.w;
        double radians = angle = Math.atan2(deltaZ, deltaX);
        double posX = this.particle.u + this.approachSpeed * Math.cos(radians);
        double posY = this.particle.v;
        double posZ = this.particle.w + this.approachSpeed * Math.sin(radians);
        if (this.target instanceof og) {
            og entityliving = (og)this.target;
            deltaY = posY - (entityliving.v + (double)entityliving.f());
        } else {
            deltaY = this.target instanceof ss ? posY - this.target.v : (this.target.E.b + this.target.E.e) / 2.0 - posY;
        }
        double horizontalDistance = ls.a((double)(deltaX * deltaX + deltaZ * deltaZ));
        float pitchRotation = (float)(-Math.atan2(deltaY, horizontalDistance));
        double pitchRadians = pitchRotation;
        posY = this.particle.v - this.approachSpeed * Math.sin(pitchRadians);
        if (distanceToTarget <= this.targetDistance * this.targetDistance) {
            this.finishLogic();
        } else {
            this.particle.b(posX, posY, posZ);
        }
    }

    @Override
    public ParticleLogic clone() {
        return new ParticleLogicApproachEntity(this.target, this.approachSpeed, this.targetDistance).setFinal(this.finalLogic).setPriority(this.priority);
    }
}

