/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.fx;

import java.util.Random;
import mrtjp.projectred.core.fx.CoreParticle;

public abstract class ParticleLogic {
    protected CoreParticle particle;
    protected Random rand = new Random();
    protected int priority = 1;
    protected boolean finalLogic = false;
    private boolean finished = false;
    private boolean terminateWhenFinished = false;
    protected boolean firstTick = true;

    public ParticleLogic setTerminate(boolean kill) {
        this.terminateWhenFinished = kill;
        return this;
    }

    public ParticleLogic setFinal(boolean flag) {
        this.finalLogic = flag;
        return this;
    }

    public ParticleLogic setPriority(int pri) {
        this.priority = pri;
        return this;
    }

    public boolean isTerminating() {
        return this.terminateWhenFinished;
    }

    public abstract void doUpdate();

    public abstract ParticleLogic clone();

    public void onUpdate(abw world, CoreParticle particle) {
        this.particle = particle;
        if (!world.I) {
            if (particle != null) {
                particle.x();
            }
            return;
        }
        if (particle != null) {
            this.doUpdate();
        }
        if (this.firstTick) {
            this.firstTick = false;
        }
    }

    public int getPriority() {
        return this.priority;
    }

    protected void finishLogic() {
        this.finished = true;
        if (this.particle != null && this.terminateWhenFinished) {
            this.particle.x();
        }
    }

    public boolean isFinalLogic() {
        return this.finalLogic;
    }

    public boolean getFinished() {
        return this.finished;
    }
}

