/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.IRetroGenerator;
import mrtjp.projectred.core.PRLogger;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkDataEvent;

public class RetroactiveWorldGenerator
implements ITickHandler {
    public static final RetroactiveWorldGenerator instance = new RetroactiveWorldGenerator();
    String RetroGenID = Configurator.retroGenID;
    String RetroGenNBT = "RetrogenData_";
    private static ArrayList<IRetroGenerator> generators = new ArrayList();
    private static ArrayList<RetroGenQueue> generationQueue = new ArrayList();

    public static void registerRetroGenerator(IRetroGenerator g) {
        generators.add(g);
    }

    @ForgeSubscribe
    public void chunkLoad(ChunkDataEvent.Load event) {
        this.queueRetroactiveGeneration(event);
    }

    private void queueRetroactiveGeneration(ChunkDataEvent.Load event) {
        abw w = event.world;
        adr c = event.getChunk();
        RetroDatabase database = this.getRetroDatabase(w);
        int x = event.getChunk().g;
        int z2 = event.getChunk().h;
        for (IRetroGenerator rg : generators) {
            if (!rg.shouldGenerateInLocation(w, event.getChunk()) || !database.isGenerationNeeded(x, z2, rg.getSubgenerationID())) continue;
            PRLogger.info("Chunk @(" + x + "," + z2 + ",DIM" + w.t.i + ") has been marked for retroactive generation for ID " + rg.getSubgenerationID());
            generationQueue.add(new RetroGenQueue(w, x, z2, rg));
            database.markChunkRetroGenerated(x, z2, rg.getSubgenerationID());
        }
    }

    private RetroDatabase getRetroDatabase(abw w) {
        RetroDatabase database = (RetroDatabase)w.perWorldStorage.a(RetroDatabase.class, this.RetroGenNBT + this.RetroGenID);
        if (database == null) {
            database = new RetroDatabase(this.RetroGenNBT + this.RetroGenID);
            w.perWorldStorage.a(this.RetroGenNBT + this.RetroGenID, (all)database);
            PRLogger.info("Created Retrogen database for dimension " + w.t.i);
        }
        return database;
    }

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        this.runRetroactiveGeneration((abw)((js)tickData[0]));
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.WORLD);
    }

    public String getLabel() {
        return "pr_retrogen_ticker";
    }

    private void runRetroactiveGeneration(abw w1) {
        if (generationQueue.size() == 0) {
            return;
        }
        if (w1.J() % 10L != 0L) {
            return;
        }
        ArrayList<RetroGenQueue> removeQueue = new ArrayList<RetroGenQueue>();
        ArrayList iterationQueue = (ArrayList)generationQueue.clone();
        int count = 0;
        for (RetroGenQueue q : iterationQueue) {
            q.gen.generate(q.w.s, q.w, q.chunkX, q.chunkZ);
            removeQueue.add(q);
            if (++count < 32) continue;
            break;
        }
        generationQueue.removeAll(removeQueue);
        PRLogger.info(count + " chunks have been re-generated. " + generationQueue.size() + " left.");
    }

    public static class RetroDatabase
    extends all {
        private HashMap<LocHash, by> chunks = new HashMap();

        public RetroDatabase(String par1Str) {
            super(par1Str);
        }

        public boolean isGenerationNeeded(int chunkX, int chunkZ, String subID) {
            by chunkData = this.chunks.get(new LocHash(chunkX, chunkZ));
            return chunkData == null || !chunkData.b(subID) || !chunkData.n(subID);
        }

        public void markChunkRetroGenerated(int chunkX, int chunkZ, String subID) {
            by chunkData = this.chunks.get(new LocHash(chunkX, chunkZ));
            if (chunkData == null) {
                chunkData = new by();
            }
            chunkData.a(subID, true);
            this.chunks.put(new LocHash(chunkX, chunkZ), chunkData);
            this.c();
        }

        public void a(by nbt) {
            int size = nbt.e("size");
            for (int i = 0; i < size; ++i) {
                this.chunks.put(new LocHash().readFromNBT(i + "hash", nbt), nbt.l(i + "tag"));
            }
        }

        public void b(by nbt) {
            nbt.a("size", this.chunks.size());
            int index = 0;
            for (LocHash i : this.chunks.keySet()) {
                i.writeToNBT(index + "hash", nbt);
                nbt.a(index + "tag", (cl)this.chunks.get(i));
                ++index;
            }
        }

        private class LocHash {
            int x;
            int z;

            public LocHash() {
            }

            public LocHash(int x, int z2) {
                this.x = x;
                this.z = z2;
            }

            public boolean equals(Object o) {
                if (o instanceof LocHash) {
                    LocHash l = (LocHash)o;
                    return l.x == this.x && l.z == this.z;
                }
                return false;
            }

            public int hashCode() {
                return (this.x ^ this.z) * 31 + 255;
            }

            public LocHash writeToNBT(String index, by nbt) {
                nbt.a(index + "locx", this.x);
                nbt.a(index + "locz", this.z);
                return this;
            }

            public LocHash readFromNBT(String index, by nbt) {
                this.x = nbt.e(index + "locx");
                this.z = nbt.e(index + "locz");
                return this;
            }
        }
    }

    class RetroGenQueue {
        final abw w;
        final int chunkX;
        final int chunkZ;
        final IRetroGenerator gen;

        public RetroGenQueue(abw w, int chunkX, int chunkZ, IRetroGenerator gen) {
            this.w = w;
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            this.gen = gen;
        }
    }
}

