/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class PRVersionChecker
extends Thread
implements ITickHandler {
    public boolean isOutdated = false;
    public String newVersion;
    public List<String> changes = new ArrayList<String>();
    boolean run = false;
    boolean displayed = false;

    public PRVersionChecker() {
        this.setName("PR Version Checker");
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        if (this.run) {
            return;
        }
        this.run = true;
        try {
            String changelog;
            String version;
            String current = "4.2.2";
            if (current.contains("@")) {
                return;
            }
            URL url = new URL("https://raw.github.com/MrTJP/ProjectRed/master/resources/Changelog");
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((version = reader.readLine()) != null) {
                if (!version.startsWith("v")) continue;
                this.newVersion = version.substring(1);
                break;
            }
            while ((changelog = reader.readLine()) != null && changelog.startsWith("-")) {
                this.changes.add(changelog);
            }
            this.isOutdated = !current.equals(this.newVersion);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        if (!this.isOutdated || this.displayed) {
            return;
        }
        uf p = (uf)tickData[0];
        p.a("Version " + this.newVersion + " of ProjectRed available.");
        for (String s : this.changes) {
            p.a(s);
        }
        this.displayed = true;
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.PLAYER);
    }

    public String getLabel() {
        return "PR Version Checker";
    }
}

