/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import codechicken.lib.packet.PacketCustom;
import codechicken.multipart.MultiPartRegistry;
import codechicken.multipart.TMultiPart;
import mrtjp.projectred.ProjectRedTransportation;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.IProxy;
import mrtjp.projectred.transportation.BasicPipePart;
import mrtjp.projectred.transportation.ItemPartPipe;
import mrtjp.projectred.transportation.ItemRouterUtility;
import mrtjp.projectred.transportation.ItemRoutingChip;
import mrtjp.projectred.transportation.RoutedCraftingPipePart;
import mrtjp.projectred.transportation.RoutedExtensionPipePart;
import mrtjp.projectred.transportation.RoutedInterfacePipePart;
import mrtjp.projectred.transportation.RoutedJunctionPipePart;
import mrtjp.projectred.transportation.RoutedRequestPipePart;
import mrtjp.projectred.transportation.TableUpdateThread;
import mrtjp.projectred.transportation.TransportationRecipes;
import mrtjp.projectred.transportation.TransportationSPH;

public class TransportationProxy
implements IProxy,
MultiPartRegistry.IPartFactory {
    public void preinit() {
        PacketCustom.assignHandler((Object)TransportationSPH.channel, (PacketCustom.ICustomPacketHandler)new TransportationSPH());
    }

    public void init() {
        MultiPartRegistry.registerParts((MultiPartRegistry.IPartFactory)this, (String[])new String[]{"pr_ptube", "pr_rbasic", "pr_rinterface", "pr_rcrafting", "pr_rrequest", "pr_rextension"});
        ProjectRedTransportation.itemPartPipe = new ItemPartPipe(Configurator.part_pipe.getInt());
        ProjectRedTransportation.itemRoutingChip = new ItemRoutingChip(Configurator.item_routingChipID.getInt());
        ProjectRedTransportation.itemRouterUtility = new ItemRouterUtility(Configurator.item_routerUtilID.getInt());
        for (int i = 0; i < Configurator.routerUpdateThreadCount; ++i) {
            new TableUpdateThread(i);
        }
    }

    public void postinit() {
        TransportationRecipes.initRecipes();
    }

    public TMultiPart createPart(String id, boolean arg1) {
        if (id.equals("pr_ptube")) {
            return new BasicPipePart();
        }
        if (id.equals("pr_rbasic")) {
            return new RoutedJunctionPipePart();
        }
        if (id.equals("pr_rinterface")) {
            return new RoutedInterfacePipePart();
        }
        if (id.equals("pr_rcrafting")) {
            return new RoutedCraftingPipePart();
        }
        if (id.equals("pr_rrequest")) {
            return new RoutedRequestPipePart();
        }
        if (id.equals("pr_rextension")) {
            return new RoutedExtensionPipePart();
        }
        return null;
    }
}

